/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSource;
import org.jetbrains.annotations.Nullable;

public class CheckpointMetricSource
implements MetricSource {
    private final String name;
    private final Map<String, Metric> metrics = new HashMap<String, Metric>();
    private boolean enabled;

    public CheckpointMetricSource(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String group() {
        return "storage";
    }

    synchronized <T extends Metric> T addMetric(T metric) {
        assert (!this.enabled) : "Cannot add metrics when source is enabled";
        this.metrics.put(metric.name(), metric);
        return metric;
    }

    @Nullable
    public synchronized MetricSet enable() {
        if (this.enabled) {
            return null;
        }
        this.enabled = true;
        return new MetricSet(this.name, this.description(), this.group(), Map.copyOf(this.metrics));
    }

    public synchronized void disable() {
        this.enabled = false;
    }

    public synchronized boolean enabled() {
        return this.enabled;
    }
}

