/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver.leases;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

final class NodesDictionary {
    private final List<String> nameIndexToName = new ArrayList<String>();
    private final Object2IntMap<String> nameToNameIndex = new Object2IntOpenHashMap();
    private final List<UUID> nodeIndexToId = new ArrayList<UUID>();
    private final Object2IntMap<UUID> idToNodeIndex = new Object2IntOpenHashMap();
    private final Object2IntMap<UUID> idToNameIndex = new Object2IntOpenHashMap();

    NodesDictionary() {
        this.nameToNameIndex.defaultReturnValue(-1);
        this.idToNodeIndex.defaultReturnValue(-1);
        this.idToNameIndex.defaultReturnValue(-1);
    }

    int putNode(UUID id, String name) {
        if (this.idToNodeIndex.containsKey((Object)id)) {
            return this.idToNodeIndex.getInt((Object)id);
        }
        int nameIndex = this.putName(name);
        int nodeIndex = this.idToNodeIndex.size();
        this.nodeIndexToId.add(id);
        this.idToNodeIndex.put((Object)id, nodeIndex);
        this.idToNameIndex.put((Object)id, nameIndex);
        return nodeIndex;
    }

    int putName(String name) {
        int nameIndex;
        if (this.nameToNameIndex.containsKey((Object)name)) {
            nameIndex = this.nameToNameIndex.getInt((Object)name);
        } else {
            nameIndex = this.nameIndexToName.size();
            this.nameIndexToName.add(name);
            this.nameToNameIndex.put((Object)name, nameIndex);
        }
        return nameIndex;
    }

    String getName(int nameIndex) {
        return this.nameIndexToName.get(nameIndex);
    }

    UUID getNodeId(int nodeIndex) {
        return this.nodeIndexToId.get(nodeIndex);
    }

    String getNodeName(int nodeIndex) {
        UUID id = this.getNodeId(nodeIndex);
        int nameIndex = this.idToNameIndex.getInt((Object)id);
        return this.getName(nameIndex);
    }

    int getNameIndex(String name) {
        return this.nameToNameIndex.getInt((Object)name);
    }

    int getNodeIndex(UUID leaseHolderId) {
        return this.idToNodeIndex.getInt((Object)leaseHolderId);
    }

    void writeTo(IgniteDataOutput out) throws IOException {
        out.writeVarInt((long)this.nameIndexToName.size());
        for (String name : this.nameIndexToName) {
            out.writeUTF(name);
        }
        out.writeVarInt((long)this.nodeIndexToId.size());
        for (UUID id : this.nodeIndexToId) {
            out.writeUuid(id);
            out.writeVarInt((long)this.idToNameIndex.getInt((Object)id));
        }
    }

    static NodesDictionary readFrom(IgniteDataInput in) throws IOException {
        NodesDictionary dict = new NodesDictionary();
        int namesCount = in.readVarIntAsInt();
        for (int i = 0; i < namesCount; ++i) {
            dict.putName(in.readUTF());
        }
        int nodesCount = in.readVarIntAsInt();
        for (int i = 0; i < nodesCount; ++i) {
            UUID id = in.readUuid();
            int nameIndex = in.readVarIntAsInt();
            String name = dict.nameIndexToName.get(nameIndex);
            dict.putNode(id, name);
        }
        return dict;
    }

    int nameCount() {
        return this.nameIndexToName.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodesDictionary that = (NodesDictionary)o;
        return this.nameIndexToName.equals(that.nameIndexToName) && this.nameToNameIndex.equals(that.nameToNameIndex) && this.nodeIndexToId.equals(that.nodeIndexToId) && this.idToNodeIndex.equals(that.idToNodeIndex) && this.idToNameIndex.equals(that.idToNameIndex);
    }

    public int hashCode() {
        int result = this.nameIndexToName.hashCode();
        result = 31 * result + this.nameToNameIndex.hashCode();
        result = 31 * result + this.nodeIndexToId.hashCode();
        result = 31 * result + this.idToNodeIndex.hashCode();
        result = 31 * result + this.idToNameIndex.hashCode();
        return result;
    }
}

