/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.TransferLeaderRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.TransferLeaderRequestSerializer;

public class TransferLeaderRequestImpl
implements CliRequests.TransferLeaderRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1008;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String leaderId;
    @IgniteToStringInclude
    private final String peerId;

    private TransferLeaderRequestImpl(String groupId, String leaderId, String peerId) {
        this.groupId = groupId;
        this.leaderId = leaderId;
        this.peerId = peerId;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    public MessageSerializer serializer() {
        return TransferLeaderRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(TransferLeaderRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 1008;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransferLeaderRequestImpl otherMessage = (TransferLeaderRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.leaderId, otherMessage.leaderId) && Objects.equals(this.peerId, otherMessage.peerId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.leaderId, this.peerId);
        return result;
    }

    public TransferLeaderRequestImpl clone() {
        try {
            return (TransferLeaderRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TransferLeaderRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements TransferLeaderRequestBuilder {
        private String groupId;
        private String leaderId;
        private String peerId;

        private Builder() {
        }

        @Override
        public TransferLeaderRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public TransferLeaderRequestBuilder leaderId(String leaderId) {
            Objects.requireNonNull(leaderId, "leaderId is not marked @Nullable");
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public TransferLeaderRequestBuilder peerId(String peerId) {
            Objects.requireNonNull(peerId, "peerId is not marked @Nullable");
            this.peerId = peerId;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public CliRequests.TransferLeaderRequest build() {
            return new TransferLeaderRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.leaderId, "leaderId is not marked @Nullable"), Objects.requireNonNull(this.peerId, "peerId is not marked @Nullable"));
        }
    }
}

