/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BooleanSupplier;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PageStoreWriter;
import org.apache.ignite.internal.pagememory.persistence.PartitionMeta;
import org.apache.ignite.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.WriteDirtyPage;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointDirtyPages;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointMetricsTracker;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.pagememory.persistence.io.PartitionMetaIo;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.util.IgniteConcurrentMultiPairQueue;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class CheckpointPagesWriter
implements Runnable {
    private static final IgniteLogger LOG = Loggers.forClass(CheckpointPagesWriter.class);
    private static final int CP_BUFFER_PAGES_BATCH_THRESHOLD = 10;
    private final CheckpointMetricsTracker tracker;
    private final IgniteConcurrentMultiPairQueue<PersistentPageMemory, GroupPartitionId> dirtyPartitionQueue;
    private final List<PersistentPageMemory> pageMemoryList;
    private final ConcurrentMap<GroupPartitionId, LongAdder> updatedPartitions;
    private final CompletableFuture<?> doneFut;
    private final Runnable updateHeartbeat;
    private final ThreadLocal<ByteBuffer> threadBuf;
    private final CheckpointProgressImpl checkpointProgress;
    private final WriteDirtyPage pageWriter;
    private final PageIoRegistry ioRegistry;
    private final PartitionMetaManager partitionMetaManager;
    private final BooleanSupplier shutdownNow;

    CheckpointPagesWriter(CheckpointMetricsTracker tracker, IgniteConcurrentMultiPairQueue<PersistentPageMemory, GroupPartitionId> dirtyPartitionQueue, List<PersistentPageMemory> pageMemoryList, ConcurrentMap<GroupPartitionId, LongAdder> updatedPartitions, CompletableFuture<?> doneFut, Runnable updateHeartbeat, ThreadLocal<ByteBuffer> threadBuf, CheckpointProgressImpl checkpointProgress, WriteDirtyPage pageWriter, PageIoRegistry ioRegistry, PartitionMetaManager partitionMetaManager, BooleanSupplier shutdownNow) {
        this.tracker = tracker;
        this.dirtyPartitionQueue = dirtyPartitionQueue;
        this.pageMemoryList = pageMemoryList;
        this.updatedPartitions = updatedPartitions;
        this.doneFut = doneFut;
        this.updateHeartbeat = updateHeartbeat;
        this.threadBuf = threadBuf;
        this.checkpointProgress = checkpointProgress;
        this.pageWriter = pageWriter;
        this.ioRegistry = ioRegistry;
        this.partitionMetaManager = partitionMetaManager;
        this.shutdownNow = shutdownNow;
    }

    @Override
    public void run() {
        try {
            Map<PersistentPageMemory, List<FullPageId>> pageIdsToRetry = new HashMap<PersistentPageMemory, List<FullPageId>>();
            ByteBuffer tmpWriteBuf = this.threadBuf.get();
            IgniteConcurrentMultiPairQueue.Result queueResult = new IgniteConcurrentMultiPairQueue.Result();
            while (!this.shutdownNow.getAsBoolean() && this.dirtyPartitionQueue.next(queueResult)) {
                this.updateHeartbeat.run();
                PersistentPageMemory pageMemory = (PersistentPageMemory)queueResult.getKey();
                PageStoreWriter pageStoreWriter = this.createPageStoreWriter(pageMemory, pageIdsToRetry);
                this.writeDirtyPages(pageMemory, (GroupPartitionId)queueResult.getValue(), tmpWriteBuf, pageStoreWriter);
            }
            while (!this.shutdownNow.getAsBoolean() && !pageIdsToRetry.isEmpty()) {
                this.updateHeartbeat.run();
                pageIdsToRetry = this.writeRetryDirtyPages(pageIdsToRetry, tmpWriteBuf);
            }
            this.doneFut.complete(null);
        }
        catch (Throwable e) {
            this.doneFut.completeExceptionally(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDirtyPages(PersistentPageMemory pageMemory, GroupPartitionId partitionId, ByteBuffer tmpWriteBuf, PageStoreWriter pageStoreWriter) throws IgniteInternalCheckedException {
        CheckpointDirtyPages.CheckpointDirtyPagesView checkpointDirtyPagesView = this.checkpointDirtyPagesView(pageMemory, partitionId);
        this.checkpointProgress.blockPartitionDestruction(partitionId);
        try {
            if (this.shouldWriteMetaPage(partitionId)) {
                this.writePartitionMeta(pageMemory, partitionId, tmpWriteBuf.rewind());
            }
            for (int i = 0; i < checkpointDirtyPagesView.size() && !this.shutdownNow.getAsBoolean(); ++i) {
                this.updateHeartbeat.run();
                FullPageId pageId = checkpointDirtyPagesView.get(i);
                if (pageId.pageIdx() == 0) continue;
                this.writeDirtyPage(pageMemory, pageId, tmpWriteBuf, pageStoreWriter);
            }
        }
        finally {
            this.checkpointProgress.unblockPartitionDestruction(partitionId);
        }
    }

    private void writeDirtyPage(PersistentPageMemory pageMemory, FullPageId pageId, ByteBuffer tmpWriteBuf, PageStoreWriter pageStoreWriter) throws IgniteInternalCheckedException {
        pageMemory.checkpointWritePage(pageId, tmpWriteBuf.rewind(), pageStoreWriter, this.tracker);
        this.drainCheckpointBuffers(tmpWriteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PersistentPageMemory, List<FullPageId>> writeRetryDirtyPages(Map<PersistentPageMemory, List<FullPageId>> pageIdsToRetry, ByteBuffer tmpWriteBuf) throws IgniteInternalCheckedException {
        if (LOG.isInfoEnabled()) {
            int pageCount = pageIdsToRetry.values().stream().mapToInt(List::size).sum();
            LOG.info("Checkpoint pages were not written yet due to unsuccessful page write lock acquisition and will be retried [pageCount={}]", new Object[]{pageCount});
        }
        HashMap<PersistentPageMemory, List<FullPageId>> newPageIdsToRetry = new HashMap<PersistentPageMemory, List<FullPageId>>();
        for (Map.Entry<PersistentPageMemory, List<FullPageId>> entry : pageIdsToRetry.entrySet()) {
            PersistentPageMemory pageMemory = entry.getKey();
            PageStoreWriter pageStoreWriter = this.createPageStoreWriter(pageMemory, newPageIdsToRetry);
            GroupPartitionId partitionId = null;
            try {
                for (FullPageId pageId : entry.getValue()) {
                    if (this.shutdownNow.getAsBoolean()) {
                        Map<PersistentPageMemory, List<FullPageId>> map = Map.of();
                        return map;
                    }
                    this.updateHeartbeat.run();
                    if (CheckpointPagesWriter.partitionIdChanged(partitionId, pageId)) {
                        if (partitionId != null) {
                            this.checkpointProgress.unblockPartitionDestruction(partitionId);
                        }
                        partitionId = GroupPartitionId.convert(pageId);
                        this.checkpointProgress.blockPartitionDestruction(partitionId);
                    }
                    this.writeDirtyPage(pageMemory, pageId, tmpWriteBuf, pageStoreWriter);
                }
            }
            finally {
                if (partitionId == null) continue;
                this.checkpointProgress.unblockPartitionDestruction(partitionId);
            }
        }
        return newPageIdsToRetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainCheckpointBuffers(ByteBuffer tmpWriteBuf) throws IgniteInternalCheckedException {
        boolean retry = true;
        while (retry) {
            retry = false;
            block4: for (PersistentPageMemory pageMemory : this.pageMemoryList) {
                int count = 0;
                PageStoreWriter pageStoreWriter = this.createPageStoreWriter(pageMemory, null);
                while (pageMemory.isCpBufferOverflowThresholdExceeded()) {
                    if (++count >= 10) {
                        retry = true;
                        continue block4;
                    }
                    this.updateHeartbeat.run();
                    FullPageId cpPageId = pageMemory.pullPageFromCpBuffer();
                    if (cpPageId.equals(FullPageId.NULL_PAGE)) continue block4;
                    GroupPartitionId partitionId = GroupPartitionId.convert(cpPageId);
                    this.checkpointProgress.blockPartitionDestruction(partitionId);
                    try {
                        if (this.shouldWriteMetaPage(partitionId)) {
                            this.writePartitionMeta(pageMemory, partitionId, tmpWriteBuf.rewind());
                        }
                        pageMemory.checkpointWritePage(cpPageId, tmpWriteBuf.rewind(), pageStoreWriter, this.tracker);
                    }
                    finally {
                        this.checkpointProgress.unblockPartitionDestruction(partitionId);
                    }
                }
            }
        }
    }

    private boolean shouldWriteMetaPage(GroupPartitionId partitionId) {
        return !this.updatedPartitions.containsKey(partitionId) && null == this.updatedPartitions.putIfAbsent(partitionId, new LongAdder());
    }

    private PageStoreWriter createPageStoreWriter(PersistentPageMemory pageMemory, @Nullable Map<PersistentPageMemory, List<FullPageId>> pagesToRetry) {
        return (fullPageId, buf, tag) -> {
            if (tag == -1) {
                if (pagesToRetry != null) {
                    pagesToRetry.computeIfAbsent(pageMemory, k -> new ArrayList()).add(fullPageId);
                }
                return;
            }
            long pageId = fullPageId.pageId();
            assert (PageIo.getType(buf) != 0) : "Invalid state. Type is 0! pageId = " + StringUtils.hexLong((long)pageId);
            assert (PageIo.getVersion(buf) != 0) : "Invalid state. Version is 0! pageId = " + StringUtils.hexLong((long)pageId);
            assert (fullPageId.pageIdx() != 0) : "Invalid pageIdx. Index is 0! pageId = " + StringUtils.hexLong((long)pageId);
            assert (!(this.ioRegistry.resolve(buf) instanceof PartitionMetaIo)) : "Invalid IO type. pageId = " + StringUtils.hexLong((long)pageId);
            if (PageIdUtils.flag(pageId) == 1) {
                this.tracker.onDataPageWritten();
            }
            this.checkpointProgress.writtenPagesCounter().incrementAndGet();
            this.pageWriter.write(pageMemory, fullPageId, buf);
            ((LongAdder)this.updatedPartitions.get(GroupPartitionId.convert(fullPageId))).increment();
        };
    }

    private void writePartitionMeta(PersistentPageMemory pageMemory, GroupPartitionId partitionId, ByteBuffer buffer) throws IgniteInternalCheckedException {
        PartitionMeta partitionMeta = this.partitionMetaManager.getMeta(partitionId);
        if (partitionMeta == null) {
            return;
        }
        PartitionMeta.PartitionMetaSnapshot partitionMetaSnapshot = partitionMeta.metaSnapshot(this.checkpointProgress.id());
        this.partitionMetaManager.writeMetaToBuffer(partitionId, partitionMetaSnapshot, buffer.rewind());
        FullPageId fullPageId = new FullPageId(PartitionMeta.partitionMetaPageId(partitionId.getPartitionId()), partitionId.getGroupId());
        this.pageWriter.write(pageMemory, fullPageId, buffer.rewind());
        this.checkpointProgress.writtenPagesCounter().incrementAndGet();
        ((LongAdder)this.updatedPartitions.get(partitionId)).increment();
        this.updateHeartbeat.run();
    }

    private CheckpointDirtyPages.CheckpointDirtyPagesView checkpointDirtyPagesView(PersistentPageMemory pageMemory, GroupPartitionId partitionId) {
        CheckpointDirtyPages checkpointDirtyPages = this.checkpointProgress.pagesToWrite();
        assert (checkpointDirtyPages != null);
        CheckpointDirtyPages.CheckpointDirtyPagesView partitionView = checkpointDirtyPages.getPartitionView(pageMemory, partitionId.getGroupId(), partitionId.getPartitionId());
        assert (partitionView != null) : String.format("Unable to find view for dirty pages: [patitionId=%s, pageMemory=%s]", partitionId, pageMemory);
        return partitionView;
    }

    private static boolean partitionIdChanged(@Nullable GroupPartitionId partitionId, FullPageId pageId) {
        return partitionId == null || partitionId.getGroupId() != pageId.groupId() || partitionId.getPartitionId() != pageId.partitionId();
    }
}

