/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.http.client.sse;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.sse.SseClientRegistry;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.reactor.http.client.ReactorSseClient;
import io.micronaut.reactor.http.client.sse.BridgedReactorSseClient;

@Factory
public class ReactorSseClientFactory {
    private final SseClientRegistry<?> clientRegistry;

    public ReactorSseClientFactory(SseClientRegistry<?> clientRegistry) {
        this.clientRegistry = clientRegistry;
    }

    @Bean
    @Secondary
    protected ReactorSseClient sseClient(@Nullable InjectionPoint<?> injectionPoint, @Parameter @Nullable LoadBalancer loadBalancer, @Parameter @Nullable HttpClientConfiguration configuration, @NonNull BeanContext beanContext) {
        return new BridgedReactorSseClient(this.clientRegistry.resolveSseClient(injectionPoint, loadBalancer, configuration, beanContext));
    }
}

