/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.scan;

import io.micronaut.core.annotation.NonNull;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;

public interface AnnotationScanner {
    @NonNull
    public Stream<Class<?>> scan(@NonNull String var1, @NonNull String var2);

    @NonNull
    default public Stream<Class<?>> scan(@NonNull String annotation, Package ... packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return ((Stream)Arrays.stream(packages).parallel()).flatMap(pkg -> this.scan(annotation, pkg.getName()));
    }

    @NonNull
    default public Stream<Class<?>> scan(@NonNull Class<? extends Annotation> annotation, Package ... packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return this.scan(annotation.getName(), packages);
    }

    @NonNull
    default public Stream<Class<?>> scan(@NonNull Class<? extends Annotation> annotation, @NonNull Package pkg) {
        return this.scan(annotation.getName(), pkg.getName());
    }

    @NonNull
    default public Stream<Class<?>> scan(@NonNull String annotation, String ... packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        Stream<String> stream = Arrays.stream(packages);
        return this.scan(annotation, stream);
    }

    @NonNull
    default public Stream<Class<?>> scan(@NonNull String annotation, @NonNull Collection<String> packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return this.scan(annotation, packages.parallelStream());
    }

    @NonNull
    default public Stream<Class<?>> scan(@NonNull Class<? extends Annotation> annotation, @NonNull Collection<String> packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return this.scan(annotation.getName(), packages.parallelStream());
    }

    @NonNull
    default public Stream<Class<?>> scan(@NonNull String annotation, @NonNull Stream<String> packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return ((Stream)packages.parallel()).flatMap(pkg -> this.scan(annotation, (String)pkg));
    }

    @NonNull
    default public Stream<Class<?>> scan(@NonNull Class<? extends Annotation> annotation, String ... packages) {
        Objects.requireNonNull(annotation, "Annotation type cannot be null");
        Objects.requireNonNull(packages, "Packages to scan cannot be null");
        return this.scan(annotation.getName(), packages);
    }
}

