/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite.internal.cli.core.repl.Session;

@Singleton
public class NodeUrlProvider {
    private final Session session;
    private final ConfigManagerProvider configManagerProvider;

    public NodeUrlProvider(Session session, ConfigManagerProvider configManagerProvider) {
        this.session = session;
        this.configManagerProvider = configManagerProvider;
    }

    public String resolveUrl(String[] words) {
        String urlInWords = this.findClusterUrlIn(words);
        if (urlInWords != null) {
            return urlInWords;
        }
        if (this.session.isConnectedToNode()) {
            return this.session.nodeUrl();
        }
        return this.configManagerProvider.get().getCurrentProperty("ignite.cluster-endpoint-url");
    }

    private String findClusterUrlIn(String[] words) {
        for (String word : words) {
            String prefix = "--cluster-endpoint-url=";
            if (!word.startsWith(prefix)) continue;
            return word.substring(prefix.length());
        }
        return null;
    }
}

