/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.List;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;

public class GridSqlSortColumn {
    private final int col;
    private final boolean asc;
    private final boolean nullsFirst;
    private final boolean nullsLast;

    public GridSqlSortColumn(int col, boolean asc, boolean nullsFirst, boolean nullsLast) {
        this.col = col;
        this.asc = asc;
        this.nullsFirst = nullsFirst;
        this.nullsLast = nullsLast;
    }

    public static IndexColumn[] toIndexColumns(Table tbl, List<GridSqlSortColumn> sortCols) {
        assert (!F.isEmpty(sortCols));
        IndexColumn[] res = new IndexColumn[sortCols.size()];
        for (int i = 0; i < res.length; ++i) {
            GridSqlSortColumn sc = sortCols.get(i);
            Column col = tbl.getColumn(sc.column());
            IndexColumn c = new IndexColumn();
            c.column = col;
            c.columnName = col.getName();
            int n = c.sortType = sc.asc ? 0 : 1;
            if (sc.nullsFirst) {
                c.sortType |= 2;
            }
            if (sc.nullsLast) {
                c.sortType |= 4;
            }
            res[i] = c;
        }
        return res;
    }

    public int column() {
        return this.col;
    }

    public boolean asc() {
        return this.asc;
    }

    public boolean nullsFirst() {
        return this.nullsFirst;
    }

    public boolean nullsLast() {
        return this.nullsLast;
    }
}

