/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.service.ServiceInfo;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;

public class ServiceView {
    private final ServiceInfo serviceInfo;

    public ServiceView(ServiceInfo serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    @Order(value=1)
    public String name() {
        return this.serviceInfo.name();
    }

    @Order
    public IgniteUuid serviceId() {
        return this.serviceInfo.serviceId();
    }

    @Order(value=2)
    public Class<?> serviceClass() {
        return this.serviceInfo.serviceClass();
    }

    @Order(value=5)
    public int totalCount() {
        return this.serviceInfo.totalCount();
    }

    @Order(value=6)
    public int maxPerNodeCount() {
        return this.serviceInfo.maxPerNodeCount();
    }

    @Order(value=3)
    public String cacheName() {
        return this.serviceInfo.cacheName();
    }

    public String affinityKey() {
        Object affKey = this.serviceInfo.configuration().getAffinityKey();
        return affKey == null ? null : affKey.toString();
    }

    public Class<?> nodeFilter() {
        IgnitePredicate<ClusterNode> filter = this.serviceInfo.configuration().getNodeFilter();
        return filter == null ? null : filter.getClass();
    }

    public boolean staticallyConfigured() {
        return this.serviceInfo.staticallyConfigured();
    }

    @Order(value=4)
    public UUID originNodeId() {
        return this.serviceInfo.originNodeId();
    }

    public Map<UUID, Integer> topologySnapshot() {
        return this.serviceInfo.topologySnapshot();
    }
}

