/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionAllNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionClientContext;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionCompositeNodeOperator;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionConstantNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionGroupNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionNoneNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionSingleNode;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PartitionCompositeNode
implements PartitionNode {
    @GridToStringInclude
    private final PartitionNode left;
    @GridToStringInclude
    private final PartitionNode right;
    private final PartitionCompositeNodeOperator op;

    public PartitionCompositeNode(PartitionNode left, PartitionNode right, PartitionCompositeNodeOperator op) {
        this.left = left;
        this.right = right;
        this.op = op;
    }

    @Override
    public Collection<Integer> apply(PartitionClientContext cliCtx, Object ... args) throws IgniteCheckedException {
        Collection<Integer> leftParts = this.left.apply(cliCtx, args);
        Collection<Integer> rightParts = this.right.apply(cliCtx, args);
        if (leftParts == null && rightParts == null) {
            return null;
        }
        if (this.op == PartitionCompositeNodeOperator.AND) {
            if (leftParts == null) {
                return rightParts;
            }
            if (rightParts == null) {
                return leftParts;
            }
            leftParts = new HashSet<Integer>(leftParts);
            leftParts.retainAll(rightParts);
        } else {
            assert (this.op == PartitionCompositeNodeOperator.OR);
            if (leftParts == null || rightParts == null) {
                return null;
            }
            leftParts = new HashSet<Integer>(leftParts);
            leftParts.addAll(rightParts);
        }
        return leftParts;
    }

    @Override
    public int joinGroup() {
        return this.left.joinGroup();
    }

    @Override
    public PartitionNode optimize() {
        PartitionNode left = this.left;
        PartitionNode right = this.right;
        if (left instanceof PartitionCompositeNode) {
            left = left.optimize();
        }
        if (right instanceof PartitionCompositeNode) {
            right = right.optimize();
        }
        if (left == PartitionAllNode.INSTANCE || left == PartitionNoneNode.INSTANCE) {
            return this.optimizeSpecial(left, right);
        }
        if (right == PartitionAllNode.INSTANCE || right == PartitionNoneNode.INSTANCE) {
            return this.optimizeSpecial(right, left);
        }
        if (left instanceof PartitionCompositeNode || right instanceof PartitionCompositeNode) {
            if (left.joinGroup() != right.joinGroup()) {
                return PartitionAllNode.INSTANCE;
            }
            return new PartitionCompositeNode(left, right, this.op);
        }
        if (left instanceof PartitionGroupNode) {
            return this.optimizeGroup((PartitionGroupNode)left, right);
        }
        if (right instanceof PartitionGroupNode) {
            return this.optimizeGroup((PartitionGroupNode)right, left);
        }
        assert (left instanceof PartitionSingleNode);
        assert (right instanceof PartitionSingleNode);
        return this.optimizeSimple((PartitionSingleNode)left, (PartitionSingleNode)right);
    }

    private PartitionNode optimizeSpecial(PartitionNode left, PartitionNode right) {
        if (left == PartitionAllNode.INSTANCE) {
            if (this.op == PartitionCompositeNodeOperator.OR) {
                return PartitionAllNode.INSTANCE;
            }
            assert (this.op == PartitionCompositeNodeOperator.AND);
            return right;
        }
        assert (left == PartitionNoneNode.INSTANCE);
        if (this.op == PartitionCompositeNodeOperator.OR) {
            return right;
        }
        assert (this.op == PartitionCompositeNodeOperator.AND);
        return PartitionNoneNode.INSTANCE;
    }

    private PartitionNode optimizeGroup(PartitionGroupNode left, PartitionNode right) {
        if (this.op == PartitionCompositeNodeOperator.AND) {
            return this.optimizeGroupAnd(left, right);
        }
        assert (this.op == PartitionCompositeNodeOperator.OR);
        return this.optimizeGroupOr(left, right);
    }

    private PartitionNode optimizeGroupAnd(PartitionGroupNode left, PartitionNode right) {
        PartitionGroupNode right0;
        assert (this.op == PartitionCompositeNodeOperator.AND);
        if (left.joinGroup() != right.joinGroup()) {
            return PartitionAllNode.INSTANCE;
        }
        if (right instanceof PartitionGroupNode && left.containsExact((right0 = (PartitionGroupNode)right).siblings())) {
            return left;
        }
        if (left.constantsOnly()) {
            PartitionGroupNode right02;
            HashSet<PartitionSingleNode> consts = new HashSet<PartitionSingleNode>(left.siblings());
            Set<PartitionSingleNode> rightConsts = null;
            if (right instanceof PartitionConstantNode) {
                rightConsts = Collections.singleton((PartitionSingleNode)right);
            } else if (right instanceof PartitionGroupNode && (right02 = (PartitionGroupNode)right).constantsOnly()) {
                rightConsts = right02.siblings();
            }
            if (rightConsts != null) {
                boolean sameTbl = true;
                String curTblAlias = null;
                for (PartitionSingleNode curConst : consts) {
                    if (curTblAlias == null) {
                        curTblAlias = curConst.table().alias();
                        continue;
                    }
                    if (F.eq(curTblAlias, curConst.table().alias())) continue;
                    sameTbl = false;
                    break;
                }
                if (sameTbl) {
                    for (PartitionSingleNode curConst : rightConsts) {
                        if (curTblAlias == null) {
                            curTblAlias = curConst.table().alias();
                            continue;
                        }
                        if (F.eq(curTblAlias, curConst.table().alias())) continue;
                        sameTbl = false;
                        break;
                    }
                }
                if (sameTbl) {
                    consts.retainAll(rightConsts);
                    if (consts.isEmpty()) {
                        return PartitionNoneNode.INSTANCE;
                    }
                    if (consts.size() == 1) {
                        return (PartitionNode)consts.iterator().next();
                    }
                    return new PartitionGroupNode(consts);
                }
            }
        }
        return new PartitionCompositeNode(left, right, PartitionCompositeNodeOperator.AND);
    }

    private PartitionNode optimizeGroupOr(PartitionGroupNode left, PartitionNode right) {
        assert (this.op == PartitionCompositeNodeOperator.OR);
        if (left.joinGroup() != right.joinGroup()) {
            return PartitionAllNode.INSTANCE;
        }
        HashSet<PartitionSingleNode> siblings = new HashSet<PartitionSingleNode>(left.siblings());
        if (right instanceof PartitionSingleNode) {
            siblings.add((PartitionSingleNode)right);
        } else {
            assert (right instanceof PartitionGroupNode);
            siblings.addAll(((PartitionGroupNode)right).siblings());
        }
        return new PartitionGroupNode(siblings);
    }

    private PartitionNode optimizeSimple(PartitionSingleNode left, PartitionSingleNode right) {
        if (this.op == PartitionCompositeNodeOperator.AND) {
            return this.optimizeSimpleAnd(left, right);
        }
        assert (this.op == PartitionCompositeNodeOperator.OR);
        return this.optimizeSimpleOr(left, right);
    }

    private PartitionNode optimizeSimpleAnd(PartitionSingleNode left, PartitionSingleNode right) {
        assert (this.op == PartitionCompositeNodeOperator.AND);
        if (left.joinGroup() != right.joinGroup()) {
            return PartitionAllNode.INSTANCE;
        }
        if (left.equals(right)) {
            return left;
        }
        if (left.constant() && right.constant() && F.eq(left.table().alias(), right.table().alias())) {
            return PartitionNoneNode.INSTANCE;
        }
        return new PartitionCompositeNode(left, right, PartitionCompositeNodeOperator.AND);
    }

    private PartitionNode optimizeSimpleOr(PartitionSingleNode left, PartitionSingleNode right) {
        assert (this.op == PartitionCompositeNodeOperator.OR);
        if (left.joinGroup() != right.joinGroup()) {
            return PartitionAllNode.INSTANCE;
        }
        if (left.equals(right)) {
            return left;
        }
        HashSet<PartitionSingleNode> nodes = new HashSet<PartitionSingleNode>();
        nodes.add(left);
        nodes.add(right);
        return new PartitionGroupNode(nodes);
    }

    public PartitionNode left() {
        return this.left;
    }

    public PartitionNode right() {
        return this.right;
    }

    public PartitionCompositeNodeOperator operator() {
        return this.op;
    }

    public String toString() {
        return S.toString(PartitionCompositeNode.class, this);
    }

    @Override
    public String cacheName() {
        String leftCacheName = this.left.cacheName();
        return leftCacheName != null ? leftCacheName : this.right.cacheName();
    }
}

