/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cluster;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.processors.platform.client.ClientBitmaskFeature;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ClientClusterChangeStateRequest
extends ClientRequest {
    private final ClusterState state;
    private final boolean forceDeactivation;

    public ClientClusterChangeStateRequest(BinaryRawReader reader, ClientProtocolContext protocolCtx) {
        super(reader);
        this.state = ClusterState.fromOrdinal(reader.readByte());
        this.forceDeactivation = !protocolCtx.isFeatureSupported(ClientBitmaskFeature.FORCE_DEACTIVATION_FLAG) || reader.readBoolean();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        try {
            ctx.kernalContext().state().changeGlobalState(this.state, this.forceDeactivation, ctx.kernalContext().cluster().get().forServers().nodes(), false).get();
            return new ClientResponse(this.requestId());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }
}

