/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.ThinClientConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.binary.BinaryCachingMetadataHandler;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.odbc.ClientConnectionNodeRecoveryException;
import org.apache.ignite.internal.processors.odbc.ClientListenerAsyncResponse;
import org.apache.ignite.internal.processors.odbc.ClientListenerConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerMetrics;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientMessage;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioServerListenerAdapter;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ClientListenerNioListener
extends GridNioServerListenerAdapter<ClientMessage> {
    public static final byte ODBC_CLIENT = 0;
    public static final byte JDBC_CLIENT = 1;
    public static final byte THIN_CLIENT = 2;
    public static final byte[] CLI_TYPES = new byte[]{0, 1, 2};
    public static final int CONN_CTX_HANDSHAKE_TIMEOUT_TASK = GridNioSessionMetaKey.nextUniqueKey();
    public static final int CONN_CTX_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    public static final String MANAGEMENT_CLIENT_ATTR = "ignite.internal.management-client";
    public static final long MANAGEMENT_CONNECTION_SHIFTED_ID = -1L;
    private static AtomicInteger nextConnId = new AtomicInteger(1);
    private final GridSpinBusyLock busyLock;
    private final GridKernalContext ctx;
    private final int maxCursors;
    private final IgniteLogger log;
    private final ClientConnectorConfiguration cliConnCfg;
    private final ThinClientConfiguration thinCfg;
    private final ClientListenerMetrics metrics;

    public ClientListenerNioListener(GridKernalContext ctx, GridSpinBusyLock busyLock, ClientConnectorConfiguration cliConnCfg, ClientListenerMetrics metrics) {
        assert (cliConnCfg != null);
        this.ctx = ctx;
        this.busyLock = busyLock;
        this.cliConnCfg = cliConnCfg;
        this.maxCursors = cliConnCfg.getMaxOpenCursorsPerConnection();
        this.log = ctx.log(this.getClass());
        this.thinCfg = cliConnCfg.getThinClientConfiguration() == null ? new ThinClientConfiguration() : new ThinClientConfiguration(cliConnCfg.getThinClientConfiguration());
        this.metrics = metrics;
    }

    @Override
    public void onConnected(GridNioSession ses) {
        long handshakeTimeout;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Client connected: " + ses.remoteAddress());
        }
        if ((handshakeTimeout = this.cliConnCfg.getHandshakeTimeout()) > 0L) {
            this.scheduleHandshakeTimeout(ses, handshakeTimeout);
        }
    }

    @Override
    public void onDisconnected(GridNioSession ses, @Nullable Exception e) {
        ClientListenerConnectionContext connCtx = (ClientListenerConnectionContext)ses.meta(CONN_CTX_META_KEY);
        if (connCtx != null) {
            connCtx.onDisconnected();
        }
        if (this.log.isDebugEnabled()) {
            if (e == null) {
                this.log.debug("Client disconnected: " + ses.remoteAddress());
            } else {
                this.log.debug("Client disconnected due to an error [addr=" + ses.remoteAddress() + ", err=" + e + "]");
            }
        }
    }

    @Override
    public void onMessage(GridNioSession ses, ClientMessage msg) {
        ClientListenerRequest req;
        assert (msg != null);
        ClientListenerConnectionContext connCtx = (ClientListenerConnectionContext)ses.meta(CONN_CTX_META_KEY);
        if (connCtx == null) {
            try {
                this.onHandshake(ses, msg);
            }
            catch (Exception e) {
                U.error(this.log, "Failed to handle handshake request (probably, connection has already been closed).", e);
            }
            return;
        }
        ClientListenerMessageParser parser = connCtx.parser();
        ClientListenerRequestHandler hnd = connCtx.handler();
        try {
            req = parser.decode(msg);
        }
        catch (Exception e) {
            try {
                hnd.unregisterRequest(parser.decodeRequestId(msg));
            }
            catch (Exception e1) {
                U.error(this.log, "Failed to unregister request.", e1);
            }
            U.error(this.log, "Failed to parse client request.", e);
            ses.close();
            return;
        }
        assert (req != null);
        try {
            ClientListenerResponse resp;
            long startTime;
            if (this.log.isTraceEnabled()) {
                startTime = System.nanoTime();
                this.log.trace("Client request received [reqId=" + req.requestId() + ", addr=" + ses.remoteAddress() + ", req=" + req + "]");
            } else {
                startTime = 0L;
            }
            try (OperationSecurityContext ignored = this.ctx.security().withContext(connCtx.securityContext());){
                resp = hnd.handle(req);
            }
            if (resp != null) {
                if (resp instanceof ClientListenerAsyncResponse) {
                    ((ClientListenerAsyncResponse)((Object)resp)).future().listen(fut -> {
                        try {
                            this.handleResponse(req, (ClientListenerResponse)fut.get(), startTime, ses, parser);
                        }
                        catch (Throwable e) {
                            this.handleError(req, e, ses, parser, hnd);
                        }
                    });
                } else {
                    this.handleResponse(req, resp, startTime, ses, parser);
                }
            }
        }
        catch (Throwable e) {
            this.handleError(req, e, ses, parser, hnd);
        }
    }

    private void handleResponse(ClientListenerRequest req, ClientListenerResponse resp, long startTime, GridNioSession ses, ClientListenerMessageParser parser) {
        if (this.log.isTraceEnabled()) {
            long dur = (System.nanoTime() - startTime) / 1000L;
            this.log.trace("Client request processed [reqId=" + req.requestId() + ", dur(mcs)=" + dur + ", resp=" + resp.status() + "]");
        }
        GridNioFuture<?> fut = ses.send(parser.encode(resp));
        fut.listen(() -> {
            if (fut.error() == null) {
                resp.onSent();
            }
        });
    }

    private void handleError(ClientListenerRequest req, Throwable e, GridNioSession ses, ClientListenerMessageParser parser, ClientListenerRequestHandler hnd) {
        hnd.unregisterRequest(req.requestId());
        if (e instanceof Error) {
            U.error(this.log, "Failed to process client request [req=" + req + ", msg=" + e.getMessage() + "]", e);
        } else {
            U.warn(this.log, "Failed to process client request [req=" + req + ", msg=" + e.getMessage() + "]", e);
        }
        ses.send(parser.encode(hnd.handleException(e, req)));
        if (e instanceof Error) {
            throw (Error)e;
        }
    }

    @Override
    public void onSessionIdleTimeout(GridNioSession ses) {
        ses.close();
    }

    @Override
    public void onFailure(FailureType failureType, Throwable failure) {
        if (failure instanceof OutOfMemoryError) {
            this.ctx.failure().process(new FailureContext(failureType, failure));
        }
    }

    private void scheduleHandshakeTimeout(final GridNioSession ses, final long handshakeTimeout) {
        assert (handshakeTimeout > 0L);
        GridTimeoutProcessor.CancelableTask timeoutTask = this.ctx.timeout().schedule(new Runnable(){

            @Override
            public void run() {
                ses.close();
                ClientListenerNioListener.this.metrics.onHandshakeTimeout();
                U.warn(ClientListenerNioListener.this.log, "Unable to perform handshake within timeout [timeout=" + handshakeTimeout + ", remoteAddr=" + ses.remoteAddress() + "]");
            }
        }, handshakeTimeout, -1L);
        ses.addMeta(CONN_CTX_HANDSHAKE_TIMEOUT_TASK, timeoutTask);
    }

    private void cancelHandshakeTimeout(GridNioSession ses) {
        Closeable timeoutTask = (Closeable)ses.removeMeta(CONN_CTX_HANDSHAKE_TIMEOUT_TASK);
        try {
            if (timeoutTask != null) {
                timeoutTask.close();
            }
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to cancel handshake timeout task [remoteAddr=" + ses.remoteAddress() + ", err=" + e + "]");
        }
    }

    private void onHandshake(GridNioSession ses, ClientMessage msg) {
        BinaryWriterExImpl writer;
        block10: {
            BinaryContext ctx = new BinaryContext(BinaryCachingMetadataHandler.create(), new IgniteConfiguration(), null);
            BinaryMarshaller marsh = new BinaryMarshaller();
            marsh.setContext(new MarshallerContextImpl(null, null));
            ctx.configure(marsh);
            BinaryReaderExImpl reader = new BinaryReaderExImpl(ctx, new BinaryHeapInputStream(msg.payload()), null, true);
            byte cmd = reader.readByte();
            if (cmd != 1) {
                U.warn(this.log, "Unexpected client request (will close session): " + ses.remoteAddress());
                ses.close();
                return;
            }
            short verMajor = reader.readShort();
            short verMinor = reader.readShort();
            short verMaintenance = reader.readShort();
            ClientListenerProtocolVersion ver = ClientListenerProtocolVersion.create(verMajor, verMinor, verMaintenance);
            writer = new BinaryWriterExImpl(null, new BinaryHeapOutputStream(8), null, null);
            byte clientType = reader.readByte();
            ClientListenerConnectionContext connCtx = null;
            try {
                connCtx = this.prepareContext(clientType, ses);
                this.ensureClientPermissions(clientType);
                if (connCtx.isVersionSupported(ver)) {
                    connCtx.initializeFromHandshake(ses, ver, reader);
                    if (this.nodeInRecoveryMode() && !Boolean.parseBoolean(connCtx.attributes().get(MANAGEMENT_CLIENT_ATTR))) {
                        throw new ClientConnectionNodeRecoveryException("Node in recovery mode.");
                    }
                } else {
                    throw new IgniteCheckedException("Unsupported version: " + ver.asString());
                }
                ses.addMeta(CONN_CTX_META_KEY, connCtx);
                this.cancelHandshakeTimeout(ses);
                connCtx.handler().writeHandshake(writer);
                this.metrics.onHandshakeAccept(clientType);
                if (this.log.isDebugEnabled()) {
                    String login = connCtx.securityContext() == null ? null : connCtx.securityContext().subject().login().toString();
                    this.log.debug("Client handshake accepted [rmtAddr=" + ses.remoteAddress() + ", type=" + ClientListenerMetrics.clientTypeLabel(clientType) + ", ver=" + ver.asString() + ", login=" + login + ", connId=" + connCtx.connectionId() + "]");
                }
            }
            catch (IgniteAccessControlException authEx) {
                this.metrics.onFailedAuth();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Client authentication failed [rmtAddr=" + ses.remoteAddress() + ", type=" + ClientListenerMetrics.clientTypeLabel(clientType) + ", ver=" + ver.asString() + ", err=" + authEx.getMessage() + "]");
                }
                writer.writeBoolean(false);
                writer.writeShort((short)0);
                writer.writeShort((short)0);
                writer.writeShort((short)0);
                writer.doWriteString(authEx.getMessage());
                if (ver.compareTo(ClientConnectionContext.VER_1_1_0) >= 0) {
                    writer.writeInt(2000);
                }
            }
            catch (IgniteCheckedException e) {
                U.warn(this.log, "Error during handshake [rmtAddr=" + ses.remoteAddress() + ", type=" + ClientListenerMetrics.clientTypeLabel(clientType) + ", ver=" + ver.asString() + ", msg=" + e.getMessage() + "]");
                this.metrics.onGeneralReject();
                ClientListenerProtocolVersion currVer = connCtx == null ? ClientListenerProtocolVersion.create(0, 0, 0) : connCtx.defaultVersion();
                writer.writeBoolean(false);
                writer.writeShort(currVer.major());
                writer.writeShort(currVer.minor());
                writer.writeShort(currVer.maintenance());
                writer.doWriteString(e.getMessage());
                if (ver.compareTo(ClientConnectionContext.VER_1_1_0) < 0) break block10;
                writer.writeInt(e instanceof ClientConnectionNodeRecoveryException ? 11 : 1);
            }
        }
        ses.send(new ClientMessage(writer.array()));
    }

    private ClientListenerConnectionContext prepareContext(byte clientType, GridNioSession ses) throws IgniteCheckedException {
        long connId = this.nextConnectionId();
        switch (clientType) {
            case 0: {
                return new OdbcConnectionContext(this.ctx, ses, this.busyLock, connId, this.maxCursors);
            }
            case 1: {
                return new JdbcConnectionContext(this.ctx, ses, this.busyLock, connId, this.maxCursors);
            }
            case 2: {
                return new ClientConnectionContext(this.ctx, ses, connId, this.maxCursors, this.thinCfg);
            }
        }
        throw new IgniteCheckedException("Unknown client type: " + clientType);
    }

    private long nextConnectionId() {
        long shiftedId = this.nodeInRecoveryMode() ? -1L : this.ctx.discovery().localNode().order();
        return (shiftedId << 32) + (long)nextConnId.getAndIncrement();
    }

    private boolean nodeInRecoveryMode() {
        return !this.ctx.discovery().localJoinFuture().isDone();
    }

    private void ensureClientPermissions(byte clientType) throws IgniteCheckedException {
        switch (clientType) {
            case 0: {
                if (this.cliConnCfg.isOdbcEnabled()) break;
                throw new IgniteCheckedException("ODBC connection is not allowed, see ClientConnectorConfiguration.odbcEnabled.");
            }
            case 1: {
                if (this.cliConnCfg.isJdbcEnabled()) break;
                throw new IgniteCheckedException("JDBC connection is not allowed, see ClientConnectorConfiguration.jdbcEnabled.");
            }
            case 2: {
                if (this.cliConnCfg.isThinClientEnabled()) break;
                throw new IgniteCheckedException("Thin client connection is not allowed, see ClientConnectorConfiguration.thinClientEnabled.");
            }
            default: {
                throw new IgniteCheckedException("Unknown client type: " + clientType);
            }
        }
    }
}

