/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.job;

import org.apache.ignite.internal.processors.job.GridJobWorker;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;

public class JobWorkerInterruptionTimeoutObject
implements GridTimeoutObject {
    private final GridJobWorker jobWorker;
    private final IgniteUuid id;
    private final long endTime;

    public JobWorkerInterruptionTimeoutObject(GridJobWorker jobWorker, long endTime) {
        this.jobWorker = jobWorker;
        this.endTime = endTime;
        this.id = IgniteUuid.randomUuid();
    }

    @Override
    public IgniteUuid timeoutId() {
        return this.id;
    }

    @Override
    public long endTime() {
        return this.endTime;
    }

    @Override
    public void onTimeout() {
        assert (this.jobWorker.isCancelled()) : this.jobWorker;
        Thread runner = this.jobWorker.runner();
        if (runner != null && !this.jobWorker.isDone()) {
            runner.interrupt();
        }
    }

    public GridJobWorker jobWorker() {
        return this.jobWorker;
    }

    public String toString() {
        return S.toString(JobWorkerInterruptionTimeoutObject.class, this);
    }
}

