/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.dr;

import java.io.Externalizable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrExpirationInfo;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.version.GridCacheRawVersionedEntry;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerCacheUpdaters;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.stream.StreamReceiver;

public class IgniteDrDataStreamerCacheUpdater
implements StreamReceiver<KeyCacheObject, CacheObject>,
DataStreamerCacheUpdaters.InternalUpdater {
    private static final long serialVersionUID = 0L;

    @Override
    public void receive(IgniteCache<KeyCacheObject, CacheObject> cache0, Collection<Map.Entry<KeyCacheObject, CacheObject>> col) {
        try {
            Externalizable cache;
            String cacheName = cache0.getConfiguration(CacheConfiguration.class).getName();
            GridKernalContext ctx = ((IgniteKernal)cache0.unwrap(Ignite.class)).context();
            IgniteLogger log = ctx.log(IgniteDrDataStreamerCacheUpdater.class);
            GridCacheAdapter internalCache = ctx.cache().internalCache(cacheName);
            CacheOperationContext opCtx = ((IgniteCacheProxy)cache0).context().operationContextPerCall();
            Externalizable externalizable = cache = opCtx != null ? new GridCacheProxyImpl(internalCache.context(), internalCache, opCtx) : internalCache;
            assert (!F.isEmpty(col));
            if (log.isDebugEnabled()) {
                log.debug("Running DR put job [nodeId=" + ctx.localNodeId() + ", cacheName=" + cacheName + "]");
            }
            CacheObjectContext cacheObjCtx = cache.context().cacheObjectContext();
            for (Map.Entry<KeyCacheObject, CacheObject> entry0 : col) {
                GridCacheDrExpirationInfo val;
                GridCacheRawVersionedEntry entry = (GridCacheRawVersionedEntry)entry0;
                entry.unmarshal(cacheObjCtx, ctx.config().getMarshaller());
                KeyCacheObject key = entry.getKey();
                assert (entry.ttl() != -1L && entry.ttl() != -2L && entry.ttl() >= 0L);
                assert (entry.expireTime() != -1L && entry.expireTime() >= 0L);
                CacheObject cacheVal = entry.getValue();
                GridCacheDrInfo gridCacheDrInfo = cacheVal != null ? (entry.ttl() != 0L ? new GridCacheDrExpirationInfo(cacheVal, entry.version(), entry.ttl(), entry.expireTime()) : new GridCacheDrInfo(cacheVal, entry.version())) : (val = null);
                if (val == null) {
                    cache.removeAllConflict(Collections.singletonMap(key, entry.version()));
                    continue;
                }
                cache.putAllConflict(Collections.singletonMap(key, val));
            }
            if (log.isDebugEnabled()) {
                log.debug("DR put job finished [nodeId=" + ctx.localNodeId() + ", cacheName=" + cacheName + "]");
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }
}

