/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.management.cache.ContentionInfo;
import org.apache.ignite.internal.management.cache.ContentionJobResult;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class ContentionTaskResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private List<ContentionJobResult> clusterInfos;
    private Map<UUID, Exception> exceptions;

    public ContentionTaskResult(List<ContentionJobResult> clusterInfos, Map<UUID, Exception> exceptions) {
        this.clusterInfos = clusterInfos;
        this.exceptions = exceptions;
    }

    public ContentionTaskResult() {
    }

    public Collection<ContentionJobResult> jobResults() {
        return this.clusterInfos;
    }

    public Collection<ContentionInfo> getInfos() {
        return this.clusterInfos.stream().map(ContentionJobResult::info).collect(Collectors.toList());
    }

    public Map<UUID, Exception> exceptions() {
        return this.exceptions;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.clusterInfos);
        U.writeMap(out, this.exceptions);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.clusterInfos = U.readList(in);
        this.exceptions = U.readMap(in);
    }

    public String toString() {
        return S.toString(ContentionTaskResult.class, this);
    }
}

