/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache.distribution;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionGroup;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionNode;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.jetbrains.annotations.NotNull;

public class CacheDistributionTaskResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private List<CacheDistributionNode> nodeResList;
    private Map<UUID, Exception> exceptions;

    public CacheDistributionTaskResult(List<CacheDistributionNode> nodeResList, Map<UUID, Exception> exceptions) {
        this.nodeResList = nodeResList;
        this.exceptions = exceptions;
    }

    public CacheDistributionTaskResult() {
    }

    public Collection<CacheDistributionNode> jobResults() {
        return this.nodeResList;
    }

    public Map<UUID, Exception> exceptions() {
        return this.exceptions;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.nodeResList);
        U.writeMap(out, this.exceptions);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeResList = U.readList(in);
        this.exceptions = U.readMap(in);
    }

    public String toString() {
        return S.toString(CacheDistributionTaskResult.class, this);
    }

    public void print(Consumer<String> printer) {
        if (this.nodeResList.isEmpty()) {
            return;
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        for (CacheDistributionNode cacheDistributionNode : this.nodeResList) {
            for (CacheDistributionGroup grp : cacheDistributionNode.getGroups()) {
                for (CacheDistributionPartition partition : grp.getPartitions()) {
                    Row row = new Row();
                    row.setGroupId(grp.getGroupId());
                    row.setGroupName(grp.getGroupName());
                    row.setPartition(partition.getPartition());
                    row.setNodeId(cacheDistributionNode.getNodeId());
                    row.setPrimary(partition.isPrimary());
                    row.setState(partition.getState());
                    row.setUpdateCounter(partition.getUpdateCounter());
                    row.setSize(partition.getSize());
                    row.setAddresses(cacheDistributionNode.getAddresses());
                    row.setUserAttributes(cacheDistributionNode.getUserAttributes());
                    rows.add(row);
                }
            }
        }
        rows.sort(null);
        StringBuilder userAttrsName = new StringBuilder();
        if (!rows.isEmpty() && ((Row)rows.get((int)0)).userAttrs != null) {
            for (String userAttr : ((Row)rows.get((int)0)).userAttrs.keySet()) {
                userAttrsName.append(',');
                if (userAttr == null) continue;
                userAttrsName.append(userAttr);
            }
        }
        printer.accept("[groupId,partition,nodeId,primary,state,updateCounter,partitionSize,nodeAddresses" + userAttrsName + "]");
        boolean bl = false;
        for (Row row : rows) {
            int n;
            if (n != row.grpId) {
                printer.accept("[next group: id=" + row.grpId + ", name=" + row.grpName + "]");
                n = row.getGroupId();
            }
            row.print(printer);
        }
    }

    private static class Row
    implements Comparable {
        private int grpId;
        private String grpName;
        private int partId;
        private UUID nodeId;
        private boolean primary;
        private GridDhtPartitionState state;
        private long updateCntr;
        private long size;
        private String addrs;
        private Map<String, String> userAttrs;

        private Row() {
        }

        public int getGroupId() {
            return this.grpId;
        }

        public void setGroupId(int grpId) {
            this.grpId = grpId;
        }

        public String getGroupName() {
            return this.grpName;
        }

        public void setGroupName(String grpName) {
            this.grpName = grpName;
        }

        public int getPartition() {
            return this.partId;
        }

        public void setPartition(int partId) {
            this.partId = partId;
        }

        public UUID getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(UUID nodeId) {
            this.nodeId = nodeId;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public GridDhtPartitionState getState() {
            return this.state;
        }

        public void setState(GridDhtPartitionState state) {
            this.state = state;
        }

        public long getUpdateCounter() {
            return this.updateCntr;
        }

        public void setUpdateCounter(long updateCntr) {
            this.updateCntr = updateCntr;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public String getAddresses() {
            return this.addrs;
        }

        public void setAddresses(String addrs) {
            this.addrs = addrs;
        }

        public Map<String, String> getUserAttributes() {
            return this.userAttrs;
        }

        public void setUserAttributes(Map<String, String> userAttrs) {
            this.userAttrs = userAttrs;
        }

        public int compareTo(@NotNull Object o) {
            assert (o instanceof Row);
            Row other = (Row)o;
            int res = Integer.compare(this.grpId, other.grpId);
            if (res == 0 && (res = Integer.compare(this.partId, other.partId)) == 0) {
                res = this.nodeId.compareTo(other.nodeId);
            }
            return res;
        }

        public void print(Consumer<String> printer) {
            SB out = new SB();
            out.a(this.grpId);
            out.a(',');
            out.a(this.partId);
            out.a(',');
            out.a(U.id8(this.getNodeId()));
            out.a(',');
            out.a(this.primary ? "P" : "B");
            out.a(',');
            out.a((Object)this.state);
            out.a(',');
            out.a(this.updateCntr);
            out.a(',');
            out.a(this.size);
            out.a(',');
            out.a(this.addrs);
            if (this.userAttrs != null) {
                for (String userAttr : this.userAttrs.values()) {
                    out.a(',');
                    if (userAttr == null) continue;
                    out.a(userAttr);
                }
            }
            printer.accept(out.toString());
        }
    }
}

