/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class DetachedClusterNode
implements ClusterNode {
    @GridToStringExclude
    private final UUID uuid = UUID.randomUUID();
    @GridToStringInclude
    private final Object consistentId;
    @GridToStringInclude
    private final Map<String, Object> attributes;

    public DetachedClusterNode(Object consistentId, Map<String, Object> attributes) {
        this.consistentId = consistentId;
        this.attributes = attributes;
    }

    @Override
    public UUID id() {
        return this.uuid;
    }

    @Override
    public Object consistentId() {
        return this.consistentId;
    }

    @Override
    @Nullable
    public <T> T attribute(String name) {
        return (T)this.attributes.get(name);
    }

    @Override
    public ClusterMetrics metrics() {
        throw new UnsupportedOperationException("Operation is not supported on DetachedClusterNode");
    }

    @Override
    public Map<String, Object> attributes() {
        return this.attributes;
    }

    @Override
    public Collection<String> addresses() {
        throw new UnsupportedOperationException("Operation is not supported on DetachedClusterNode");
    }

    @Override
    public Collection<String> hostNames() {
        throw new UnsupportedOperationException("Operation is not supported on DetachedClusterNode");
    }

    @Override
    public long order() {
        throw new UnsupportedOperationException("Operation is not supported on DetachedClusterNode");
    }

    @Override
    public IgniteProductVersion version() {
        throw new UnsupportedOperationException("Operation is not supported on DetachedClusterNode");
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    public String toString() {
        return S.toString(DetachedClusterNode.class, this);
    }
}

