/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.jcl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ignite.IgniteLogger;
import org.jetbrains.annotations.Nullable;

public class JclLogger
implements IgniteLogger {
    private Log impl;
    private final boolean quiet;

    public JclLogger() {
        this(LogFactory.getLog((String)JclLogger.class.getName()));
    }

    public JclLogger(Log impl) {
        assert (impl != null);
        this.impl = impl;
        this.quiet = Boolean.valueOf(System.getProperty("IGNITE_QUIET", "true"));
    }

    public IgniteLogger getLogger(Object ctgr) {
        return new JclLogger(LogFactory.getLog((String)(ctgr instanceof Class ? ((Class)ctgr).getName() : String.valueOf(ctgr))));
    }

    public void trace(String msg) {
        this.impl.trace((Object)msg);
    }

    public void debug(String msg) {
        this.impl.debug((Object)msg);
    }

    public void info(String msg) {
        this.impl.info((Object)msg);
    }

    public void warning(String msg) {
        this.impl.warn((Object)msg);
    }

    public void warning(String msg, @Nullable Throwable e) {
        this.impl.warn((Object)msg, e);
    }

    public void error(String msg) {
        this.impl.error((Object)msg);
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void error(String msg, @Nullable Throwable e) {
        this.impl.error((Object)msg, e);
    }

    public boolean isTraceEnabled() {
        return this.impl.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.impl.isInfoEnabled();
    }

    @Nullable
    public String fileName() {
        return null;
    }

    public String toString() {
        return "JclLogger [impl=" + this.impl + "]";
    }
}

