/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.tx;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.odbc.ClientTxSupport;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.util.lang.GridClosureException;

public class ClientTxEndRequest
extends ClientRequest
implements ClientTxSupport {
    private final int txId;
    private final boolean committed;

    public ClientTxEndRequest(BinaryRawReader reader) {
        super(reader);
        this.txId = reader.readInt();
        this.committed = reader.readBoolean();
    }

    @Override
    public boolean isAsync(ClientConnectionContext ctx) {
        return true;
    }

    @Override
    public IgniteInternalFuture<ClientResponse> processAsync(ClientConnectionContext ctx) {
        return this.endTxAsync(ctx, this.txId, this.committed).chain(f -> {
            if (f.error() != null) {
                throw new GridClosureException(f.error());
            }
            return this.process(ctx);
        });
    }

    @Override
    public RuntimeException transactionNotFoundException() {
        return new IgniteClientException(1021, "Transaction with id " + this.txId + " not found.");
    }

    @Override
    public RuntimeException endTxException(IgniteCheckedException cause) {
        return new IgniteClientException(1, cause.getMessage(), cause);
    }
}

