/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.authentication;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.authentication.User;
import org.apache.ignite.internal.processors.authentication.UserAcceptedMessage;
import org.apache.ignite.internal.processors.authentication.UserAuthenticateRequestMessage;
import org.apache.ignite.internal.processors.authentication.UserAuthenticateResponseMessage;
import org.apache.ignite.internal.processors.authentication.UserManagementException;
import org.apache.ignite.internal.processors.authentication.UserManagementOperation;
import org.apache.ignite.internal.processors.authentication.UserManagementOperationFinishedMessage;
import org.apache.ignite.internal.processors.authentication.UserProposedMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.security.GridSecurityProcessor;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.plugin.security.SecuritySubjectType;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class IgniteAuthenticationProcessor
extends GridProcessorAdapter
implements GridSecurityProcessor,
MetastorageLifecycleListener,
PartitionsExchangeAware {
    private static final String STORE_USER_PREFIX = "user.";
    private static final int[] DISCO_EVT_TYPES = new int[]{11, 12, 10};
    private final ConcurrentHashMap<IgniteUuid, UserOperationFinishFuture> opFinishFuts = new ConcurrentHashMap();
    private final ConcurrentMap<IgniteUuid, AuthenticateFuture> authFuts = new ConcurrentHashMap<IgniteUuid, AuthenticateFuture>();
    private final GridFutureAdapter<Void> readyForAuthFut = new GridFutureAdapter();
    private final Object mux = new Object();
    private final Map<IgniteUuid, UserManagementOperation> activeOps = Collections.synchronizedMap(new LinkedHashMap());
    private ConcurrentMap<UUID, User> users;
    @GridToStringExclude
    private GridCacheSharedContext<?, ?> sharedCtx;
    private ReadWriteMetastorage metastorage;
    private IgniteThreadPoolExecutor exec;
    private ClusterNode crdNode;
    private volatile boolean disconnected;
    private UserManagementOperationFinishedMessage curOpFinishMsg;
    private InitialUsersData initUsrs;
    private GridMessageListener ioLsnr;
    private DiscoveryEventListener discoLsnr;
    private final GridFutureAdapter<Void> activateFut = new GridFutureAdapter();

    public IgniteAuthenticationProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    public void startProcessor() throws IgniteCheckedException {
        if (!this.ctx.clientNode() && !CU.isPersistenceEnabled(this.ctx.config())) {
            throw new IgniteCheckedException("Authentication can be enabled only for cluster with enabled persistence. Check the DataRegionConfiguration");
        }
        this.ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
        this.ctx.addNodeAttribute("org.apache.ignite.authentication.enabled", true);
        this.sharedCtx = this.ctx.cache().context();
        this.sharedCtx.exchange().registerExchangeAwareComponent(this);
        GridDiscoveryManager discoMgr = this.ctx.discovery();
        GridIoManager ioMgr = this.ctx.io();
        discoMgr.setCustomEventListener(UserProposedMessage.class, new UserProposedListener());
        discoMgr.setCustomEventListener(UserAcceptedMessage.class, new UserAcceptedListener());
        discoMgr.localJoinFuture().listen(this::onLocalJoin);
        this.discoLsnr = (evt, discoCache) -> {
            if (this.ctx.isStopping()) {
                return;
            }
            switch (evt.type()) {
                case 11: 
                case 12: {
                    this.onNodeLeft(evt.eventNode().id());
                    break;
                }
                case 10: {
                    this.onNodeJoin(evt.eventNode());
                }
            }
        };
        this.ctx.event().addDiscoveryEventListener(this.discoLsnr, DISCO_EVT_TYPES);
        this.ioLsnr = (nodeId, msg, plc) -> {
            if (this.ctx.isStopping()) {
                return;
            }
            if (msg instanceof UserManagementOperationFinishedMessage) {
                this.onFinishMessage(nodeId, (UserManagementOperationFinishedMessage)msg);
            } else if (msg instanceof UserAuthenticateRequestMessage) {
                this.onAuthenticateRequestMessage(nodeId, (UserAuthenticateRequestMessage)msg);
            } else if (msg instanceof UserAuthenticateResponseMessage) {
                this.onAuthenticateResponseMessage((UserAuthenticateResponseMessage)msg);
            }
        };
        ioMgr.addMessageListener(GridTopic.TOPIC_AUTH, this.ioLsnr);
        this.exec = new IgniteThreadPoolExecutor("auth", this.ctx.config().getIgniteInstanceName(), 1, 1, 0L, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.ioLsnr != null) {
            this.ctx.io().removeMessageListener(GridTopic.TOPIC_AUTH, this.ioLsnr);
        }
        if (this.discoLsnr != null) {
            this.ctx.event().removeDiscoveryEventListener(this.discoLsnr, DISCO_EVT_TYPES);
        }
        this.cancelFutures("Node stopped");
        if (this.exec != null) {
            if (!cancel) {
                this.exec.shutdown();
            } else {
                this.exec.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKernalStop(boolean cancel) {
        Object object = this.mux;
        synchronized (object) {
            this.cancelFutures("Kernal stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnected(IgniteFuture reconnectFut) {
        Object object = this.mux;
        synchronized (object) {
            assert (!this.disconnected);
            this.disconnected = true;
            this.cancelFutures("Client node was disconnected from topology (operation result is unknown).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> onReconnected(boolean active) {
        Object object = this.mux;
        synchronized (object) {
            assert (this.disconnected);
            this.disconnected = false;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityContext authenticate(AuthenticationContext authCtx) throws IgniteCheckedException {
        UUID subjId;
        SecurityCredentials creds = authCtx.credentials();
        String login = (String)creds.getLogin();
        if (F.isEmpty(login)) {
            throw new IgniteAccessControlException("The user name or password is incorrect [userName=" + login + "]");
        }
        String passwd = (String)creds.getPassword();
        if (this.ctx.clientNode()) {
            AuthenticateFuture fut;
            if (this.ctx.discovery().aliveServerNodes().isEmpty()) {
                throw new IgniteAccessControlException("No alive server node was found to which the authentication operation could be delegated. It is possible that the client node has been started with the \"forceServerMode\" flag enabled and no server node had been started yet.");
            }
            do {
                Object object = this.mux;
                synchronized (object) {
                    ClusterNode rndNode = U.randomServerNode(this.ctx);
                    fut = new AuthenticateFuture(rndNode.id());
                    UserAuthenticateRequestMessage msg = new UserAuthenticateRequestMessage(login, passwd);
                    this.authFuts.put(msg.id(), fut);
                    this.ctx.io().sendToGridTopic(rndNode, GridTopic.TOPIC_AUTH, (Message)msg, (byte)2);
                }
                fut.get();
            } while (fut.retry());
            subjId = this.toSubjectId(login);
        } else {
            subjId = this.authenticateOnServer(login, passwd);
        }
        return new SecurityContextImpl(subjId, login, authCtx.subjectType(), authCtx.address());
    }

    public static void validate(String login, char[] passwd) throws UserManagementException {
        if (F.isEmpty(login)) {
            throw new UserManagementException("User name is empty");
        }
        if (F.isEmpty(passwd)) {
            throw new UserManagementException("Password is empty");
        }
        if ((STORE_USER_PREFIX + login).getBytes().length > 64) {
            throw new UserManagementException("User name is too long. The user name length must be less then 60 bytes in UTF8");
        }
    }

    @Override
    public void createUser(String login, char[] passwd) throws IgniteCheckedException {
        IgniteAuthenticationProcessor.validate(login, passwd);
        UserManagementOperation op = new UserManagementOperation(User.create(login, new String(passwd)), UserManagementOperation.OperationType.ADD);
        this.execUserOperation(op).get();
    }

    @Override
    public void dropUser(String login) throws IgniteCheckedException {
        UserManagementOperation op = new UserManagementOperation(User.create(login), UserManagementOperation.OperationType.REMOVE);
        this.execUserOperation(op).get();
    }

    @Override
    public void alterUser(String login, char[] passwd) throws IgniteCheckedException {
        UserManagementOperation op = new UserManagementOperation(User.create(login, new String(passwd)), UserManagementOperation.OperationType.UPDATE);
        this.execUserOperation(op).get();
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) throws IgniteCheckedException {
        if (!this.ctx.clientNode()) {
            this.users = new ConcurrentHashMap<UUID, User>();
            metastorage.iterate(STORE_USER_PREFIX, (key, val) -> {
                User u = (User)val;
                User cur = this.users.putIfAbsent(this.toSubjectId(u.name()), u);
                if (cur != null) {
                    throw new IllegalStateException("Security users with conflicting IDs were found while reading from metastorage [logins=" + u.name() + ", " + cur.name() + "]. It is possible that the Ignite metastorage is corrupted or the specified users were created bypassing the Ignite Security API.");
                }
            }, true);
        } else {
            this.users = null;
        }
    }

    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metastorage) {
        this.metastorage = !this.ctx.clientNode() ? metastorage : null;
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.AUTH_PROC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        if (!this.isLocalNodeCoordinator() || dataBag.isJoiningNodeClient()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            if (!dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.AUTH_PROC.ordinal())) {
                InitialUsersData d = new InitialUsersData(this.users.values(), this.activeOps.values());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Collected initial users data: " + d);
                }
                dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.AUTH_PROC.ordinal(), d);
            }
        }
    }

    private boolean isLocalNodeCoordinator() {
        DiscoverySpi spi = this.ctx.discovery().getInjectedDiscoverySpi();
        if (spi instanceof TcpDiscoverySpi) {
            return ((TcpDiscoverySpi)spi).isLocalNodeCoordinator();
        }
        return F.eq(this.ctx.localNodeId(), this.coordinator().id());
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        this.initUsrs = (InitialUsersData)data.commonData();
    }

    @Override
    public boolean enabled() {
        return true;
    }

    private void checkActivate() {
        if (!this.ctx.state().publicApiActiveState(true)) {
            throw new IgniteException("Can not perform the operation because the cluster is inactive. Note, that the cluster is considered inactive by default if Ignite Persistent Store is used to let all the nodes join the cluster. To activate the cluster call Ignite.cluster().state(ClusterState.ACTIVE).");
        }
    }

    private void addDefaultUser() {
        assert (this.users != null && this.users.isEmpty());
        User dfltUser = User.defaultUser();
        this.users.put(this.toSubjectId(dfltUser.name()), dfltUser);
        this.exec.execute(new RefreshUsersStorageWorker(new ArrayList<User>(Collections.singleton(dfltUser))));
    }

    private UUID authenticateOnServer(String login, String passwd) throws IgniteCheckedException {
        assert (!this.ctx.clientNode()) : "Must be used on server node";
        this.readyForAuthFut.get();
        UUID subjId = this.toSubjectId(login);
        User usr = this.findUser(subjId, login);
        if (usr == null || !usr.authorize(passwd)) {
            throw new IgniteAccessControlException("The user name or password is incorrect [userName=" + login + "]");
        }
        return subjId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserOperationFinishFuture execUserOperation(UserManagementOperation op) throws IgniteCheckedException {
        this.checkActivate();
        Object object = this.mux;
        synchronized (object) {
            if (this.disconnected) {
                throw new UserManagementException("Failed to initiate user management operation because client node is disconnected.");
            }
            this.checkUserOperation(op);
            UserOperationFinishFuture fut = new UserOperationFinishFuture(op.id());
            this.opFinishFuts.put(op.id(), fut);
            UserProposedMessage msg = new UserProposedMessage(op);
            this.ctx.discovery().sendCustomEvent(msg);
            return fut;
        }
    }

    private void processOperationLocal(UserManagementOperation op) throws IgniteCheckedException {
        assert (op != null && op.user() != null) : "Invalid operation: " + op;
        switch (op.type()) {
            case ADD: {
                this.addUserLocal(op);
                break;
            }
            case REMOVE: {
                this.removeUserLocal(op);
                break;
            }
            case UPDATE: {
                this.updateUserLocal(op);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserLocal(UserManagementOperation op) throws IgniteCheckedException {
        User usr = op.user();
        String userName = usr.name();
        UUID subjId = this.toSubjectId(userName);
        if (this.users.get(subjId) != null) {
            throw new UserManagementException("User already exists [login=" + userName + "]");
        }
        this.metastorage.write(STORE_USER_PREFIX + userName, usr);
        Object object = this.mux;
        synchronized (object) {
            this.activeOps.remove(op.id());
            this.users.put(subjId, usr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUserLocal(UserManagementOperation op) throws IgniteCheckedException {
        User usr = op.user();
        String login = usr.name();
        UUID subjId = this.toSubjectId(login);
        if (this.findUser(subjId, login) == null) {
            throw new UserManagementException("User doesn't exist [userName=" + login + "]");
        }
        this.metastorage.remove(STORE_USER_PREFIX + login);
        Object object = this.mux;
        synchronized (object) {
            this.activeOps.remove(op.id());
            this.users.remove(subjId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserLocal(UserManagementOperation op) throws IgniteCheckedException {
        User usr = op.user();
        String login = usr.name();
        UUID subjId = this.toSubjectId(login);
        if (this.findUser(subjId, login) == null) {
            throw new UserManagementException("User doesn't exist [userName=" + login + "]");
        }
        this.metastorage.write(STORE_USER_PREFIX + login, usr);
        Object object = this.mux;
        synchronized (object) {
            this.activeOps.remove(op.id());
            this.users.put(subjId, usr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterNode coordinator() {
        Object object = this.mux;
        synchronized (object) {
            if (this.crdNode != null) {
                return this.crdNode;
            }
            ClusterNode res = null;
            for (ClusterNode node : this.ctx.discovery().aliveServerNodes()) {
                if (res != null && res.order() <= node.order()) continue;
                res = node;
            }
            if (res == null && !this.ctx.discovery().allNodes().isEmpty() && this.ctx.discovery().aliveServerNodes().isEmpty()) {
                U.warn(this.log, "Cannot find the server coordinator node. Possible a client is started with forceServerMode=true.");
            } else assert (res != null);
            this.crdNode = res;
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelFutures(String msg) {
        Iterator iterator = this.mux;
        synchronized (iterator) {
            for (UserOperationFinishFuture fut : this.opFinishFuts.values()) {
                fut.onDone(null, (Throwable)new IgniteFutureCancelledException(msg));
            }
        }
        for (GridFutureAdapter fut : this.authFuts.values()) {
            fut.onDone(null, new IgniteFutureCancelledException(msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNodeJoin(ClusterNode node) {
        if (IgniteAuthenticationProcessor.isNodeHoldsUsers(this.ctx.discovery().localNode()) && IgniteAuthenticationProcessor.isNodeHoldsUsers(node)) {
            Object object = this.mux;
            synchronized (object) {
                for (UserOperationFinishFuture f : this.opFinishFuts.values()) {
                    f.onNodeJoin(node.id());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNodeLeft(UUID nodeId) {
        Object object = this.mux;
        synchronized (object) {
            if (!this.ctx.clientNode()) {
                for (UserOperationFinishFuture userOperationFinishFuture : this.opFinishFuts.values()) {
                    userOperationFinishFuture.onNodeLeft(nodeId);
                }
            }
            Iterator it = this.authFuts.entrySet().iterator();
            while (it.hasNext()) {
                AuthenticateFuture authenticateFuture = (AuthenticateFuture)it.next().getValue();
                if (!F.eq(nodeId, authenticateFuture.nodeId())) continue;
                authenticateFuture.retry(true);
                authenticateFuture.onDone();
                it.remove();
            }
            if (F.eq(this.coordinator().id(), nodeId)) {
                this.crdNode = null;
                if (this.curOpFinishMsg != null) {
                    this.sendFinish(this.curOpFinishMsg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinishMessage(UUID nodeId, UserManagementOperationFinishedMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(msg.toString());
        }
        Object object = this.mux;
        synchronized (object) {
            UserOperationFinishFuture fut = this.opFinishFuts.get(msg.operationId());
            if (fut == null) {
                fut = new UserOperationFinishFuture(msg.operationId());
                this.opFinishFuts.put(msg.operationId(), fut);
            }
            if (msg.success()) {
                fut.onSuccessOnNode(nodeId);
            } else {
                fut.onOperationFailOnNode(nodeId, msg.errorMessage());
            }
        }
    }

    private void onFinishOperation(IgniteUuid opId, IgniteCheckedException err) {
        block2: {
            try {
                UserAcceptedMessage msg = new UserAcceptedMessage(opId, err);
                this.ctx.discovery().sendCustomEvent(msg);
            }
            catch (IgniteCheckedException e) {
                if (e.hasCause(IgniteFutureCancelledException.class)) break block2;
                U.error(this.log, "Unexpected exception on send UserAcceptedMessage.", e);
            }
        }
    }

    private void onAuthenticateRequestMessage(UUID nodeId, UserAuthenticateRequestMessage msg) {
        UserAuthenticateResponseMessage respMsg;
        try {
            this.authenticateOnServer(msg.name(), msg.password());
            respMsg = new UserAuthenticateResponseMessage(msg.id(), null);
        }
        catch (IgniteCheckedException e) {
            respMsg = new UserAuthenticateResponseMessage(msg.id(), e.toString());
            e.printStackTrace();
        }
        try {
            this.ctx.io().sendToGridTopic(nodeId, GridTopic.TOPIC_AUTH, (Message)respMsg, (byte)2);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Unexpected exception on send UserAuthenticateResponseMessage.", e);
        }
    }

    private void onAuthenticateResponseMessage(UserAuthenticateResponseMessage msg) {
        GridFutureAdapter fut = (GridFutureAdapter)this.authFuts.get(msg.id());
        fut.onDone(null, !msg.success() ? new IgniteAccessControlException(msg.errorMessage()) : null);
        this.authFuts.remove(msg.id());
    }

    private void onLocalJoin() {
        if (this.ctx.clientDisconnected() || this.coordinator() == null) {
            return;
        }
        if (F.eq(this.coordinator().id(), this.ctx.localNodeId())) {
            assert (this.initUsrs == null);
            if (this.users.isEmpty()) {
                this.addDefaultUser();
            }
        } else {
            if (this.ctx.clientNode()) {
                return;
            }
            assert (this.initUsrs != null);
            if (!F.isEmpty(this.initUsrs.usrs)) {
                if (this.users == null) {
                    this.users = new ConcurrentHashMap<UUID, User>();
                } else {
                    this.users.clear();
                }
                for (User u : this.initUsrs.usrs) {
                    this.users.put(this.toSubjectId(u.name()), u);
                }
                this.exec.execute(new RefreshUsersStorageWorker(this.initUsrs.usrs));
            }
            for (UserManagementOperation op : this.initUsrs.activeOps) {
                this.submitOperation(op);
            }
        }
        this.readyForAuthFut.onDone();
    }

    @Override
    public void onDoneBeforeTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
        this.activateFut.onDone();
    }

    private void waitActivate() {
        try {
            this.activateFut.get();
        }
        catch (IgniteCheckedException igniteCheckedException) {
            // empty catch block
        }
    }

    private void sendFinish(UserManagementOperationFinishedMessage msg) {
        try {
            this.ctx.io().sendToGridTopic(this.coordinator(), GridTopic.TOPIC_AUTH, (Message)msg, (byte)2);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to send UserManagementOperationFinishedMessage [op=" + msg.operationId() + ", node=" + this.coordinator() + ", err=" + msg.errorMessage() + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitOperation(UserManagementOperation op) {
        Object object = this.mux;
        synchronized (object) {
            UserOperationFinishFuture fut = this.opFinishFuts.get(op.id());
            if (fut == null) {
                fut = new UserOperationFinishFuture(op.id());
                this.opFinishFuts.put(op.id(), fut);
            }
            if (!fut.workerSubmitted()) {
                fut.workerSubmitted(true);
                this.activeOps.put(op.id(), op);
                this.exec.execute(new UserOperationWorker(op, fut));
            }
        }
    }

    private static boolean isNodeHoldsUsers(ClusterNode n) {
        return !n.isClient();
    }

    @Override
    public SecurityContext authenticateNode(ClusterNode node, SecurityCredentials cred) throws IgniteCheckedException {
        return new SecurityContextImpl(node.id(), (String)node.attribute("org.apache.ignite.ignite.name"), SecuritySubjectType.REMOTE_NODE, new InetSocketAddress(F.first(node.addresses()), 0));
    }

    @Override
    public SecuritySubject authenticatedSubject(UUID subjId) throws IgniteCheckedException {
        return null;
    }

    @Override
    public Collection<SecuritySubject> authenticatedSubjects() throws IgniteCheckedException {
        return null;
    }

    @Override
    public boolean isGlobalNodeAuthentication() {
        return false;
    }

    @Override
    public void authorize(String name, SecurityPermission perm, SecurityContext securityCtx) throws SecurityException {
    }

    @Override
    public void onSessionExpired(UUID subjId) {
    }

    @Override
    public SecurityContext securityContext(UUID subjId) {
        if (this.ctx.clientNode()) {
            return new SecurityContextImpl(subjId, null, SecuritySubjectType.REMOTE_CLIENT, null);
        }
        User user = (User)this.users.get(subjId);
        return user == null ? null : new SecurityContextImpl(subjId, user.name(), SecuritySubjectType.REMOTE_CLIENT, null);
    }

    private User findUser(UUID subjId, String login) {
        User user = (User)this.users.get(subjId);
        if (user == null || !user.name().equals(login)) {
            return null;
        }
        return user;
    }

    private UUID toSubjectId(String login) {
        return UUID.nameUUIDFromBytes(login.getBytes());
    }

    public void checkUserOperation(UserManagementOperation op) throws IgniteAccessControlException {
        assert (op != null);
        SecuritySubject subj = this.ctx.security().securityContext().subject();
        if (subj.type() == SecuritySubjectType.REMOTE_NODE) {
            throw new IgniteAccessControlException("User management operations initiated on behalf of the Ignite node are not expected.");
        }
        if (!("ignite".equals(subj.login()) || UserManagementOperation.OperationType.UPDATE == op.type() && subj.login().equals(op.user().name()))) {
            throw new IgniteAccessControlException("User management operations are not allowed for user. [curUser=" + subj.login() + "]");
        }
        if (op.type() == UserManagementOperation.OperationType.REMOVE && "ignite".equals(op.user().name())) {
            throw new IgniteAccessControlException("Default user cannot be removed.");
        }
    }

    private static class SecurityContextImpl
    implements SecurityContext,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final SecuritySubject subj;

        public SecurityContextImpl(UUID id, String login, SecuritySubjectType type, InetSocketAddress addr) {
            this.subj = new SecuritySubjectImpl(id, login, type, addr);
        }

        @Override
        public SecuritySubject subject() {
            return this.subj;
        }
    }

    private static class SecuritySubjectImpl
    implements SecuritySubject {
        private static final long serialVersionUID = 0L;
        private final UUID id;
        private final String login;
        private final SecuritySubjectType type;
        private final InetSocketAddress addr;

        public SecuritySubjectImpl(UUID id, String login, SecuritySubjectType type, InetSocketAddress addr) {
            this.id = id;
            this.login = login;
            this.type = type;
            this.addr = addr;
        }

        @Override
        public UUID id() {
            return this.id;
        }

        @Override
        public String login() {
            return this.login;
        }

        @Override
        public SecuritySubjectType type() {
            return this.type;
        }

        @Override
        public InetSocketAddress address() {
            return this.addr;
        }

        public String toString() {
            return S.toString(SecuritySubjectImpl.class, this);
        }
    }

    private class RefreshUsersStorageWorker
    extends GridWorker {
        private final ArrayList<User> newUsrs;

        private RefreshUsersStorageWorker(ArrayList<User> usrs) {
            super(IgniteAuthenticationProcessor.this.ctx.igniteInstanceName(), "refresh-store", IgniteAuthenticationProcessor.this.log);
            assert (!F.isEmpty(usrs));
            this.newUsrs = usrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            if (IgniteAuthenticationProcessor.this.ctx.clientNode()) {
                return;
            }
            IgniteAuthenticationProcessor.this.waitActivate();
            if (IgniteAuthenticationProcessor.this.sharedCtx != null) {
                IgniteAuthenticationProcessor.this.sharedCtx.database().checkpointReadLock();
            }
            try {
                HashSet existUsrsKeys = new HashSet();
                IgniteAuthenticationProcessor.this.metastorage.iterate(IgniteAuthenticationProcessor.STORE_USER_PREFIX, (key, val) -> existUsrsKeys.add(key), false);
                for (String key2 : existUsrsKeys) {
                    IgniteAuthenticationProcessor.this.metastorage.remove(key2);
                }
                for (User u : this.newUsrs) {
                    IgniteAuthenticationProcessor.this.metastorage.write(IgniteAuthenticationProcessor.STORE_USER_PREFIX + u.name(), u);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Cannot cleanup old users information at metastorage", e);
            }
            finally {
                if (IgniteAuthenticationProcessor.this.sharedCtx != null) {
                    IgniteAuthenticationProcessor.this.sharedCtx.database().checkpointReadUnlock();
                }
            }
        }
    }

    private class UserOperationWorker
    extends GridWorker {
        private final UserManagementOperation op;
        private final UserOperationFinishFuture fut;

        private UserOperationWorker(UserManagementOperation op, UserOperationFinishFuture fut) {
            super(IgniteAuthenticationProcessor.this.ctx.igniteInstanceName(), "auth-op-" + op.type(), IgniteAuthenticationProcessor.this.log);
            this.op = op;
            this.fut = fut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            UserManagementOperationFinishedMessage msg0;
            if (IgniteAuthenticationProcessor.this.ctx.isStopping()) {
                return;
            }
            IgniteAuthenticationProcessor.this.waitActivate();
            if (IgniteAuthenticationProcessor.this.sharedCtx != null) {
                IgniteAuthenticationProcessor.this.sharedCtx.database().checkpointReadLock();
            }
            try {
                IgniteAuthenticationProcessor.this.processOperationLocal(this.op);
                msg0 = new UserManagementOperationFinishedMessage(this.op.id(), null);
            }
            catch (UserManagementException e) {
                msg0 = new UserManagementOperationFinishedMessage(this.op.id(), e.toString());
                IgniteAuthenticationProcessor.this.activeOps.remove(this.op.id());
            }
            catch (Throwable e) {
                this.log.warning("Unexpected exception on perform user management operation", e);
                msg0 = new UserManagementOperationFinishedMessage(this.op.id(), e.toString());
                IgniteAuthenticationProcessor.this.activeOps.remove(this.op.id());
            }
            finally {
                if (IgniteAuthenticationProcessor.this.sharedCtx != null) {
                    IgniteAuthenticationProcessor.this.sharedCtx.database().checkpointReadUnlock();
                }
            }
            IgniteAuthenticationProcessor.this.curOpFinishMsg = msg0;
            IgniteAuthenticationProcessor.this.sendFinish(IgniteAuthenticationProcessor.this.curOpFinishMsg);
            try {
                this.fut.get();
            }
            catch (IgniteCheckedException e) {
                if (!e.hasCause(IgniteFutureCancelledException.class)) {
                    U.error(this.log, "Unexpected exception on wait for end of user operation.", e);
                }
            }
            finally {
                IgniteAuthenticationProcessor.this.curOpFinishMsg = null;
            }
        }
    }

    private static class AuthenticateFuture
    extends GridFutureAdapter<Void> {
        private final UUID nodeId;
        private boolean retry;

        AuthenticateFuture(UUID nodeId) {
            this.nodeId = nodeId;
        }

        UUID nodeId() {
            return this.nodeId;
        }

        boolean retry() {
            return this.retry;
        }

        void retry(boolean retry) {
            this.retry = retry;
        }
    }

    private class UserOperationFinishFuture
    extends GridFutureAdapter<Void> {
        private final Set<UUID> requiredFinish;
        private final Set<UUID> receivedFinish;
        private final IgniteUuid opId;
        private boolean workerSubmitted;
        private IgniteCheckedException err;

        UserOperationFinishFuture(IgniteUuid opId) {
            this.opId = opId;
            if (!IgniteAuthenticationProcessor.this.ctx.clientNode()) {
                this.requiredFinish = new HashSet<UUID>();
                this.receivedFinish = new HashSet<UUID>();
                for (ClusterNode node : IgniteAuthenticationProcessor.this.ctx.discovery().nodes(IgniteAuthenticationProcessor.this.ctx.discovery().topologyVersionEx())) {
                    if (!IgniteAuthenticationProcessor.isNodeHoldsUsers(node)) continue;
                    this.requiredFinish.add(node.id());
                }
            } else {
                this.requiredFinish = null;
                this.receivedFinish = null;
            }
        }

        boolean workerSubmitted() {
            return this.workerSubmitted;
        }

        void workerSubmitted(boolean val) {
            this.workerSubmitted = val;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onDone(@Nullable Void res, @Nullable Throwable err) {
            boolean done = super.onDone(res, err);
            Object object = IgniteAuthenticationProcessor.this.mux;
            synchronized (object) {
                if (done) {
                    IgniteAuthenticationProcessor.this.opFinishFuts.remove(this.opId, this);
                }
            }
            return done;
        }

        synchronized void onNodeLeft(UUID nodeId) {
            assert (this.requiredFinish != null) : "Process node left on client";
            this.requiredFinish.remove(nodeId);
            this.checkOperationFinished();
        }

        synchronized void onNodeJoin(UUID id) {
            assert (this.requiredFinish != null) : "Process node join on client";
            this.requiredFinish.add(id);
        }

        synchronized void onSuccessOnNode(UUID nodeId) {
            assert (this.receivedFinish != null) : "Process operation state on client";
            this.receivedFinish.add(nodeId);
            this.checkOperationFinished();
        }

        synchronized void onOperationFailOnNode(UUID nodeId, String errMsg) {
            assert (this.receivedFinish != null) : "Process operation state on client";
            if (IgniteAuthenticationProcessor.this.log.isDebugEnabled()) {
                IgniteAuthenticationProcessor.this.log.debug("User operation is failed [nodeId=" + nodeId + ", err=" + errMsg + "]");
            }
            this.receivedFinish.add(nodeId);
            UserManagementException e = new UserManagementException("Operation failed [nodeId=" + nodeId + ", opId=" + this.opId + ", err=" + errMsg + "]");
            if (this.err == null) {
                this.err = e;
            } else {
                this.err.addSuppressed(e);
            }
            this.checkOperationFinished();
        }

        private void checkOperationFinished() {
            if (this.receivedFinish.containsAll(this.requiredFinish)) {
                IgniteAuthenticationProcessor.this.onFinishOperation(this.opId, this.err);
            }
        }
    }

    private final class UserAcceptedListener
    implements CustomEventListener<UserAcceptedMessage> {
        private UserAcceptedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, UserAcceptedMessage msg) {
            if (IgniteAuthenticationProcessor.this.ctx.isStopping()) {
                return;
            }
            if (IgniteAuthenticationProcessor.this.log.isDebugEnabled()) {
                IgniteAuthenticationProcessor.this.log.debug(msg.toString());
            }
            Object object = IgniteAuthenticationProcessor.this.mux;
            synchronized (object) {
                UserOperationFinishFuture f = IgniteAuthenticationProcessor.this.opFinishFuts.get(msg.operationId());
                if (f != null) {
                    if (msg.error() != null) {
                        f.onDone(null, (Throwable)msg.error());
                    } else {
                        f.onDone();
                    }
                }
            }
        }
    }

    private final class UserProposedListener
    implements CustomEventListener<UserProposedMessage> {
        private UserProposedListener() {
        }

        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, UserProposedMessage msg) {
            if (IgniteAuthenticationProcessor.this.ctx.isStopping() || IgniteAuthenticationProcessor.this.ctx.clientNode()) {
                return;
            }
            if (IgniteAuthenticationProcessor.this.log.isDebugEnabled()) {
                IgniteAuthenticationProcessor.this.log.debug(msg.toString());
            }
            IgniteAuthenticationProcessor.this.submitOperation(msg.operation());
        }
    }

    private static final class InitialUsersData
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @GridToStringInclude
        private final ArrayList<User> usrs;
        @GridToStringInclude
        private final ArrayList<UserManagementOperation> activeOps;

        InitialUsersData(Collection<User> usrs, Collection<UserManagementOperation> ops) {
            this.usrs = new ArrayList<User>(usrs);
            this.activeOps = new ArrayList<UserManagementOperation>(ops);
        }

        public String toString() {
            return S.toString(InitialUsersData.class, this);
        }
    }
}

