/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.probes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkExecutionAwareProbe;
import org.yardstickframework.BenchmarkProbePoint;
import org.yardstickframework.BenchmarkTotalsOnlyProbe;
import org.yardstickframework.BenchmarkUtils;

public class TotalTimeProbe
implements BenchmarkExecutionAwareProbe,
BenchmarkTotalsOnlyProbe {
    private volatile ThreadAgent[] agents;
    private BenchmarkConfiguration cfg;

    public void beforeExecute(int threadIdx) {
        this.agents[threadIdx].before();
    }

    public void afterExecute(int threadIdx) {
        this.agents[threadIdx].after();
    }

    public void start(BenchmarkDriver drv, BenchmarkConfiguration cfg) throws Exception {
        this.cfg = cfg;
        this.agents = new ThreadAgent[cfg.threads()];
        for (int thId = 0; thId < this.agents.length; ++thId) {
            this.agents[thId] = new ThreadAgent();
        }
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"TotalTime probe started");
    }

    public void stop() throws Exception {
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)"TotalTime probe stopped");
    }

    public Collection<String> metaInfo() {
        return Arrays.asList("Thread ID", "Duration, ms");
    }

    public Collection<BenchmarkProbePoint> points() {
        ArrayList<BenchmarkProbePoint> points = new ArrayList<BenchmarkProbePoint>();
        for (int thId = 0; thId < this.agents.length; ++thId) {
            double durationMs = (double)this.agents[thId].getDurationNs() / 1000000.0;
            BenchmarkProbePoint pnt = new BenchmarkProbePoint((long)thId, new double[]{durationMs});
            points.add(pnt);
        }
        return points;
    }

    public void buildPoint(long time) {
    }

    static class ThreadAgent {
        private volatile long startTs;
        private volatile long finishTs;

        ThreadAgent() {
        }

        public void before() {
            this.startTs = System.nanoTime();
        }

        public void after() {
            this.finishTs = System.nanoTime();
        }

        public long getDurationNs() {
            if (this.finishTs == 0L && this.startTs != 0L) {
                throw new IllegalStateException("Cannot provide results of TotalTime probe; after() method haven't been called");
            }
            return this.finishTs - this.startTs;
        }
    }
}

