/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.sql;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteInlineIndexBenchmark
extends IgniteAbstractBenchmark {
    private String cacheName;
    private Class<?> keyCls;
    private int range;
    private boolean isJavaObj;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        this.range = this.args.range();
        this.isJavaObj = this.args.getBooleanParameter("javaObject", false);
        if (this.isJavaObj) {
            this.cacheName = "CACHE_POJO";
            this.keyCls = TestKey.class;
        } else {
            this.cacheName = "CACHE_LONG";
            this.keyCls = Integer.class;
        }
        this.printParameters();
        IgniteSemaphore sem = this.ignite().semaphore("setup", 1, true, true);
        try {
            if (sem.tryAcquire()) {
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Create tables...");
                this.init();
            } else {
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Waits for setup...");
                sem.acquire();
            }
        }
        finally {
            sem.release();
        }
    }

    private void init() {
        this.ignite().createCache(new CacheConfiguration(this.cacheName).setIndexedTypes(new Class[]{this.keyCls, Integer.class}));
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Populate cache: " + this.cacheName + ", range: " + this.range));
        try (IgniteDataStreamer stream = this.ignite().dataStreamer(this.cacheName);){
            stream.allowOverwrite(false);
            for (long k = 0L; k < (long)this.range; ++k) {
                stream.addData(this.nextKey(), (Object)ThreadLocalRandom.current().nextInt());
            }
        }
        BenchmarkUtils.println((BenchmarkConfiguration)this.cfg, (String)("Cache populated: " + this.cacheName));
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        this.ignite().cache(this.cacheName).put(this.nextKey(), (Object)ThreadLocalRandom.current().nextInt());
        return true;
    }

    private Object nextKey() {
        return this.isJavaObj ? new TestKey(ThreadLocalRandom.current().nextInt(this.range)) : Integer.valueOf(ThreadLocalRandom.current().nextInt(this.range));
    }

    private void printParameters() {
        BenchmarkUtils.println((String)"Benchmark parameter:");
        BenchmarkUtils.println((String)("    range: " + this.range));
        BenchmarkUtils.println((String)("    is JavaObject: " + this.isJavaObj));
    }

    static class TestKey {
        private final int id;

        public TestKey(int id) {
            this.id = id;
        }
    }
}

