/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AggregateCall {
    private final SqlAggFunction aggFunction;
    private final boolean distinct;
    private final boolean approximate;
    private final boolean ignoreNulls;
    public final RelDataType type;
    public final @Nullable String name;
    public final List<RexNode> rexList;
    private final ImmutableList<Integer> argList;
    public final int filterArg;
    public final @Nullable ImmutableBitSet distinctKeys;
    public final RelCollation collation;

    @Deprecated
    public AggregateCall(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, RelDataType type, String name) {
        this(aggFunction, distinct, false, false, (List<RexNode>)ImmutableList.of(), argList, -1, null, RelCollations.EMPTY, type, name);
    }

    private AggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, List<RexNode> rexList, List<Integer> argList, int filterArg, @Nullable ImmutableBitSet distinctKeys, RelCollation collation, RelDataType type, @Nullable String name) {
        this.type = Objects.requireNonNull(type, "type");
        this.name = name;
        this.aggFunction = Objects.requireNonNull(aggFunction, "aggFunction");
        this.argList = ImmutableList.copyOf(argList);
        this.rexList = ImmutableList.copyOf(rexList);
        this.distinctKeys = distinctKeys;
        this.filterArg = filterArg;
        this.collation = Objects.requireNonNull(collation, "collation");
        this.distinct = distinct;
        this.approximate = approximate;
        this.ignoreNulls = ignoreNulls;
        Preconditions.checkArgument((aggFunction.getDistinctOptionality() != Optionality.IGNORED || !distinct ? 1 : 0) != 0, (Object)"DISTINCT has no effect for this aggregate function, so must be false");
        Preconditions.checkArgument((filterArg < 0 || aggFunction.allowsFilter() ? 1 : 0) != 0);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int groupCount, RelNode input, @Nullable RelDataType type, @Nullable String name) {
        return AggregateCall.create(aggFunction, distinct, false, false, (List<RexNode>)ImmutableList.of(), argList, -1, null, RelCollations.EMPTY, groupCount, input, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int filterArg, int groupCount, RelNode input, @Nullable RelDataType type, @Nullable String name) {
        return AggregateCall.create(aggFunction, distinct, false, false, (List<RexNode>)ImmutableList.of(), argList, filterArg, null, RelCollations.EMPTY, groupCount, input, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, int groupCount, RelNode input, @Nullable RelDataType type, @Nullable String name) {
        return AggregateCall.create(aggFunction, distinct, approximate, false, (List<RexNode>)ImmutableList.of(), argList, filterArg, null, RelCollations.EMPTY, groupCount, input, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, RelCollation collation, int groupCount, RelNode input, @Nullable RelDataType type, @Nullable String name) {
        return AggregateCall.create(aggFunction, distinct, approximate, false, (List<RexNode>)ImmutableList.of(), argList, filterArg, null, collation, groupCount, input, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, List<Integer> argList, int filterArg, @Nullable ImmutableBitSet distinctKeys, RelCollation collation, int groupCount, RelNode input, @Nullable RelDataType type, @Nullable String name) {
        return AggregateCall.create(aggFunction, distinct, approximate, ignoreNulls, (List<RexNode>)ImmutableList.of(), argList, filterArg, distinctKeys, collation, groupCount, input, type, name);
    }

    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, List<RexNode> rexList, List<Integer> argList, int filterArg, @Nullable ImmutableBitSet distinctKeys, RelCollation collation, int groupCount, RelNode input, @Nullable RelDataType type, @Nullable String name) {
        if (type == null) {
            RelDataTypeFactory typeFactory = input.getCluster().getTypeFactory();
            List<RelDataType> preTypes = RexUtil.types(rexList);
            List<RelDataType> types = SqlTypeUtil.projectTypes(input.getRowType(), argList);
            Aggregate.AggCallBinding callBinding = new Aggregate.AggCallBinding(typeFactory, aggFunction, preTypes, types, groupCount, filterArg >= 0);
            type = aggFunction.inferReturnType(callBinding);
        }
        return AggregateCall.create(aggFunction, distinct, approximate, ignoreNulls, rexList, argList, filterArg, distinctKeys, collation, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int filterArg, RelDataType type, @Nullable String name) {
        return AggregateCall.create(aggFunction, distinct, false, false, (List<RexNode>)ImmutableList.of(), argList, filterArg, null, RelCollations.EMPTY, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, RelDataType type, @Nullable String name) {
        return AggregateCall.create(aggFunction, distinct, approximate, false, (List<RexNode>)ImmutableList.of(), argList, filterArg, null, RelCollations.EMPTY, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, RelCollation collation, RelDataType type, @Nullable String name) {
        return AggregateCall.create(aggFunction, distinct, approximate, false, (List<RexNode>)ImmutableList.of(), argList, filterArg, null, collation, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, List<Integer> argList, int filterArg, RelCollation collation, RelDataType type, @Nullable String name) {
        return AggregateCall.create(aggFunction, distinct, approximate, ignoreNulls, (List<RexNode>)ImmutableList.of(), argList, filterArg, null, collation, type, name);
    }

    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, List<RexNode> rexList, List<Integer> argList, int filterArg, @Nullable ImmutableBitSet distinctKeys, RelCollation collation, RelDataType type, @Nullable String name) {
        boolean distinct2 = distinct && aggFunction.getDistinctOptionality() != Optionality.IGNORED;
        return new AggregateCall(aggFunction, distinct2, approximate, ignoreNulls, rexList, argList, filterArg, distinctKeys, collation, type, name);
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public AggregateCall withDistinct(boolean distinct) {
        return distinct == this.distinct ? this : new AggregateCall(this.aggFunction, distinct, this.approximate, this.ignoreNulls, this.rexList, (List<Integer>)this.argList, this.filterArg, this.distinctKeys, this.collation, this.type, this.name);
    }

    public final boolean isApproximate() {
        return this.approximate;
    }

    public AggregateCall withApproximate(boolean approximate) {
        return approximate == this.approximate ? this : new AggregateCall(this.aggFunction, this.distinct, approximate, this.ignoreNulls, this.rexList, (List<Integer>)this.argList, this.filterArg, this.distinctKeys, this.collation, this.type, this.name);
    }

    public final boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    public AggregateCall withIgnoreNulls(boolean ignoreNulls) {
        return ignoreNulls == this.ignoreNulls ? this : new AggregateCall(this.aggFunction, this.distinct, this.approximate, ignoreNulls, this.rexList, (List<Integer>)this.argList, this.filterArg, this.distinctKeys, this.collation, this.type, this.name);
    }

    public final SqlAggFunction getAggregation() {
        return this.aggFunction;
    }

    public RelCollation getCollation() {
        return this.collation;
    }

    public AggregateCall withCollation(RelCollation collation) {
        return collation.equals(this.collation) ? this : new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, (List<Integer>)this.argList, this.filterArg, this.distinctKeys, collation, this.type, this.name);
    }

    public final List<Integer> getArgList() {
        return this.argList;
    }

    public AggregateCall withArgList(List<Integer> argList) {
        return argList.equals(this.argList) ? this : new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, argList, this.filterArg, this.distinctKeys, this.collation, this.type, this.name);
    }

    public AggregateCall withDistinctKeys(@Nullable ImmutableBitSet distinctKeys) {
        return Objects.equals(distinctKeys, this.distinctKeys) ? this : new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, (List<Integer>)this.argList, this.filterArg, distinctKeys, this.collation, this.type, this.name);
    }

    public final RelDataType getType() {
        return this.type;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public AggregateCall withName(@Nullable String name) {
        return Objects.equals(name, this.name) ? this : new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, (List<Integer>)this.argList, this.filterArg, this.distinctKeys, this.collation, this.type, name);
    }

    @Deprecated
    public AggregateCall rename(@Nullable String name) {
        return this.withName(name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.aggFunction.toString());
        buf.append("(");
        if (this.approximate) {
            buf.append("APPROXIMATE ");
        }
        if (this.distinct) {
            buf.append(this.argList.size() == 0 ? "DISTINCT" : "DISTINCT ");
        }
        int i = -1;
        for (RexNode rexNode : this.rexList) {
            if (++i > 0) {
                buf.append(", ");
            }
            buf.append(rexNode);
        }
        for (Integer arg : this.argList) {
            if (++i > 0) {
                buf.append(", ");
            }
            buf.append("$");
            buf.append(arg);
        }
        buf.append(")");
        if (this.distinctKeys != null) {
            buf.append(" WITHIN DISTINCT (");
            for (Ord key : Ord.zip((Iterable)this.distinctKeys)) {
                buf.append(key.i > 0 ? ", $" : "$");
                buf.append(key.e);
            }
            buf.append(")");
        }
        if (!this.collation.equals(RelCollations.EMPTY)) {
            buf.append(" WITHIN GROUP (");
            buf.append(this.collation);
            buf.append(")");
        }
        if (this.hasFilter()) {
            buf.append(" FILTER $");
            buf.append(this.filterArg);
        }
        return buf.toString();
    }

    public boolean hasFilter() {
        return this.filterArg >= 0;
    }

    public AggregateCall withFilter(int filterArg) {
        return filterArg == this.filterArg ? this : new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, (List<Integer>)this.argList, filterArg, this.distinctKeys, this.collation, this.type, this.name);
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof AggregateCall && this.aggFunction.equals(((AggregateCall)o).aggFunction) && this.distinct == ((AggregateCall)o).distinct && this.approximate == ((AggregateCall)o).approximate && this.ignoreNulls == ((AggregateCall)o).ignoreNulls && this.argList.equals(((AggregateCall)o).argList) && this.filterArg == ((AggregateCall)o).filterArg && Objects.equals(this.distinctKeys, ((AggregateCall)o).distinctKeys) && this.collation.equals(((AggregateCall)o).collation);
    }

    public int hashCode() {
        return Objects.hash(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, this.argList, this.filterArg, this.distinctKeys, this.collation);
    }

    public Aggregate.AggCallBinding createBinding(Aggregate aggregateRelBase) {
        RelDataType rowType = aggregateRelBase.getInput().getRowType();
        RelDataTypeFactory typeFactory = aggregateRelBase.getCluster().getTypeFactory();
        if (this.aggFunction.getKind() == SqlKind.PERCENTILE_DISC || this.aggFunction.getKind() == SqlKind.PERCENTILE_CONT) {
            assert (this.collation.getKeys().size() == 1);
            return new Aggregate.PercentileDiscAggCallBinding(typeFactory, this.aggFunction, SqlTypeUtil.projectTypes(rowType, this.argList), SqlTypeUtil.projectTypes(rowType, this.collation.getKeys()).get(0), aggregateRelBase.getGroupCount(), this.hasFilter());
        }
        return new Aggregate.AggCallBinding(typeFactory, this.aggFunction, RexUtil.types(this.rexList), SqlTypeUtil.projectTypes(rowType, this.argList), aggregateRelBase.getGroupCount(), this.hasFilter());
    }

    @Deprecated
    public AggregateCall copy(List<Integer> argList, int filterArg, @Nullable ImmutableBitSet distinctKeys, RelCollation collation) {
        return new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, argList, filterArg, distinctKeys, collation, this.type, this.name);
    }

    @Deprecated
    public AggregateCall copy(List<Integer> argList, int filterArg, RelCollation collation) {
        return new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, argList, filterArg, this.distinctKeys, collation, this.type, this.name);
    }

    @Deprecated
    public AggregateCall copy(List<Integer> argList, int filterArg) {
        return new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, argList, filterArg, this.distinctKeys, this.collation, this.type, this.name);
    }

    @Deprecated
    public AggregateCall copy(List<Integer> argList) {
        return new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, argList, this.filterArg, this.distinctKeys, this.collation, this.type, this.name);
    }

    public AggregateCall adaptTo(RelNode input, List<Integer> argList, int filterArg, int oldGroupKeyCount, int newGroupKeyCount) {
        RelDataType newType = oldGroupKeyCount == newGroupKeyCount && argList.equals(this.argList) && filterArg == this.filterArg ? this.type : null;
        return AggregateCall.create(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, argList, filterArg, this.distinctKeys, this.collation, newGroupKeyCount, input, newType, this.getName());
    }

    public AggregateCall transform(Mappings.TargetMapping mapping) {
        return new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.rexList, Mappings.apply2((Mapping)mapping, this.argList), this.hasFilter() ? Mappings.apply(mapping, this.filterArg) : -1, this.distinctKeys == null ? null : this.distinctKeys.permute(mapping), RelCollations.permute(this.collation, mapping), this.type, this.name);
    }
}

