/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.loadbalancing.roundrobin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.cluster.ClusterNode;

class RoundRobinPerTaskLoadBalancer {
    private ArrayDeque<ClusterNode> nodeQueue;
    private volatile boolean isMapped;
    private final Object mux = new Object();

    RoundRobinPerTaskLoadBalancer() {
    }

    void onMapped() {
        this.isMapped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterNode getBalancedNode(List<ClusterNode> top) {
        assert (top != null);
        assert (!top.isEmpty());
        boolean readjust = this.isMapped;
        Object object = this.mux;
        synchronized (object) {
            if (this.nodeQueue == null) {
                this.nodeQueue = new ArrayDeque<ClusterNode>(top);
            }
            if (readjust) {
                for (ClusterNode node : top) {
                    if (this.nodeQueue.contains(node)) continue;
                    this.nodeQueue.offer(node);
                }
            }
            ClusterNode next = this.nodeQueue.poll();
            if (readjust && next != null) {
                while (!top.contains(next) && !this.nodeQueue.isEmpty()) {
                    next = this.nodeQueue.poll();
                }
                if (next != null && !top.contains(next)) {
                    return null;
                }
            }
            if (next != null) {
                this.nodeQueue.offer(next);
            }
            return next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ClusterNode> getNodes() {
        Object object = this.mux;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<ClusterNode>(this.nodeQueue));
        }
    }
}

