/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.encryption;

import java.util.function.Consumer;
import org.apache.ignite.internal.management.encryption.CacheGroupEncryptionCommand;
import org.apache.ignite.internal.management.encryption.EncryptionCacheGroupArg;
import org.apache.ignite.internal.management.encryption.ReencryptionStatusTask;

public class EncryptionReencryptionStatusCommand
extends CacheGroupEncryptionCommand<Long> {
    @Override
    public String description() {
        return "Display re-encryption status of the cache group";
    }

    @Override
    public Class<EncryptionCacheGroupArg> argClass() {
        return EncryptionCacheGroupArg.class;
    }

    @Override
    public Class<ReencryptionStatusTask> taskClass() {
        return ReencryptionStatusTask.class;
    }

    @Override
    protected void printNodeResult(Long bytesLeft, String grpName, Consumer<String> printer) {
        if (bytesLeft == -1L) {
            printer.accept("    re-encryption completed or not required");
        } else if (bytesLeft == 0L) {
            printer.accept("    re-encryption will be completed after the next checkpoint");
        } else {
            printer.accept(String.format("%s%d KB of data left for re-encryption", "    ", bytesLeft / 1024L));
        }
    }
}

