/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.ddl;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryEntityEx;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.calcite.exec.ddl.NativeCommandHandler;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.AlterTableAddCommand;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.AlterTableDropCommand;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.ColumnDefinition;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.CreateTableCommand;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.DdlCommand;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.DropTableCommand;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.NativeCommandWrapper;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.TransactionCommand;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteCacheTable;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.schema.management.SchemaManager;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityPermission;

public class DdlCommandHandler {
    private final GridQueryProcessor qryProc;
    private final GridCacheProcessor cacheProc;
    private final IgniteSecurity security;
    private final Supplier<SchemaPlus> schemaSupp;
    private final NativeCommandHandler nativeCmdHnd;
    private final SchemaManager schemaMgr;

    public DdlCommandHandler(GridQueryProcessor qryProc, GridCacheProcessor cacheProc, IgniteSecurity security, Supplier<SchemaPlus> schemaSupp) {
        this.qryProc = qryProc;
        this.cacheProc = cacheProc;
        this.security = security;
        this.schemaSupp = schemaSupp;
        this.schemaMgr = qryProc.schemaManager();
        this.nativeCmdHnd = new NativeCommandHandler(cacheProc.context().kernalContext());
    }

    public void handle(UUID qryId, DdlCommand cmd) throws IgniteCheckedException {
        block8: {
            try {
                if (cmd instanceof TransactionCommand) {
                    return;
                }
                if (cmd instanceof CreateTableCommand) {
                    this.handle0((CreateTableCommand)cmd);
                    break block8;
                }
                if (cmd instanceof DropTableCommand) {
                    this.handle0((DropTableCommand)cmd);
                    break block8;
                }
                if (cmd instanceof AlterTableAddCommand) {
                    this.handle0((AlterTableAddCommand)cmd);
                    break block8;
                }
                if (cmd instanceof AlterTableDropCommand) {
                    this.handle0((AlterTableDropCommand)cmd);
                    break block8;
                }
                if (cmd instanceof NativeCommandWrapper) {
                    this.nativeCmdHnd.handle(qryId, (NativeCommandWrapper)cmd);
                    break block8;
                }
                throw new IgniteSQLException("Unsupported DDL operation [cmdName=" + (cmd == null ? null : cmd.getClass().getSimpleName()) + "; cmd=\"" + cmd + "\"]", 1002);
            }
            catch (SchemaOperationException e) {
                throw QueryUtils.convert((SchemaOperationException)e);
            }
        }
    }

    private void handle0(CreateTableCommand cmd) throws IgniteCheckedException {
        this.security.authorize(cmd.cacheName(), SecurityPermission.CACHE_CREATE);
        QueryUtils.isDdlOnSchemaSupported((String)cmd.schemaName());
        if (this.schemaSupp.get().getSubSchema(cmd.schemaName()).getTable(cmd.tableName()) != null) {
            if (cmd.ifNotExists()) {
                return;
            }
            throw new SchemaOperationException(3, cmd.tableName());
        }
        CacheConfiguration ccfg = new CacheConfiguration(cmd.tableName());
        QueryEntity e = this.toQueryEntity(cmd);
        ccfg.setQueryEntities(Collections.singleton(e));
        ccfg.setSqlSchema(cmd.schemaName());
        SchemaOperationException err = QueryUtils.checkQueryEntityConflicts((CacheConfiguration)ccfg, this.cacheProc.cacheDescriptors().values());
        if (err != null) {
            throw QueryUtils.convert((SchemaOperationException)err);
        }
        if (!F.isEmpty((String)cmd.cacheName()) && this.cacheProc.cacheDescriptor(cmd.cacheName()) != null) {
            this.qryProc.dynamicAddQueryEntity(cmd.cacheName(), cmd.schemaName(), e, null, true).get();
        } else {
            this.qryProc.dynamicTableCreate(cmd.schemaName(), e, cmd.templateName(), cmd.cacheName(), cmd.cacheGroup(), cmd.dataRegionName(), cmd.affinityKey(), cmd.atomicityMode(), cmd.writeSynchronizationMode(), cmd.backups(), cmd.ifNotExists(), Boolean.valueOf(cmd.encrypted()), null);
        }
    }

    private void handle0(DropTableCommand cmd) throws IgniteCheckedException {
        QueryUtils.isDdlOnSchemaSupported((String)cmd.schemaName());
        Table tbl = this.schemaSupp.get().getSubSchema(cmd.schemaName()).getTable(cmd.tableName());
        if (tbl == null) {
            if (!cmd.ifExists()) {
                throw new SchemaOperationException(2, cmd.tableName());
            }
            return;
        }
        assert (tbl instanceof IgniteCacheTable) : tbl;
        String cacheName = ((IgniteCacheTable)tbl).descriptor().cacheInfo().name();
        this.security.authorize(cacheName, SecurityPermission.CACHE_DESTROY);
        this.qryProc.dynamicTableDrop(cacheName, cmd.tableName(), cmd.ifExists());
    }

    private void handle0(AlterTableAddCommand cmd) throws IgniteCheckedException {
        QueryUtils.isDdlOnSchemaSupported((String)cmd.schemaName());
        TableDescriptor tblDesc = this.schemaMgr.table(cmd.schemaName(), cmd.tableName());
        if (tblDesc == null) {
            if (!cmd.ifTableExists()) {
                throw new SchemaOperationException(2, cmd.tableName());
            }
        } else {
            GridQueryTypeDescriptor typeDesc = tblDesc.type();
            if (QueryUtils.isSqlType((Class)typeDesc.valueClass())) {
                throw new SchemaOperationException("Cannot add column(s) because table was created with WRAP_VALUE=false option.");
            }
            ArrayList<QueryField> cols = new ArrayList<QueryField>(cmd.columns().size());
            boolean allFieldsNullable = true;
            for (ColumnDefinition col : cmd.columns()) {
                if (typeDesc.fields().containsKey(col.name())) {
                    if (cmd.ifColumnNotExists()) continue;
                    throw new SchemaOperationException(5, col.name());
                }
                Type javaType = Commons.typeFactory().getResultClass(col.type());
                String typeName = javaType instanceof Class ? ((Class)javaType).getName() : javaType.getTypeName();
                Integer precession = col.precision();
                Integer scale = col.scale();
                QueryField field = new QueryField(col.name(), typeName, col.type().isNullable(), col.defaultValue(), precession == null ? -1 : precession, scale == null ? -1 : scale);
                cols.add(field);
                allFieldsNullable &= field.isNullable();
            }
            if (!F.isEmpty(cols)) {
                GridCacheContextInfo ctxInfo = tblDesc.cacheInfo();
                assert (ctxInfo != null);
                if (!allFieldsNullable) {
                    QueryUtils.checkNotNullAllowed((CacheConfiguration)ctxInfo.config());
                }
                this.qryProc.dynamicColumnAdd(ctxInfo.name(), cmd.schemaName(), typeDesc.tableName(), cols, cmd.ifTableExists(), cmd.ifColumnNotExists()).get();
            }
        }
    }

    private void handle0(AlterTableDropCommand cmd) throws IgniteCheckedException {
        QueryUtils.isDdlOnSchemaSupported((String)cmd.schemaName());
        TableDescriptor tblDesc = this.schemaMgr.table(cmd.schemaName(), cmd.tableName());
        if (tblDesc == null) {
            if (!cmd.ifTableExists()) {
                throw new SchemaOperationException(2, cmd.tableName());
            }
        } else {
            GridQueryTypeDescriptor typeDesc = tblDesc.type();
            GridCacheContextInfo ctxInfo = tblDesc.cacheInfo();
            GridCacheContext cctx = ctxInfo.cacheContext();
            assert (cctx != null);
            if (QueryUtils.isSqlType((Class)typeDesc.valueClass())) {
                throw new SchemaOperationException("Cannot drop column(s) because table was created with WRAP_VALUE=false option.");
            }
            ArrayList<String> cols = new ArrayList<String>(cmd.columns().size());
            for (String colName : cmd.columns()) {
                if (!typeDesc.fields().containsKey(colName)) {
                    if (cmd.ifColumnExists()) continue;
                    throw new SchemaOperationException(4, colName);
                }
                SchemaOperationException err = QueryUtils.validateDropColumn((GridQueryTypeDescriptor)typeDesc, (String)colName);
                if (err != null) {
                    throw err;
                }
                cols.add(colName);
            }
            if (!F.isEmpty(cols)) {
                this.qryProc.dynamicColumnRemove(ctxInfo.name(), cmd.schemaName(), typeDesc.tableName(), cols, cmd.ifTableExists(), cmd.ifColumnExists()).get();
            }
        }
    }

    private QueryEntity toQueryEntity(CreateTableCommand cmd) {
        String keyTypeName;
        QueryEntity res = new QueryEntity();
        res.setTableName(cmd.tableName());
        HashSet<String> notNullFields = null;
        HashMap<String, Object> dfltValues = new HashMap<String, Object>();
        HashMap<String, Integer> precision = new HashMap<String, Integer>();
        HashMap<String, Integer> scale = new HashMap<String, Integer>();
        IgniteTypeFactory tf = Commons.typeFactory();
        for (ColumnDefinition col : cmd.columns()) {
            String name = col.name();
            Type javaType = tf.getResultClass(col.type());
            String typeName = javaType instanceof Class ? ((Class)javaType).getName() : javaType.getTypeName();
            res.addQueryField(name, typeName, null);
            if (!col.nullable()) {
                if (notNullFields == null) {
                    notNullFields = new HashSet<String>();
                }
                notNullFields.add(name);
            }
            if (col.defaultValue() != null) {
                dfltValues.put(name, col.defaultValue());
            }
            if (col.precision() != null) {
                precision.put(name, col.precision());
            }
            if (col.scale() == null) continue;
            scale.put(name, col.scale());
        }
        if (!F.isEmpty(dfltValues)) {
            res.setDefaultFieldValues(dfltValues);
        }
        if (!F.isEmpty(precision)) {
            res.setFieldsPrecision(precision);
        }
        if (!F.isEmpty(scale)) {
            res.setFieldsScale(scale);
        }
        String valTypeName = QueryUtils.createTableValueTypeName((String)cmd.schemaName(), (String)cmd.tableName());
        if (!F.isEmpty(cmd.primaryKeyColumns()) && cmd.primaryKeyColumns().size() > 1 || !F.isEmpty((String)cmd.keyTypeName())) {
            keyTypeName = cmd.keyTypeName();
            if (F.isEmpty((String)keyTypeName)) {
                keyTypeName = QueryUtils.createTableKeyTypeName((String)valTypeName);
            }
            if (!F.isEmpty(cmd.primaryKeyColumns())) {
                res.setKeyFields(new LinkedHashSet<String>(cmd.primaryKeyColumns()));
                res = new QueryEntityEx(res).setPreserveKeysOrder(true);
            }
        } else if (!F.isEmpty(cmd.primaryKeyColumns()) && cmd.primaryKeyColumns().size() == 1) {
            String pkFieldName = cmd.primaryKeyColumns().get(0);
            keyTypeName = (String)res.getFields().get(pkFieldName);
            res.setKeyFieldName(pkFieldName);
        } else {
            keyTypeName = IgniteUuid.class.getName();
            res = new QueryEntityEx(res).implicitPk(true);
        }
        res.setValueType(F.isEmpty((String)cmd.valueTypeName()) ? valTypeName : cmd.valueTypeName());
        res.setKeyType(keyTypeName);
        if (!F.isEmpty(notNullFields)) {
            QueryEntityEx res0 = new QueryEntityEx(res);
            res0.setNotNullFields(notNullFields);
            res = res0;
        }
        return res;
    }
}

