/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.calc.async;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.util.Preconditions;

public class DelegatingAsyncResultFuture
implements BiConsumer<Object, Throwable> {
    private final ResultFuture<Object> delegatedResultFuture;
    private final List<Object> synchronousResults = new ArrayList<Object>();
    private Function<Object, RowData> outputFactory;
    private CompletableFuture<Object> future;
    private CompletableFuture<Object> convertedFuture;

    public DelegatingAsyncResultFuture(ResultFuture<Object> delegatedResultFuture) {
        this.delegatedResultFuture = delegatedResultFuture;
    }

    public synchronized void addSynchronousResult(Object object) {
        this.synchronousResults.add(object);
    }

    public synchronized Object getSynchronousResult(int index) {
        return this.synchronousResults.get(index);
    }

    public void setOutputFactory(Function<Object, RowData> outputFactory) {
        this.outputFactory = outputFactory;
    }

    public CompletableFuture<?> createAsyncFuture(DataStructureConverter<Object, Object> converter) {
        Preconditions.checkState((this.future == null ? 1 : 0) != 0);
        Preconditions.checkState((this.convertedFuture == null ? 1 : 0) != 0);
        Preconditions.checkNotNull(this.outputFactory);
        this.future = new CompletableFuture();
        this.convertedFuture = this.future.thenApply(converter::toInternal);
        this.convertedFuture.whenComplete((BiConsumer)this);
        return this.future;
    }

    @Override
    public void accept(Object o, Throwable throwable) {
        if (throwable != null) {
            this.delegatedResultFuture.completeExceptionally(throwable);
        } else {
            try {
                RowData rowData = this.outputFactory.apply(o);
                this.delegatedResultFuture.complete(Collections.singleton(rowData));
            }
            catch (Throwable t) {
                this.delegatedResultFuture.completeExceptionally(t);
            }
        }
    }
}

