/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.BaseMappingExtractor;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;
import org.apache.flink.table.types.extraction.FunctionTemplate;
import org.apache.flink.table.types.extraction.TemplateUtils;
import org.apache.flink.util.Preconditions;

@Internal
final class FunctionMappingExtractor
extends BaseMappingExtractor {
    private final Class<? extends UserDefinedFunction> function;
    @Nullable
    private final BaseMappingExtractor.ResultExtraction accumulatorExtraction;

    FunctionMappingExtractor(DataTypeFactory typeFactory, Class<? extends UserDefinedFunction> function, String methodName, BaseMappingExtractor.SignatureExtraction signatureExtraction, @Nullable BaseMappingExtractor.ResultExtraction accumulatorExtraction, BaseMappingExtractor.ResultExtraction outputExtraction, BaseMappingExtractor.MethodVerification verification) {
        super(typeFactory, methodName, signatureExtraction, outputExtraction, verification);
        this.function = function;
        this.accumulatorExtraction = accumulatorExtraction;
    }

    Class<? extends UserDefinedFunction> getFunction() {
        return this.function;
    }

    boolean hasAccumulator() {
        return this.accumulatorExtraction != null;
    }

    @Override
    protected Set<FunctionTemplate> extractGlobalFunctionTemplates() {
        return TemplateUtils.extractGlobalFunctionTemplates(this.typeFactory, this.function);
    }

    @Override
    protected Set<FunctionTemplate> extractLocalFunctionTemplates(Method method) {
        return TemplateUtils.extractLocalFunctionTemplates(this.typeFactory, method);
    }

    @Override
    protected List<Method> collectMethods(String methodName) {
        return ExtractionUtils.collectMethods(this.function, methodName);
    }

    @Override
    protected Class<?> getFunctionClass() {
        return this.function;
    }

    @Override
    protected String getHintType() {
        return "Function";
    }

    Map<FunctionSignatureTemplate, FunctionResultTemplate> extractAccumulatorMapping() {
        Preconditions.checkState((boolean)this.hasAccumulator());
        try {
            return this.extractResultMappings(this.accumulatorExtraction, FunctionTemplate::getAccumulatorTemplate, (method, signature, result) -> {
                List<Class<?>> arguments = Stream.concat(Stream.of(result), signature.stream()).collect(Collectors.toList());
                this.verification.verify(method, arguments, null);
            });
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Error in extracting a signature to accumulator mapping.", new Object[0]);
        }
    }

    static BaseMappingExtractor.ResultExtraction createReturnTypeResultExtraction() {
        return (extractor, method) -> {
            DataType dataType = DataTypeExtractor.extractFromMethodOutput(extractor.typeFactory, extractor.getFunctionClass(), method);
            return FunctionResultTemplate.of(dataType);
        };
    }

    static BaseMappingExtractor.ResultExtraction createGenericResultExtraction(Class<? extends UserDefinedFunction> baseClass, int genericPos, boolean allowDataTypeHint) {
        return (extractor, method) -> {
            if (allowDataTypeHint) {
                HashSet<DataTypeHint> dataTypeHints = new HashSet<DataTypeHint>();
                dataTypeHints.addAll(ExtractionUtils.collectAnnotationsOfMethod(DataTypeHint.class, method));
                dataTypeHints.addAll(ExtractionUtils.collectAnnotationsOfClass(DataTypeHint.class, extractor.getFunctionClass()));
                if (dataTypeHints.size() > 1) {
                    throw ExtractionUtils.extractionError("More than one data type hint found for output of function. Please use a function hint instead.", new Object[0]);
                }
                if (dataTypeHints.size() == 1) {
                    return FunctionTemplate.createResultTemplate(extractor.typeFactory, (DataTypeHint)dataTypeHints.iterator().next());
                }
            }
            DataType dataType = DataTypeExtractor.extractFromGeneric(extractor.typeFactory, baseClass, genericPos, extractor.getFunctionClass());
            return FunctionResultTemplate.of(dataType);
        };
    }

    static BaseMappingExtractor.MethodVerification createParameterAndReturnTypeVerification() {
        return (method, signature, result) -> {
            boolean isValid;
            Class[] parameters = signature.toArray(new Class[0]);
            Class<?> returnType = method.getReturnType();
            boolean bl = isValid = ExtractionUtils.isInvokable(method, parameters) && ExtractionUtils.isAssignable(result, returnType, true);
            if (!isValid) {
                throw FunctionMappingExtractor.createMethodNotFoundError(method.getName(), parameters, result);
            }
        };
    }

    static BaseMappingExtractor.MethodVerification createParameterWithAccumulatorVerification() {
        return (method, signature, result) -> {
            if (result != null) {
                FunctionMappingExtractor.createParameterWithArgumentVerification(null).verify(method, signature, result);
            } else {
                FunctionMappingExtractor.createParameterVerification().verify(method, signature, null);
            }
        };
    }

    static BaseMappingExtractor.MethodVerification createParameterWithArgumentVerification(@Nullable Class<?> argumentClass) {
        return (method, signature, result) -> {
            Class[] parameters = (Class[])Stream.concat(Stream.of(argumentClass), signature.stream()).toArray(Class[]::new);
            if (!ExtractionUtils.isInvokable(method, parameters)) {
                throw FunctionMappingExtractor.createMethodNotFoundError(method.getName(), parameters, null);
            }
        };
    }

    static BaseMappingExtractor.MethodVerification createParameterVerification() {
        return (method, signature, result) -> {
            Class[] parameters = signature.toArray(new Class[0]);
            if (!ExtractionUtils.isInvokable(method, parameters)) {
                throw FunctionMappingExtractor.createMethodNotFoundError(method.getName(), parameters, null);
            }
        };
    }
}

