/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.guava30.com.google.common.io.Files;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.resource.ResourceType;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.JarUtils;
import org.apache.flink.util.MutableURLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ResourceManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManager.class);
    private static final String JAR_SUFFIX = "jar";
    private static final String FILE_SCHEME = "file";
    private final Path localResourceDir;
    protected final Map<ResourceUri, URL> resourceInfos;
    protected final MutableURLClassLoader userClassLoader;

    public static ResourceManager createResourceManager(URL[] urls, ClassLoader parent, ReadableConfig config) {
        MutableURLClassLoader mutableURLClassLoader = FlinkUserCodeClassLoaders.create((URL[])urls, (ClassLoader)parent, (ReadableConfig)config);
        return new ResourceManager(config, mutableURLClassLoader);
    }

    public ResourceManager(ReadableConfig config, MutableURLClassLoader userClassLoader) {
        this.localResourceDir = new Path((String)config.get(TableConfigOptions.RESOURCES_DOWNLOAD_DIR), String.format("flink-table-%s", UUID.randomUUID()));
        this.resourceInfos = new HashMap<ResourceUri, URL>();
        this.userClassLoader = userClassLoader;
    }

    public void registerJarResources(List<ResourceUri> resourceUris) throws IOException {
        this.checkJarResources(resourceUris);
        HashMap<ResourceUri, URL> stagingResourceLocalURLs = new HashMap<ResourceUri, URL>();
        for (ResourceUri resourceUri2 : resourceUris) {
            URL localUrl;
            if (this.resourceInfos.containsKey(resourceUri2) && this.resourceInfos.get(resourceUri2) != null) {
                LOG.info("Resource [{}] has been registered, overwriting of registered resource is not supported in the current version, skipping.", (Object)resourceUri2.getUri());
                continue;
            }
            Path path = new Path(resourceUri2.getUri());
            String scheme = StringUtils.lowerCase((String)path.toUri().getScheme());
            if (scheme != null && !FILE_SCHEME.equals(scheme)) {
                localUrl = this.downloadResource(path);
            } else {
                localUrl = this.getURLFromPath(path);
                resourceUri2 = new ResourceUri(ResourceType.JAR, localUrl.getPath());
            }
            JarUtils.checkJarFile((URL)localUrl);
            stagingResourceLocalURLs.put(resourceUri2, localUrl);
        }
        stagingResourceLocalURLs.forEach((resourceUri, url) -> {
            this.userClassLoader.addURL(url);
            LOG.info("Added jar resource [{}] to class path.", url);
            this.resourceInfos.put((ResourceUri)resourceUri, (URL)url);
            LOG.info("Register resource [{}] successfully.", (Object)resourceUri.getUri());
        });
    }

    public URLClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    public Map<ResourceUri, URL> getResources() {
        return Collections.unmodifiableMap(this.resourceInfos);
    }

    public Set<URL> getLocalJarResources() {
        return this.resourceInfos.entrySet().stream().filter(entry -> ResourceType.JAR.equals((Object)((ResourceUri)entry.getKey()).getResourceType())).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public void addJarConfiguration(TableConfig tableConfig) {
        List jars = this.getLocalJarResources().stream().map(URL::toString).collect(Collectors.toList());
        if (jars.isEmpty()) {
            return;
        }
        Set jarFiles = tableConfig.getOptional(PipelineOptions.JARS).map(LinkedHashSet::new).orElseGet(LinkedHashSet::new);
        jarFiles.addAll(jars);
        tableConfig.set(PipelineOptions.JARS, new ArrayList(jarFiles));
    }

    @Override
    public void close() throws IOException {
        this.resourceInfos.clear();
        IOException exception = null;
        try {
            this.userClassLoader.close();
        }
        catch (IOException e) {
            LOG.debug("Error while closing user classloader.", (Throwable)e);
            exception = e;
        }
        FileSystem fileSystem = FileSystem.getLocalFileSystem();
        try {
            if (fileSystem.exists(this.localResourceDir)) {
                fileSystem.delete(this.localResourceDir, true);
            }
        }
        catch (IOException ioe) {
            LOG.debug(String.format("Error while delete directory [%s].", this.localResourceDir), (Throwable)ioe);
            exception = (IOException)ExceptionUtils.firstOrSuppressed((Throwable)ioe, (Throwable)exception);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void checkJarResources(List<ResourceUri> resourceUris) throws IOException {
        if (resourceUris.stream().anyMatch(resourceUri -> !ResourceType.JAR.equals((Object)resourceUri.getResourceType()))) {
            throw new ValidationException(String.format("Only support to register jar resource, resource info:\n %s.", resourceUris.stream().map(ResourceUri::getUri).collect(Collectors.joining(",\n"))));
        }
        for (ResourceUri resourceUri2 : resourceUris) {
            this.checkJarPath(new Path(resourceUri2.getUri()));
        }
    }

    protected void checkJarPath(Path path) throws IOException {
        String fileExtension = Files.getFileExtension((String)path.getName());
        if (!fileExtension.toLowerCase().endsWith(JAR_SUFFIX)) {
            throw new ValidationException(String.format("The registering or unregistering jar resource [%s] must ends with '.jar' suffix.", path));
        }
        FileSystem fs = FileSystem.getUnguardedFileSystem((URI)path.toUri());
        if (!fs.exists(path)) {
            throw new FileNotFoundException(String.format("Jar resource [%s] not found.", path));
        }
        if (fs.getFileStatus(path).isDir()) {
            throw new ValidationException(String.format("The registering or unregistering jar resource [%s] is a directory that is not allowed.", path));
        }
    }

    @VisibleForTesting
    URL downloadResource(Path remotePath) throws IOException {
        Path localPath = this.getResourceLocalPath(remotePath);
        try {
            FileUtils.copy((Path)remotePath, (Path)localPath, (boolean)true);
            LOG.info("Download resource [{}] to local path [{}] successfully.", (Object)remotePath, (Object)localPath);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to download resource [%s] to local path [%s].", remotePath, localPath), e);
        }
        return this.getURLFromPath(localPath);
    }

    @VisibleForTesting
    protected URL getURLFromPath(Path path) throws IOException {
        if (path.toUri().getScheme() == null) {
            path = path.makeQualified(FileSystem.getLocalFileSystem());
        }
        return path.toUri().toURL();
    }

    @VisibleForTesting
    Path getLocalResourceDir() {
        return this.localResourceDir;
    }

    private Path getResourceLocalPath(Path remotePath) {
        String fileName = remotePath.getName();
        String fileExtension = Files.getFileExtension((String)fileName);
        String fileNameWithUUID = StringUtils.isEmpty((CharSequence)fileExtension) ? String.format("%s-%s", fileName, UUID.randomUUID()) : String.format("%s-%s.%s", Files.getNameWithoutExtension((String)fileName), UUID.randomUUID(), fileExtension);
        return new Path(this.localResourceDir, fileNameWithUUID);
    }
}

