////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package org.apache.flex.reflection {
COMPILE::SWF {
    import flash.net.registerClassAlias;
}
    /**
     * Sets up an alias mapping for serialization/deserialization purposes
     * This can be auto-generated by the FlexJS compiler
     * when using class level metadata e.g. [RemoteClass(alias='someAlias')]
     *
     * @param aliasName the alias name to use to look up the class definition
     * @param classObject the class to map to the alias name
     *
     */
    public function registerClassAlias(aliasName:String, classObject:Class):void {
        COMPILE::SWF {
            flash.net.registerClassAlias(aliasName,classObject);
        }

        COMPILE::JS {
            if (classObject == null) throw new TypeError("Parameter classObject must be non-null.");
            if (aliasName == null) throw new TypeError("Parameter aliasName must be non-null.");
            if (aliasName.length==0) throw new TypeError("Parameter aliasName must be non-empty string.");
            TypeDefinition.registerClassAlias(aliasName , classObject);
        }
    }
}
