/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.net.InetAddress;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.ssdp.HTTPMUSocket;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPNotifyRequest;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.Debug;

public class SSDPNotifySocket
extends HTTPMUSocket
implements Runnable {
    private ControlPoint controlPoint = null;
    private Thread deviceNotifyThread = null;

    public SSDPNotifySocket(String bindAddr) {
        String addr = "239.255.255.250";
        this.open(addr, SSDP.PORT, bindAddr);
        this.setControlPoint(null);
    }

    public void setControlPoint(ControlPoint ctrlp) {
        this.controlPoint = ctrlp;
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public boolean post(SSDPNotifyRequest req) {
        String ssdpAddr = "239.255.255.250";
        req.setHost(ssdpAddr, SSDP.PORT);
        return this.post((HTTPRequest)req);
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        ControlPoint ctrlPoint = this.getControlPoint();
        while (this.deviceNotifyThread == thisThread) {
            InetAddress pmaddr;
            Thread.yield();
            SSDPPacket packet = this.receive();
            if (packet == null) continue;
            InetAddress maddr = this.getMulticastInetAddress();
            if (!maddr.equals(pmaddr = packet.getHostInetAddress())) {
                Debug.warning("Invalidate Multicast Recieved from IP " + maddr + " on " + pmaddr);
                continue;
            }
            if (ctrlPoint == null) continue;
            ctrlPoint.notifyReceived(packet);
        }
    }

    public void start() {
        StringBuffer name = new StringBuffer("Cyber.SSDPNotifySocket/");
        name.append(this.getLocalAddress()).append(':');
        name.append(this.getLocalPort()).append(" -> ");
        name.append(this.getMulticastAddress()).append(':');
        name.append(this.getMulticastPort());
        this.deviceNotifyThread = new Thread((Runnable)this, name.toString());
        this.deviceNotifyThread.start();
    }

    public void stop() {
        this.close();
        this.deviceNotifyThread = null;
    }
}

