/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;

class TerminalReader
extends Reader {
    protected final InputStream m_in;
    protected final PrintStream m_out;
    protected boolean m_echo = false;
    protected boolean m_eof = false;
    public static final byte BEL = 7;
    public static final byte BS = 8;
    public static final byte DEL = 127;
    public static final byte CTRL_U = 21;
    private static byte ESC = (byte)27;
    private static byte[] CURSOR_LEFT = new byte[]{ESC, 91, 49, 68};
    private static byte[] ERASE_TEOL = new byte[]{ESC, 91, 75};
    private static byte[] CRLF = new byte[]{13, 10};
    private static byte EOT = (byte)4;

    public TerminalReader(InputStream in, PrintStream out) {
        this.m_in = in;
        this.m_out = out;
    }

    public boolean isEcho() {
        return this.m_echo;
    }

    public void setEcho(boolean echo) {
        this.m_echo = echo;
    }

    public int read(char[] chars, int off, int len) throws IOException {
        if (this.m_eof) {
            return -1;
        }
        for (int i = off; i < off + len; ++i) {
            int ch = this.m_in.read();
            if (ch == EOT || i == off && ch == -1) {
                return -1;
            }
            chars[i] = (char)ch;
            if (ch == -1 || ch == 10 || ch == 13) {
                this.m_eof = ch == -1;
                int read = i - off + 1;
                if (this.m_echo) {
                    this.m_out.write(CRLF);
                }
                return read;
            }
            if (ch == 8 || ch == 127) {
                if (i > off) {
                    i -= 2;
                    this.moveLeft(1);
                    this.eraseToEndOfLine();
                    continue;
                }
                --i;
                this.bell();
                continue;
            }
            if (ch == 21) {
                this.moveLeft(i - off);
                this.eraseToEndOfLine();
                i = off - 1;
                continue;
            }
            if (!this.m_echo) continue;
            this.m_out.write(chars[i]);
        }
        return len;
    }

    private void bell() {
        this.m_out.write(7);
        this.m_out.flush();
    }

    private void moveLeft(int i) throws IOException {
        TerminalReader.CURSOR_LEFT[2] = Byte.decode(Integer.toString(i));
        this.m_out.write(CURSOR_LEFT);
        this.m_out.flush();
    }

    private void eraseToEndOfLine() throws IOException {
        this.m_out.write(ERASE_TEOL);
        this.m_out.flush();
    }

    public void close() throws IOException {
        this.m_in.close();
    }
}

