/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handler.temporal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.ipojo.handler.temporal.TemporalDependency;
import org.osgi.framework.ServiceReference;

public class ServiceCollection
implements Collection {
    private TemporalDependency m_dependency;

    public ServiceCollection(TemporalDependency dep) {
        this.m_dependency = dep;
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("Cannot add elements inside this collection");
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("Cannot add elements inside this collection");
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot remove elements from this collection");
    }

    public boolean contains(Object o) {
        return this.getAvailableObjects().contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.getAvailableObjects().containsAll(c);
    }

    public boolean isEmpty() {
        return this.m_dependency.getSize() == 0;
    }

    private List getAvailableObjects() {
        ArrayList<Object> list = new ArrayList<Object>();
        ServiceReference[] refs = this.m_dependency.getServiceReferences();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                list.add(this.m_dependency.getService(refs[i]));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Iterator iterator() {
        ServiceReference[] refs = this.m_dependency.getServiceReferences();
        if (refs != null) {
            return new ServiceIterator(refs);
        }
        long enter = System.currentTimeMillis();
        boolean exhausted = false;
        ServiceCollection serviceCollection = this;
        synchronized (serviceCollection) {
            while (this.m_dependency.getServiceReference() == null && !exhausted) {
                long end;
                try {
                    this.wait(1L);
                }
                catch (InterruptedException e) {
                    end = System.currentTimeMillis();
                    exhausted = end - enter > this.m_dependency.getTimeout();
                    continue;
                    catch (Throwable throwable) {
                        long end2 = System.currentTimeMillis();
                        exhausted = end2 - enter > this.m_dependency.getTimeout();
                        throw throwable;
                    }
                }
                end = System.currentTimeMillis();
                exhausted = end - enter > this.m_dependency.getTimeout();
            }
        }
        if (exhausted) {
            Object oto = this.m_dependency.onTimeout();
            if (oto == null) {
                return null;
            }
            return new ServiceIterator((Collection)oto);
        }
        refs = this.m_dependency.getServiceReferences();
        return new ServiceIterator(refs);
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove elements from this collection");
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("Cannot remove elements from this collection");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("Cannot remove elements from this collection");
    }

    public int size() {
        return this.m_dependency.getSize();
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public Object[] toArray(Object[] a) {
        Iterator it = this.iterator();
        if (it == null) {
            return null;
        }
        ArrayList list = new ArrayList(this.size());
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray(a);
    }

    private final class ServiceIterator
    implements Iterator {
        private Iterator m_iterator;

        private ServiceIterator(ServiceReference[] refs) {
            ArrayList<Object> objects = new ArrayList<Object>(refs.length);
            for (int i = 0; i < refs.length; ++i) {
                objects.add(ServiceCollection.this.m_dependency.getService(refs[i]));
            }
            this.m_iterator = objects.iterator();
        }

        private ServiceIterator(Collection col) {
            this.m_iterator = col.iterator();
        }

        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        public Object next() {
            return this.m_iterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

