/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make.component;

import aQute.bnd.annotation.component.Component;
import aQute.bnd.make.component.ComponentAnnotationReader;
import aQute.bnd.make.metatype.MetaTypeReader;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Constants;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import aQute.libg.version.Version;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceComponent
implements AnalyzerPlugin {
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        ComponentMaker m = new ComponentMaker(analyzer);
        Map<String, Map<String, String>> l = m.doServiceComponent();
        analyzer.setProperty("Service-Component", Processor.printClauses(l));
        analyzer.getInfo(m, "Service-Component: ");
        m.close();
        return false;
    }

    static String escape(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\'': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentMaker
    extends Processor {
        Analyzer analyzer;
        public static final Pattern REFERENCE = Pattern.compile("([^(]+)(\\(.+\\))?");

        ComponentMaker(Analyzer analyzer) {
            super(analyzer);
            this.analyzer = analyzer;
        }

        Map<String, Map<String, String>> doServiceComponent() throws Exception {
            Map<String, Map<String, String>> serviceComponents = ComponentMaker.newMap();
            String header = this.getProperty("Service-Component");
            Map<String, Map<String, String>> sc = this.parseHeader(header);
            for (Map.Entry<String, Map<String, String>> entry : sc.entrySet()) {
                String name = entry.getKey();
                Map<String, String> info = entry.getValue();
                try {
                    if (name.indexOf(47) >= 0 || name.endsWith(".xml")) {
                        serviceComponents.put(name, EMPTY);
                        continue;
                    }
                    this.componentEntry(serviceComponents, name, info);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.error("Invalid Service-Component header: %s %s, throws %s", name, info, e);
                }
            }
            return serviceComponents;
        }

        private void componentEntry(Map<String, Map<String, String>> serviceComponents, String name, Map<String, String> info) throws Exception, IOException {
            boolean annotations = !Processor.isTrue(info.get("-noannotations"));
            boolean fqn = Verifier.isFQN(name);
            if (annotations) {
                Collection<Clazz> annotatedComponents = this.analyzer.getClasses("", ((Object)((Object)Clazz.QUERY.ANNOTATION)).toString(), Component.class.getName(), ((Object)((Object)Clazz.QUERY.NAMED)).toString(), name);
                if (fqn) {
                    if (annotatedComponents.isEmpty()) {
                        this.createComponentResource(serviceComponents, name, info);
                    } else {
                        for (Clazz c : annotatedComponents) {
                            this.annotated(serviceComponents, c, info);
                        }
                    }
                } else if (annotatedComponents.isEmpty()) {
                    this.checkAnnotationsFeasible(name);
                } else {
                    for (Clazz c : annotatedComponents) {
                        this.annotated(serviceComponents, c, info);
                    }
                }
            } else if (fqn) {
                this.createComponentResource(serviceComponents, name, info);
            } else {
                this.error("Set to %s but entry %s is not an FQN ", "-noannotations", name);
            }
        }

        private Collection<Clazz> checkAnnotationsFeasible(String name) throws Exception {
            Collection<Clazz> not = this.analyzer.getClasses("", ((Object)((Object)Clazz.QUERY.NAMED)).toString(), name);
            if (not.isEmpty()) {
                if ("*".equals(name)) {
                    return not;
                }
                this.error("Specified %s but could not find any class matching this pattern", name);
            }
            for (Clazz c : not) {
                if (!c.getFormat().hasAnnotations()) continue;
                return not;
            }
            this.warning("Wildcards are used (%s) requiring annotations to decide what is a component. Wildcard maps to classes that are compiled with java.target < 1.5. Annotations were introduced in Java 1.5", name);
            return not;
        }

        void annotated(Map<String, Map<String, String>> components, Clazz c, Map<String, String> info) throws Exception {
            String merged;
            Map<String, String> map = ComponentAnnotationReader.getDefinition(c, this);
            String localname = map.get("name:");
            if (localname == null) {
                localname = c.getFQN();
            }
            if ((merged = Processor.merge(info.remove("properties:"), map.remove("properties:"))) != null && merged.length() > 0) {
                map.put("properties:", merged);
            }
            map.putAll(info);
            this.createComponentResource(components, localname, map);
        }

        private void createComponentResource(Map<String, Map<String, String>> components, String name, Map<String, String> info) throws IOException {
            boolean designate;
            if (info.containsKey("name:")) {
                name = info.get("name:");
            }
            String impl = name;
            if (info.containsKey("implementation:")) {
                impl = info.get("implementation:");
            }
            this.analyzer.referTo(impl);
            boolean bl = designate = this.designate(name, info.get("designate:"), false) || this.designate(name, info.get("designateFactory:"), true);
            if (designate && info.get("configuration-policy:") == null) {
                info.put("configuration-policy:", "require");
            }
            Resource resource = this.createComponentResource(name, impl, info);
            this.analyzer.getJar().putResource("OSGI-INF/" + name + ".xml", resource);
            components.put("OSGI-INF/" + name + ".xml", EMPTY);
        }

        private boolean designate(String name, String config, boolean factory) {
            if (config == null) {
                return false;
            }
            for (String c : Processor.split(config)) {
                Clazz clazz = this.analyzer.getClassspace().get(Clazz.fqnToPath(c));
                if (clazz != null) {
                    this.analyzer.referTo(c);
                    MetaTypeReader r = new MetaTypeReader(clazz, this.analyzer);
                    r.setDesignate(name, factory);
                    String rname = "OSGI-INF/metatype/" + name + ".xml";
                    this.analyzer.getJar().putResource(rname, r);
                    continue;
                }
                this.analyzer.error("Cannot find designated configuration class %s for component %s", c, name);
            }
            return true;
        }

        Resource createComponentResource(String name, String impl, Map<String, String> info) throws IOException {
            String namespace = this.getNamespace(info);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, Constants.DEFAULT_CHARSET));
            pw.println("<?xml version='1.0' encoding='utf-8'?>");
            if (namespace != null) {
                pw.print("<scr:component xmlns:scr='" + namespace + "'");
            } else {
                pw.print("<component");
            }
            this.doAttribute(pw, name, "name", new String[0]);
            this.doAttribute(pw, info.get("factory:"), "factory", new String[0]);
            this.doAttribute(pw, info.get("immediate:"), "immediate", "false", "true");
            this.doAttribute(pw, info.get("enabled:"), "enabled", "true", "false");
            this.doAttribute(pw, info.get("configuration-policy:"), "configuration-policy", "optional", "require", "ignore");
            this.doAttribute(pw, info.get("activate:"), "activate", "<<identifier>>");
            this.doAttribute(pw, info.get("deactivate:"), "deactivate", "<<identifier>>");
            this.doAttribute(pw, info.get("modified:"), "modified", "<<identifier>>");
            pw.println(">");
            pw.println("  <implementation class='" + (impl == null ? name : impl) + "'/>");
            String provides = info.get("provide:");
            boolean servicefactory = Processor.isTrue(info.get("servicefactory:"));
            if (servicefactory && Processor.isTrue(info.get("immediate:"))) {
                this.warning("For a Service Component, the immediate option and the servicefactory option are mutually exclusive for %(%s)", name, impl);
            }
            this.provide(pw, provides, servicefactory, impl);
            this.properties(pw, info);
            this.reference(info, pw);
            if (namespace != null) {
                pw.println("</scr:component>");
            } else {
                pw.println("</component>");
            }
            pw.close();
            byte[] data = out.toByteArray();
            out.close();
            return new EmbeddedResource(data, 0L);
        }

        private void doAttribute(PrintWriter pw, String value, String name, String ... matches) {
            if (value != null) {
                if (matches.length != 0) {
                    if (matches.length == 1 && matches[0].equals("<<identifier>>")) {
                        if (!Verifier.isIdentifier(value)) {
                            this.error("Component attribute %s has value %s but is not a Java identifier", name, value);
                        }
                    } else if (!Verifier.isMember(value, matches)) {
                        this.error("Component attribute %s has value %s but is not a member of %s", name, value, Arrays.toString(matches));
                    }
                }
                pw.print(" ");
                pw.print(name);
                pw.print("='");
                pw.print(value);
                pw.print("'");
            }
        }

        private String getNamespace(Map<String, String> info) {
            String version = info.get("version:");
            if (version != null) {
                try {
                    Version v = new Version(version);
                    return "http://www.osgi.org/xmlns/scr/v" + v;
                }
                catch (Exception e) {
                    this.error("version: specified on component header but not a valid version: " + version, new Object[0]);
                    return null;
                }
            }
            for (String key : info.keySet()) {
                if (!SET_COMPONENT_DIRECTIVES_1_1.contains(key)) continue;
                return "http://www.osgi.org/xmlns/scr/v1.1.0";
            }
            return null;
        }

        void properties(PrintWriter pw, Map<String, String> info) {
            Collection<String> properties = ComponentMaker.split(info.get("properties:"));
            for (String clause : properties) {
                String[] parts;
                String[] parts2;
                int n = clause.indexOf(61);
                if (n <= 0) {
                    this.error("Not a valid property in service component: " + clause, new Object[0]);
                    continue;
                }
                String type = null;
                String name = clause.substring(0, n);
                if (name.indexOf(64) >= 0) {
                    parts2 = name.split("@");
                    name = parts2[1];
                    type = parts2[0];
                } else if (name.indexOf(58) >= 0) {
                    parts2 = name.split(":");
                    name = parts2[0];
                    type = parts2[1];
                }
                String value = clause.substring(n + 1).trim();
                pw.print("  <property name='");
                pw.print(name);
                pw.print("'");
                if (type != null) {
                    if (VALID_PROPERTY_TYPES.matcher(type).matches()) {
                        pw.print(" type='");
                        pw.print(type);
                        pw.print("'");
                    } else {
                        this.warning("Invalid property type '" + type + "' for property " + name, new Object[0]);
                    }
                }
                if ((parts = value.split("\\s*(\\||\\n)\\s*")).length > 1) {
                    pw.println(">");
                    String[] stringArray = parts;
                    int n2 = parts.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String part = stringArray[n3];
                        pw.println(part);
                        ++n3;
                    }
                    pw.println("</property>");
                    continue;
                }
                pw.print(" value='");
                pw.print(parts[0]);
                pw.println("'/>");
            }
        }

        void provide(PrintWriter pw, String provides, boolean servicefactory, String impl) {
            if (provides != null) {
                if (!servicefactory) {
                    pw.println("  <service>");
                } else {
                    pw.println("  <service servicefactory='true'>");
                }
                StringTokenizer st = new StringTokenizer(provides, ",");
                while (st.hasMoreTokens()) {
                    String interfaceName = st.nextToken();
                    pw.println("    <provide interface='" + interfaceName + "'/>");
                    this.analyzer.referTo(interfaceName);
                }
                pw.println("  </service>");
            } else if (servicefactory) {
                this.warning("The servicefactory:=true directive is set but no service is provided, ignoring it", new Object[0]);
            }
        }

        void reference(Map<String, String> info, PrintWriter pw) {
            ArrayList<String> dynamic = new ArrayList<String>(ComponentMaker.split(info.get("dynamic:")));
            ArrayList<String> optional = new ArrayList<String>(ComponentMaker.split(info.get("optional:")));
            ArrayList<String> multiple = new ArrayList<String>(ComponentMaker.split(info.get("multiple:")));
            Collection<String> descriptors = ComponentMaker.split(info.get(".descriptors:"));
            for (Map.Entry<String, String> entry : info.entrySet()) {
                char c;
                String referenceName = entry.getKey();
                if (referenceName.endsWith(":")) {
                    if (SET_COMPONENT_DIRECTIVES.contains(referenceName)) continue;
                    this.error("Unrecognized directive in Service-Component header: " + referenceName, new Object[0]);
                    continue;
                }
                String bind = null;
                String unbind = null;
                boolean unbindCalculated = false;
                if (referenceName.indexOf(47) >= 0) {
                    String[] parts = referenceName.split("/");
                    referenceName = parts[0];
                    bind = parts[1];
                    if (parts.length > 2) {
                        unbind = parts[2];
                    } else {
                        unbindCalculated = true;
                        unbind = bind.startsWith("add") ? bind.replaceAll("add(.+)", "remove$1") : "un" + bind;
                    }
                } else if (Character.isLowerCase(referenceName.charAt(0))) {
                    unbindCalculated = true;
                    bind = "set" + Character.toUpperCase(referenceName.charAt(0)) + referenceName.substring(1);
                    unbind = "un" + bind;
                }
                String interfaceName = entry.getValue();
                if (interfaceName == null || interfaceName.length() == 0) {
                    this.error("Invalid Interface Name for references in Service Component: " + referenceName + "=" + interfaceName, new Object[0]);
                    continue;
                }
                if (descriptors.size() > 0) {
                    if (!descriptors.contains(bind)) {
                        this.error("The bind method %s for %s not defined", bind, referenceName);
                    }
                    if (!descriptors.contains(unbind)) {
                        if (unbindCalculated) {
                            unbind = null;
                        } else {
                            this.error("The unbind method %s for %s not defined", unbind, referenceName);
                        }
                    }
                }
                if ("?+*~".indexOf(c = interfaceName.charAt(interfaceName.length() - 1)) >= 0) {
                    if (c == '?' || c == '*' || c == '~') {
                        optional.add(referenceName);
                    }
                    if (c == '+' || c == '*') {
                        multiple.add(referenceName);
                    }
                    if (c == '+' || c == '*' || c == '?') {
                        dynamic.add(referenceName);
                    }
                    interfaceName = interfaceName.substring(0, interfaceName.length() - 1);
                }
                String target = null;
                Matcher m = REFERENCE.matcher(interfaceName);
                if (m.matches()) {
                    interfaceName = m.group(1);
                    target = m.group(2);
                }
                this.analyzer.referTo(interfaceName);
                pw.printf("  <reference name='%s'", referenceName);
                pw.printf(" interface='%s'", interfaceName);
                String cardinality = optional.contains(referenceName) ? "0" : "1";
                cardinality = String.valueOf(cardinality) + "..";
                cardinality = String.valueOf(cardinality) + (multiple.contains(referenceName) ? "n" : "1");
                if (!cardinality.equals("1..1")) {
                    pw.print(" cardinality='" + cardinality + "'");
                }
                if (bind != null) {
                    pw.printf(" bind='%s'", bind);
                    if (unbind != null) {
                        pw.printf(" unbind='%s'", unbind);
                    }
                }
                if (dynamic.contains(referenceName)) {
                    pw.print(" policy='dynamic'");
                }
                if (target != null) {
                    pw.print(" target='" + ServiceComponent.escape(target) + "'");
                }
                pw.println("/>");
            }
        }
    }
}

