/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl.helper;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.impl.InventoryPrinterHandler;
import org.apache.felix.inventory.impl.helper.ConfigurationWriter;
import org.apache.felix.inventory.impl.helper.SimpleJson;

public class ZipConfigurationWriter
extends ConfigurationWriter {
    private final ConfigZipOutputStream zip;
    private int entryCounter;

    public static ZipConfigurationWriter create(OutputStream out) throws IOException {
        ConfigZipOutputStream zip = new ConfigZipOutputStream(out){};
        zip.setLevel(1);
        zip.setMethod(8);
        return new ZipConfigurationWriter(zip);
    }

    private ZipConfigurationWriter(ConfigZipOutputStream zip) throws IOException {
        super(new OutputStreamWriter((OutputStream)zip, "UTF-8"));
        this.zip = zip;
        this.entryCounter = -1;
    }

    public void finish() throws IOException {
        this.zip.finish();
    }

    @Override
    public void printInventory(Format formatIgnored, InventoryPrinterHandler handler) throws IOException {
        ZipEntry entry;
        String baseName = this.getBaseName(handler);
        this.zip.handler(handler);
        if (handler.supports(Format.TEXT)) {
            entry = new ZipEntry(baseName.concat(".txt"));
            entry.setTime(System.currentTimeMillis());
            this.zip.putNextEntry(entry, Format.TEXT);
            handler.print(this, Format.TEXT, true);
            this.flush();
            this.zip.closeEntry();
        }
        if (handler.supports(Format.JSON)) {
            entry = new ZipEntry("json/" + baseName + ".json");
            entry.setTime(System.currentTimeMillis());
            this.zip.putNextEntry(entry, Format.JSON);
            handler.print(this, Format.JSON, true);
            this.flush();
            this.zip.closeEntry();
        }
        this.zip.attachements();
        handler.addAttachments(this.zip, baseName.concat("/"));
        this.zip.endAttachements();
        this.zip.endHandler();
    }

    private String getBaseName(InventoryPrinterHandler handler) {
        String title = handler.getTitle();
        StringBuffer name = new StringBuffer(title.length());
        for (int i = 0; i < title.length(); ++i) {
            char c = title.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                name.append(c);
                continue;
            }
            name.append('_');
        }
        ++this.entryCounter;
        return MessageFormat.format("{0,number,000}_{1}", this.entryCounter, name);
    }

    private static class ConfigZipOutputStream
    extends ZipOutputStream {
        private final SimpleJson json = new SimpleJson();

        ConfigZipOutputStream(OutputStream out) {
            super(out);
            this.json.object();
            Date now = new Date();
            String nowFormatted = DateFormat.getDateTimeInstance(1, 1, Locale.US).format(now);
            this.json.key("created");
            this.json.object();
            this.json.key("date").value(nowFormatted);
            this.json.key("stamp").value(String.valueOf(now.getTime()));
            this.json.endObject();
            this.json.key("files").object();
        }

        void handler(InventoryPrinterHandler handler) {
            this.json.key(handler.getName());
            this.json.object();
            this.json.key("title").value(handler.getTitle());
        }

        void endHandler() {
            this.json.endObject();
        }

        void attachements() {
            this.json.key("attachements");
            this.json.array();
        }

        void endAttachements() {
            this.json.endArray();
        }

        void putNextEntry(ZipEntry e, Format format) throws IOException {
            this.json.key(format.toString().toLowerCase());
            this.putNextEntry(e);
        }

        @Override
        public void putNextEntry(ZipEntry e) throws IOException {
            this.json.value(e.getName());
            super.putNextEntry(e);
        }

        @Override
        public void finish() throws IOException {
            this.json.endObject().endObject();
            ZipEntry entry = new ZipEntry("index.json");
            entry.setTime(System.currentTimeMillis());
            super.putNextEntry(entry);
            this.write(this.json.toString().getBytes("UTF-8"));
            this.flush();
            this.closeEntry();
            super.finish();
        }
    }
}

