/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.osgi.framework.connect.ConnectContent;

public class ConnectContentFile
implements ConnectContent {
    private static final String POINTER_UPPER_DIRECTORY = "..";
    final File root;
    final Supplier<Optional<Map<String, String>>> headers;

    public ConnectContentFile(File root, Supplier<Optional<Map<String, String>>> headers) {
        this.root = root;
        this.headers = headers;
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    public Optional<ClassLoader> getClassLoader() {
        return Optional.of(this.getClass().getClassLoader());
    }

    public Iterable<String> getEntries() throws IOException {
        Path rootPath = this.root.toPath();
        return Files.find(rootPath, Integer.MAX_VALUE, (p, a) -> true, new FileVisitOption[0]).map(p -> {
            Path relative = rootPath.relativize((Path)p);
            StringBuilder builder = new StringBuilder();
            for (Path path : relative) {
                builder.append(path.getFileName());
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                builder.append('/');
            }
            return builder.toString();
        }).collect(Collectors.toList());
    }

    public Optional<ConnectContent.ConnectEntry> getEntry(String name) {
        return this.getFile(name).map(f -> new FileConnectEntry((File)f, name));
    }

    private Optional<File> getFile(String path) {
        File file = new File(this.root, path);
        if (!file.exists()) {
            return Optional.empty();
        }
        if (path.contains(POINTER_UPPER_DIRECTORY)) {
            try {
                if (!file.getCanonicalPath().startsWith(this.root.getCanonicalPath())) {
                    return Optional.empty();
                }
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.of(file);
    }

    public Optional<Map<String, String>> getHeaders() {
        return this.headers.get();
    }

    public static class FileConnectEntry
    implements ConnectContent.ConnectEntry {
        private final File entry;
        private final String name;

        public FileConnectEntry(File entry, String name) {
            boolean endsInSlash;
            this.entry = entry;
            boolean bl = endsInSlash = name.length() > 0 && name.charAt(name.length() - 1) == '/';
            if (entry.isDirectory()) {
                if (!endsInSlash) {
                    name = name + '/';
                }
            } else if (endsInSlash) {
                name = name.substring(0, name.length() - 1);
            }
            this.name = name;
        }

        public long getContentLength() {
            return this.entry.length();
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.entry);
        }

        public long getLastModified() {
            return this.entry.lastModified();
        }

        public String getName() {
            return this.name;
        }
    }
}

