/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineError;
import org.apache.cxf.tools.common.toolspec.parser.Option;

public class ErrorVisitor {
    public static final long serialVersionUID = 1L;
    private static final Logger LOG = LogUtils.getL7dLogger(ErrorVisitor.class);
    private final Set<CommandLineError> errors = new HashSet<CommandLineError>();

    public Collection<CommandLineError> getErrors() {
        return this.errors;
    }

    public void add(CommandLineError err) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Adding error: " + err);
        }
        this.errors.add(err);
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (CommandLineError o : this.errors) {
            res.append(o.toString()).append(System.getProperty("line.separator"));
        }
        return res.toString();
    }

    public static class UserError
    implements CommandLineError {
        private final String msg;

        public UserError(String m) {
            this.msg = m;
        }

        public String toString() {
            return this.msg;
        }

        public String getMessage() {
            return this.msg;
        }
    }

    public static class MissingArgument
    implements CommandLineError {
        private final String arg;

        public MissingArgument(String a) {
            this.arg = a;
        }

        public String toString() {
            return "Missing argument: " + this.arg;
        }

        public String getArgument() {
            return this.arg;
        }
    }

    public static class InvalidOption
    implements CommandLineError {
        private final String option;

        public InvalidOption(String opt) {
            this.option = opt;
        }

        public String toString() {
            return "Invalid option: " + this.option + " is missing its associated argument";
        }

        public String getOptionSwitch() {
            return this.option;
        }
    }

    public static class UnexpectedArgument
    implements CommandLineError {
        private final String arg;

        public UnexpectedArgument(String a) {
            this.arg = a;
        }

        public String toString() {
            return "Unexpected argument: " + this.arg;
        }

        public String getArgument() {
            return this.arg;
        }
    }

    public static class UnexpectedOption
    implements CommandLineError {
        private final String option;

        public UnexpectedOption(String opt) {
            this.option = opt;
        }

        public String toString() {
            return "Unexpected option: " + this.option;
        }

        public String getOptionSwitch() {
            return this.option;
        }
    }

    public static class DuplicateArgument
    implements CommandLineError {
        private final String argument;

        public DuplicateArgument(String arg) {
            this.argument = arg;
        }

        public String toString() {
            return "Duplicated argument: " + this.argument;
        }

        public String getOptionSwitch() {
            return this.argument;
        }
    }

    public static class DuplicateOption
    implements CommandLineError {
        private final String option;

        public DuplicateOption(String opt) {
            this.option = opt;
        }

        public String toString() {
            return "Duplicated option: " + this.option;
        }

        public String getOptionSwitch() {
            return this.option;
        }
    }

    public static class MissingOption
    implements CommandLineError {
        private final Option o;

        public MissingOption(Option op) {
            this.o = op;
        }

        public String toString() {
            return "Missing option: " + this.o.getPrimarySwitch();
        }

        public Option getOption() {
            return this.o;
        }

        public String getOptionSwitch() {
            return this.o.getPrimarySwitch();
        }
    }
}

