/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.amqpBrokerConnectivity;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;

public final class AMQPBridgeQueuePolicyElement
implements Serializable {
    private static final long serialVersionUID = 226560733949177716L;
    private final Set<QueueMatch> includes = new HashSet<QueueMatch>();
    private final Set<QueueMatch> excludes = new HashSet<QueueMatch>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String name;
    private String remoteAddress;
    private String remoteAddressPrefix;
    private String remoteAddressSuffix;
    private String[] remoteTerminusCapabilities;
    private Integer priority;
    private Integer priorityAdjustment;
    private String filter;
    private TransformerConfiguration transformerConfig;

    public String getName() {
        return this.name;
    }

    public AMQPBridgeQueuePolicyElement setName(String name) {
        this.name = name;
        return this;
    }

    public Set<QueueMatch> getIncludes() {
        return this.includes;
    }

    public AMQPBridgeQueuePolicyElement addToIncludes(String addressMatch, String queueMatch) {
        this.includes.add(new QueueMatch().setAddressMatch(addressMatch).setQueueMatch(queueMatch));
        return this;
    }

    public AMQPBridgeQueuePolicyElement addInclude(QueueMatch match) {
        this.includes.add(match);
        return this;
    }

    public AMQPBridgeQueuePolicyElement setIncludes(Set<QueueMatch> includes) {
        this.includes.clear();
        if (includes != null) {
            this.includes.addAll(includes);
        }
        return this;
    }

    public Set<QueueMatch> getExcludes() {
        return this.excludes;
    }

    public AMQPBridgeQueuePolicyElement addExclude(QueueMatch match) {
        this.excludes.add(match);
        return this;
    }

    public AMQPBridgeQueuePolicyElement addToExcludes(String addressMatch, String queueMatch) {
        this.excludes.add(new QueueMatch().setAddressMatch(addressMatch).setQueueMatch(queueMatch));
        return this;
    }

    public AMQPBridgeQueuePolicyElement setExcludes(Set<QueueMatch> excludes) {
        this.excludes.clear();
        if (excludes != null) {
            this.excludes.addAll(excludes);
        }
        return this;
    }

    public AMQPBridgeQueuePolicyElement addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public AMQPBridgeQueuePolicyElement addProperty(String key, Number value) {
        this.properties.put(key, value);
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public AMQPBridgeQueuePolicyElement setProperties(Map<String, Object> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public AMQPBridgeQueuePolicyElement setTransformerConfiguration(TransformerConfiguration transformerConfig) {
        this.transformerConfig = transformerConfig;
        return this;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfig;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public AMQPBridgeQueuePolicyElement setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public String getRemoteAddressPrefix() {
        return this.remoteAddressPrefix;
    }

    public AMQPBridgeQueuePolicyElement setRemoteAddressPrefix(String remoteAddressPrefix) {
        this.remoteAddressPrefix = remoteAddressPrefix;
        return this;
    }

    public String getRemoteAddressSuffix() {
        return this.remoteAddressSuffix;
    }

    public AMQPBridgeQueuePolicyElement setRemoteAddressSuffix(String remoteAddressSuffix) {
        this.remoteAddressSuffix = remoteAddressSuffix;
        return this;
    }

    public String[] getRemoteTerminusCapabilities() {
        if (this.remoteTerminusCapabilities != null) {
            return Arrays.copyOf(this.remoteTerminusCapabilities, this.remoteTerminusCapabilities.length);
        }
        return null;
    }

    public AMQPBridgeQueuePolicyElement setRemoteTerminusCapabilities(String[] remoteTerminusCapabilities) {
        this.remoteTerminusCapabilities = remoteTerminusCapabilities;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public AMQPBridgeQueuePolicyElement setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Integer getPriorityAdjustment() {
        return this.priorityAdjustment;
    }

    public AMQPBridgeQueuePolicyElement setPriorityAdjustment(Integer priorityAdjustment) {
        this.priorityAdjustment = priorityAdjustment;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public AMQPBridgeQueuePolicyElement setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AMQPBridgeQueuePolicyElement)) {
            return false;
        }
        AMQPBridgeQueuePolicyElement that = (AMQPBridgeQueuePolicyElement)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.includes, that.includes) && Objects.equals(this.excludes, that.excludes) && Objects.equals(this.priority, that.priority) && Objects.equals(this.priorityAdjustment, that.priorityAdjustment) && Objects.equals(this.filter, that.filter) && Objects.equals(this.remoteAddress, that.remoteAddress) && Objects.equals(this.remoteAddressPrefix, that.remoteAddressPrefix) && Arrays.equals(this.remoteTerminusCapabilities, that.remoteTerminusCapabilities);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.includes, this.excludes, this.priority, this.priorityAdjustment, this.filter, this.remoteAddress, this.remoteAddressPrefix) + Arrays.hashCode(this.remoteTerminusCapabilities);
    }

    public static class QueueMatch
    implements Serializable {
        private static final long serialVersionUID = -1641189627591828008L;
        private String name;
        private String addressMatch;
        private String queueMatch;

        public String getName() {
            return this.name;
        }

        public QueueMatch setName(String name) {
            this.name = name;
            return this;
        }

        public String getAddressMatch() {
            return this.addressMatch;
        }

        public QueueMatch setAddressMatch(String addressMatch) {
            this.addressMatch = addressMatch;
            return this;
        }

        public String getQueueMatch() {
            return this.queueMatch;
        }

        public QueueMatch setQueueMatch(String queueMatch) {
            this.queueMatch = queueMatch;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QueueMatch)) {
                return false;
            }
            QueueMatch matcher = (QueueMatch)o;
            return Objects.equals(this.queueMatch, matcher.queueMatch) && Objects.equals(this.addressMatch, matcher.addressMatch);
        }

        public int hashCode() {
            return Objects.hash(this.queueMatch, this.addressMatch);
        }
    }
}

