/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.rp.OidcClaimsValidator;
import org.apache.cxf.rs.security.oidc.utils.OidcUtils;

public class IdTokenReader
extends OidcClaimsValidator {
    private boolean requireAtHash = true;
    private boolean requireCodeHash;

    public IdToken getIdToken(ClientAccessToken at, String code, Consumer client) {
        JwtToken jwt = this.getIdJwtToken(at, code, client);
        return this.getIdTokenFromJwt(jwt);
    }

    public IdToken getIdToken(ClientAccessToken at, Consumer client) {
        return this.getIdToken(at, null, client);
    }

    public IdToken getIdToken(String idJwtToken, Consumer client) {
        JwtToken jwt = this.getIdJwtToken(idJwtToken, client);
        return this.getIdTokenFromJwt(jwt);
    }

    public JwtToken getIdJwtToken(ClientAccessToken at, String code, Consumer client) {
        String idJwtToken = (String)at.getParameters().get("id_token");
        JwtToken jwt = this.getIdJwtToken(idJwtToken, client);
        OidcUtils.validateAccessTokenHash(at, jwt, this.requireAtHash);
        OidcUtils.validateCodeHash(code, jwt, this.requireCodeHash);
        return jwt;
    }

    public JwtToken getIdJwtToken(ClientAccessToken at, Consumer client) {
        return this.getIdJwtToken(at, null, client);
    }

    public JwtToken getIdJwtToken(String idJwtToken, Consumer client) {
        JwtToken jwt = this.getJwtToken(idJwtToken, client.getClientSecret());
        this.validateJwtClaims(jwt.getClaims(), client.getClientId(), true);
        return jwt;
    }

    private IdToken getIdTokenFromJwt(JwtToken jwt) {
        return new IdToken(jwt.getClaims().asMap());
    }

    public void setRequireAccessTokenHash(boolean require) {
        this.requireAtHash = require;
    }

    public void setRequireCodeHash(boolean require) {
        this.requireCodeHash = require;
    }
}

