package org.apache.ctakes.gui.dictionary.cased.umls.abbreviation;

import java.util.Arrays;

/**
 * Relationship Attribute
 * https:// www.nlm.nih.gov/research/umls/knowledge_sources/metathesaurus/release/abbreviations.html
 *
 * @author SPF , chip-nlp
 * @version %I%
 * @since 12/18/2018
 */
public enum Rela {
   abnormal_cell_affected_by_chemical_or_drug,   // abnormal cell affected by chemical or drug
   abnormality_associated_with_allele,   // abnormality associated with allele
   access_device_used_by,   // Access device used by
   access_instrument_of,   // Access instrument of
   access_of,   // Access of
   active_ingredient_of,   // Active ingredient of
   active_metabolites_of,   // Active metabolites of
   active_moiety_of,   // Active Moiety of
   activity_of_allele,   // activity of allele
   actual_outcome_of,   // Actual outcome of
   add_on_code_for,   // Add on code for (Report with)
   adheres_to,   // Adheres to
   adjacent_to,   // Adjacent to
   adjectival_form_of,   // Adjectival form of
   adjustment_of,   // Adjustment of
   afferent_to,   // Afferent to
   alias_of,   // Alias_of
   allele_absent_from_wild_type_chromosomal_location( "allele_absent_from_wild-type_chromosomal_location" ),   // allele absent from wild-type chromosomal location
   allele_has_abnormality,   // allele has abnormality
   allele_has_activity,   // allele has activity
   allele_in_chromosomal_location,   // allele in chromosomal location
   allele_plays_altered_role_in_process,   // allele plays altered role in process
   allele_plays_role_in_metabolism_of_chemical_or_drug,   // allele plays role in metabolism of chemical or drug
   allelic_variant_of,   // Allelic Variant of
   alternative_of,   // Alternative of
   analyzed_by,   // Analyzed by
   analyzes,   // Analyzes
   anatomic_structure_has_location,   // anatomic structure has location
   anatomic_structure_is_physical_part_of,   // anatomic structure is physical part of
   anatomical_entity_observed_in,   // anatomical entity observed in
   anatomy_originated_from_biological_process,   // anatomy originated from biological process
   answer_to,   // answer to
   anterior_to,   // anterior to
   anteroinferior_to,   // anteroinferior to
   anterolateral_to,   // anterolateral to
   anteromedial_to,   // anteromedial to
   anterosuperior_to,   // anterosuperior to
   approach_of_excluded,   // Approach of excluded
   approach_of_possibly_included,   // Approach of possibly included
   approach_of,   // Approach of
   arterial_supply_of,   // Arterial supply of
   articulates_with,   // Articulates with
   associated_condition_of,   // Associated condition of
   associated_disease,   // Associated disease
   associated_etiologic_finding_of,   // Associated etiologic finding of
   associated_finding_of_excluded,   // Associated finding of excluded
   associated_finding_of_possibly_included,   // Associated finding of possibly included
   associated_finding_of,   // Associated finding of
   associated_function_of,   // Associated function of
   associated_genetic_condition,   // Associated genetic condition
   associated_morphology_of,   // Associated morphology of
   associated_procedure_of_excluded,   // Associated procedure of excluded
   associated_procedure_of_possibly_included,   // Associated procedure of possibly included
   associated_procedure_of,   // Associated procedure of
   associated_with_malfunction_of_gene_product,   // associated with malfunction of gene product
   associated_with,   // Associated with
   attaches_to,   // Attaches to
   basic_dose_form_of,   // Basic dose form of
   basis_of_strength_substance_of,   // Basis of strength substance of
   biological_process_has_associated_location,   // biological process has associated location
   biological_process_has_initiator_chemical_or_drug,   // biological process has initiator chemical or drug
   biological_process_has_initiator_process,   // biological process has initiator process
   biological_process_has_result_anatomy,   // biological process has result anatomy
   biological_process_has_result_biological_process,   // biological process has result biological process
   biological_process_has_result_chemical_or_drug,   // biological process has result chemical or drug
   biological_process_involves_chemical_or_drug,   // biological process involves chemical or drug
   biological_process_involves_gene_product,   // biological process involves gene product
   biological_process_is_part_of_process,   // biological process is part of process
   biological_process_results_from_biological_process,   // biological process results from biological process
   biomarker_type_includes_gene_product,   // biomarker type includes gene product
   biomarker_type_includes_gene,   // biomarker type includes gene
   bounded_by,   // Bounded by
   bounds,   // Bounds
   branch_of,   // Branch of
   british_form_of,   // British form of
   causative_agent_of,   // Causative agent of
   cause_of,   // Cause of
   cdrh_parent_of,   // cdrh parent of
   cell_type_is_associated_with_eo_disease,   // cell type is associated with eo disease
   cell_type_or_tissue_affected_by_chemical_or_drug,   // cell type or tissue affected by chemical or drug
   challenge_of,   // Challenge of
   characterized_by,   // Characterized by
   characterizes,   // Characterizes
   chemical_or_drug_affects_abnormal_cell,   // chemical or drug affects abnormal cell
   chemical_or_drug_affects_cell_type_or_tissue,   // chemical or drug affects cell type or tissue
   chemical_or_drug_affects_gene_product,   // chemical or drug affects gene product
   chemical_or_drug_has_mechanism_of_action,   // chemical or drug has mechanism of action
   chemical_or_drug_has_physiologic_effect,   // chemical or drug has physiologic effect
   chemical_or_drug_initiates_biological_process,   // chemical or drug initiates biological process
   chemical_or_drug_is_metabolized_by_enzyme,   // chemical or drug is metabolized by enzyme
   chemical_or_drug_is_product_of_biological_process,   // chemical or drug is product of biological process
   chemical_or_drug_metabolism_is_associated_with_allele,   // chemical or drug metabolism is associated with allele
   chemical_or_drug_plays_role_in_biological_process,   // chemical or drug plays role in biological process
   chemical_structure_of,   // Chemical structure of
   chemotherapy_regimen_has_component,   // chemotherapy regimen has component
   chromosomal_location_of_allele,   // chromosomal location of allele
   chromosomal_location_of_wild_type_gene( "chromosomal_location_of_wild-type_gene" ),   // chromosomal location of wild-type gene
   chromosome_involved_in_cytogenetic_abnormality,   // chromosome involved in cytogenetic abnormality
   chromosome_mapped_to_disease,   // chromosome mapped to disease
   class_code_classified_by,   // Class code classified by
   class_of,   // Class of
   classified_as,   // Classified as
   classifies_class_code,   // Classifies class code
   classifies,   // Classifies
   clinical_course_of,   // Clinical course of
   clinically_associated_with,   // Clinically associated with
   clinically_similar,   // Clinically similar
   clinician_form_of,   // Clinician form of
   co_occurs_with( "co-occurs_with" ),   // Co-ocurrs with
   common_name_of,   // common name of
   completely_excised_anatomy_has_procedure,   // completely excised anatomy has procedure
   completely_excised_anatomy_may_have_procedure,   // Completely excised anatomy may have procedure
   complex_has_physical_part,   // complex has physical part
   component_of_excluded,   // Component of excluded
   component_of_possibly_included,   // Component of possibly included
   component_of,   // Component of
   concentration_strength_denominator_unit_of,   // Concentration strength denominator unit of
   concentration_strength_denominator_value_of,   // Concentration strength denominator value of
   concentration_strength_numerator_unit_of,   // Concentration strength numerator unit of
   concentration_strength_numerator_value_of,   // Concentration strength numerator value of
   concept_in_subset,   // concept in subset
   conceptual_part_of,   // Conceptual part of
   connected_to,   // connected to
   connection_type_of,   // connection type of
   consider_from,   // Consider from
   consider,   // Consider
   consists_of,   // Consists of
   constitutes,   // Constitutes
   constitutional_part_of,   // Constitutional part of
   consumer_friendly_form_of,   // Consumer friendly form of
   contained_in,   // Contained in
   contains,   // Contains
   context_binding_of,   // Context binding of
   continuation_branch_of,   // Continuation branch of
   continuous_distally_with,   // continuous distally with
   continuous_proximally_with,   // continuous proximally with
   continuous_with,   // Continuous with
   contraindicated_class_of,   // Contraindicated class of
   contraindicated_mechanism_of_action_of,   // Contraindicated mechanism of action of
   contraindicated_physiologic_effect_of,   // Contraindicated physiologic effect of
   contraindicated_with_disease,   // Contraindicated with disease
   contraindicating_class_of,   // Contraindicating class of
   contraindicating_mechanism_of_action_of,   // Contraindicating mechanism of action of
   contraindicating_physiologic_effect_of,   // Contraindicating physiologic effect of
   corresponds_to,   // corresponds to
   count_of_base_of_active_ingredient_of,   // Count of base of active ingredient of
   count_of,   // count_of
   course_of,   // Course of
   ctcae_5_parent_of,   // ctcae_5 parent of
   cytogenetic_abnormality_involves_chromosome,   // cytogenetic abnormality involves chromosome
   data_element_of,   // data element of
   ddx,   // dxx
   default_mapped_from,   // Default mapped from
   default_mapped_to,   // Default mapped to
   defining_characteristic_of,   // Defining characteristic of
   definitional_manifestation_of,   // Definitional manifestation of
   degree_of,   // Degree of
   dependent_of,   // Dependent of
   derives_from,   // derives from
   derives,   // derives
   development_type_of,   // development type of
   developmental_stage_of,   // developmental stage of
   develops_from,   // Develops from
   develops_into,   // develops into
   device_used_by,   // Device used by
   diagnosed_by,   // Diagnosed by
   diagnoses,   // Diagnoses
   diagnostic_criteria_of,   // DSM-5 diagnostic criteria for ICD code
   direct_cell_shape_of,   // direct cell shape of
   direct_device_of,   // Direct device of
   direct_left_of,   // direct left of
   direct_morphology_of,   // Direct morphology of
   direct_procedure_site_of,   // Direct procedure site of
   direct_right_of,   // direct right of
   direct_site_of,   // Direct site of
   direct_substance_of,   // Direct substance of
   disease_excludes_abnormal_cell,   // disease excludes abnormal cell
   disease_excludes_cytogenetic_abnormality,   // disease excludes cytogenetic abnormality
   disease_excludes_finding,   // disease excludes finding
   disease_excludes_molecular_abnormality,   // disease excludes molecular abnormality
   disease_excludes_normal_cell_origin,   // disease excludes normal cell origin
   disease_excludes_normal_tissue_origin,   // disease excludes normal tissue origin
   disease_excludes_primary_anatomic_site,   // disease excludes primary anatomic site
   disease_has_abnormal_cell,   // disease has abnormal cell
   disease_has_accepted_treatment_with_regimen,   // Disease Has Accepted Treatment With Regimen
   disease_has_associated_anatomic_site,   // disease has associated anatomic site
   disease_has_associated_disease,   // disease has associated disease
   disease_has_associated_gene,   // disease has associated gene
   disease_has_cytogenetic_abnormality,   // disease has cytogenetic abnormality
   disease_has_finding,   // disease has finding
   disease_has_metastatic_anatomic_site,   // disease has metastatic anatomic site
   disease_has_molecular_abnormality,   // disease has molecular abnormality
   disease_has_normal_cell_origin,   // disease has normal cell origin
   disease_has_normal_tissue_origin,   // disease has normal tissue origin
   disease_has_primary_anatomic_site,   // disease has primary anatomic site
   disease_is_grade,   // disease is grade
   disease_is_marked_by_gene,   // disease is marked by gene
   disease_is_stage,   // disease is stage
   disease_mapped_to_chromosome,   // disease mapped to chromosome
   disease_mapped_to_gene,   // Disease mapped to gene
   disease_may_have_abnormal_cell,   // disease may have abnormal cell
   disease_may_have_associated_disease,   // disease may have associated disease
   disease_may_have_cytogenetic_abnormality,   // disease may have cytogenetic abnormality
   disease_may_have_finding,   // disease may have finding
   disease_may_have_molecular_abnormality,   // disease may have molecular abnormality
   disease_may_have_normal_cell_origin,   // disease may have normal cell origin
   disposition_of,   // Disposition of
   distal_to,   // distal to
   divisor_of,   // Divisor of
   do_not_code_with,   // Do not code with (excludes)
   dose_form_administration_method_of,   // Dose form administration method of
   dose_form_intended_site_of,   // Dose form intended site of
   dose_form_of,   // Dose form of
   dose_form_release_characteristic_of,   // Dose form release characteristic of
   dose_form_transformation_of,   // Dose form transformation of
   doseformgroup_of,   // Dose form group of
   drains_into,   // drains into
   due_to,   // Due to
   during,   // During
   effect_may_be_inhibited_by,   // Effect may be inhibited by
   efferent_to,   // Efferent to
   endogenous_product_related_to,   // Endogenous Product Related To
   ends_during,   // Ends during
   energy_used_by,   // Energy used by
   entire_anatomy_structure_of,   // Entire anatomy structure of
   entry_combination_of,   // Entry Combination of
   entry_version_of,   // Entry version of
   enzyme_metabolizes_chemical_or_drug,   // enzyme metabolizes chemical or drug
   eo_anatomy_is_associated_with_eo_disease,   // eo anatomy is associated with eo disease
   eo_disease_has_associated_cell_type,   // eo disease has associated cell type
   eo_disease_has_associated_eo_anatomy,   // eo disease has associated eo anatomy
   eo_disease_has_property_or_attribute,   // eo disease has property or attribute
   eo_disease_maps_to_human_disease,   // eo disease maps to human disease
   episodicity_of,   // Episodicity of
   evaluation_of,   // Evaluation of
   excised_anatomy_has_procedure,   // excised anatomy has procedure
   excised_anatomy_may_have_procedure,   // excised anatomy may have procedure
   exhibited_by,   // Exhibited by
   exhibits,   // Exhibits
   expanded_form_of,   // Expanded form of
   expected_outcome_of,   // Expected outcome of
   extent_of,   // Extent of
   external_to,   // external to
   finding_context_of,   // Finding context of
   finding_informer_of,   // Finding informer of
   finding_method_of,   // Finding method of
   finding_site_of,   // Finding site of
   focus_of,   // Focus of
   form_of,   // Form of
   formed_by,   // formed by
   forms,   // forms
   fragments_for_synonyms_of,   // Fragments for synonyms of
   full_grown_phenotype_of,   // full grown phenotype of
   fuses_with,   // fuses with
   fusion_of,   // fusion of
   gene_associated_with_disease,   // gene associated with disease
   gene_encodes_gene_product,   // gene encodes gene product
   gene_found_in_organism,   // gene found in organism
   gene_has_abnormality,   // gene has abnormality
   gene_has_physical_location,   // gene has physical location
   gene_in_chromosomal_location,   // gene in chromosomal location
   gene_involved_in_molecular_abnormality,   // gene involved in molecular abnormality
   gene_involved_in_pathogenesis_of_disease,   // gene involved in pathogenesis of disease
   gene_is_biomarker_of,   // gene is biomarker of
   gene_is_biomarker_type,   // gene is biomarker type
   gene_is_element_in_pathway,   // gene is element in pathway
   gene_mapped_to_disease,   // gene mapped to disease
   gene_mutant_encodes_gene_product_sequence_variation,   // gene mutant encodes gene product sequence variation
   gene_plays_role_in_process,   // gene plays role in process
   gene_product_affected_by_chemical_or_drug,   // gene product affected by chemical or drug
   gene_product_encoded_by_gene,   // gene product encoded by gene
   gene_product_expressed_in_tissue,   // gene product expressed in tissue
   gene_product_has_abnormality,   // gene product has abnormality
   gene_product_has_associated_anatomy,   // gene product has associated anatomy
   gene_product_has_biochemical_function,   // gene product has biochemical function
   gene_product_has_chemical_classification,   // gene product has chemical classification
   gene_product_has_gene_product_variant,   // gene product has gene product variant
   gene_product_has_organism_source,   // gene product has organism source
   gene_product_has_structural_domain_or_motif,   // gene product has structural domain or motif
   gene_product_is_biomarker_of,   // gene product is biomarker of
   gene_product_is_biomarker_type,   // gene product is biomarker type
   gene_product_is_element_in_pathway,   // gene product is element in pathway
   gene_product_is_physical_part_of,   // gene product is physical part of
   gene_product_malfunction_associated_with_disease,   // gene product malfunction associated with disease
   gene_product_plays_role_in_biological_process,   // gene product plays role in biological process
   gene_product_sequence_variation_encoded_by_gene_mutant,   // gene product sequence variation encoded by gene mutant
   gene_product_variant_of_gene_product,   // gene product variant of gene product
   genetic_biomarker_related_to,   // genetic biomarker related to
   germ_origin_of,   // Germ origin of
   grade_of,   // grade of
   happens_during,   // Happens during
   has_access_instrument,   // Has access instrument
   has_access,   // Has access
   has_action_guidance,   // Has action guidance
   has_active_ingredient,   // Has active ingredient
   has_active_metabolites,   // Has active metabolites
   has_active_moiety,   // Has Active Moiety
   has_actual_outcome,   // Has actual outcome
   has_add_on_code,   // Has add on code (Report with)
   has_adherent,   // Has adherent
   has_adjustment,   // Has adjustment
   has_aggregation_view,   // Has aggregation view
   has_alias,   // Has alias
   has_allelic_variant,   // Has allelic variant
   has_alternative,   // Has alternative
   has_answer,   // has answer
   has_approach_guidance,   // Has approach guidance
   has_approach,   // Has approach
   has_arterial_supply,   // Has arterial supply
   has_associated_condition,   // has_associated_condition
   has_associated_etiologic_finding,   // Has associated etiologic finding
   has_associated_finding,   // Has associated finding
   has_associated_function,   // Has associated function
   has_associated_morphology,   // Has associated morphology
   has_associated_procedure,   // Has associated procedure
   has_at_risk_population,   // Has at risk population
   has_basic_dose_form,   // Has basic dose form
   has_basis_of_strength_substance,   // Has basis of strength substance
   has_branch,   // Has branch
   has_british_form,   // Has British form
   has_causative_agent,   // Has causative agent
   has_cdrh_parent,   // has cdrh parent
   has_challenge,   // Has challenge
   has_chemical_structure,   // Has chemical structure
   has_class,   // Has class
   has_clinical_course,   // Has clinical course
   has_clinician_form,   // Has clinician form
   has_common_name,   // Has common name
   has_communication_with_wound,   // Has communication with wound
   has_component,   // Has component
   has_concentration_strength_denominator_unit,   // Has concentration strength denominator unit
   has_concentration_strength_denominator_value,   // Has concentration strength denominator value
   has_concentration_strength_numerator_unit,   // Has concentration strength numerator unit
   has_concentration_strength_numerator_value,   // Has concentration strength numerator value
   has_conceptual_part,   // Has conceptual part
   has_connection_type,   // has connection type
   has_constitutional_part,   // Has constitutional part
   has_consumer_friendly_form,   // Has consumer friendly form
   has_context_binding,   // Has context binding
   has_continuation_branch,   // Has continuation branch
   has_contraindicated_class,   // Has contraindicated class
   has_contraindicated_drug,   // Has contraindicated drug
   has_contraindicated_mechanism_of_action,   // Has contraindicated mechanism of action
   has_contraindicated_physiologic_effect,   // Has contraindicated physiologic effect
   has_contraindicating_class,   // Has contraindicating class
   has_contraindicating_mechanism_of_action,   // Has contraindicating mechanism of action
   has_contraindicating_physiologic_effect,   // Has contraindicating physiologic effect
   has_count_of_base_of_active_ingredient,   // Has count of base of active ingredient
   has_count,   // Has count
   has_course,   // Has course
   has_ctcae_5_parent,   // has ctcae_5 parent
   has_data_element,   // has data element
   has_defining_characteristic,   // Has defining characteristic
   has_definitional_manifestation,   // Has definitional manifestation
   has_degree,   // Has degree
   has_dependent,   // Has dependent
   has_development_type,   // has development type
   has_developmental_stage,   // has developmental stage
   has_diagnostic_criteria,   // ICD has DSM-5 diagnostic criteria
   has_direct_cell_shape,   // has direct cell shape
   has_direct_device,   // Has direct device
   has_direct_morphology,   // Has direct morphology
   has_direct_procedure_site,   // Has direct procedure site
   has_direct_site,   // Has direct site
   has_direct_substance,   // Has direct substance
   has_disposition,   // Has disposition
   has_divisor,   // Has divisor
   has_dose_form_administration_method,   // Has dose form administration method
   has_dose_form_intended_site,   // Has dose form intended site
   has_dose_form_release_characteristic,   // Has dose form release characteristic
   has_dose_form_transformation,   // Has dose form transformation
   has_dose_form,   // Has dose form
   has_doseformgroup,   // Has dose form group
   has_entire_anatomy_structure,   // Has entire anatomy structure
   has_entry_combination,   // Has Entry Combination
   has_entry_version,   // Has entry version
   has_episodicity,   // Has episodicity
   has_evaluation,   // Has evaluation
   has_exam,   // Has exam
   has_excluded_approach,   // Has excluded approach
   has_excluded_associated_finding,   // Has excluded associated finding
   has_excluded_associated_procedure,   // Has excluded associated procedure
   has_excluded_component,   // Has excluded component
   has_excluded_locale,   // Has excluded locale
   has_excluded_method,   // Has excluded method
   has_excluded_pathology,   // Has excluded pathology
   has_excluded_patient_type,   // Has excluded patient type
   has_excluded_procedure_device,   // Has excluded procedure device
   has_excluded_procedure_site,   // Has excluded procedure site
   has_excluded_route_of_administration,   // Has excluded route of administration
   has_excluded_specimen,   // Has excluded specimen
   has_excluded_surgical_extent,   // Has excluded surgical extent
   has_expanded_form,   // Has expanded form
   has_expected_outcome,   // Has expected outcome
   has_extent,   // Has extent
   has_finding_context,   // Has finding context
   has_finding_informer,   // Has finding informer
   has_finding_method,   // Has finding method
   has_finding_site,   // Has finding_site
   has_focus,   // Has focus
   has_form,   // Has form
   has_fragments_for_synonyms,   // Has fragments for synonyms
   has_free_acid_or_base_form,   // has free acid or base form
   has_full_grown_phenotype,   // has full grown phenotype
   has_fusion,   // has fusion
   has_gene_product_element,   // has gene product element
   has_germ_origin,   // Has germ origin
   has_given_pharmaceutical_substance,   // Has given pharmaceutical substance
   has_grade,   // has grade
   has_imaged_location,   // Has imaged location
   has_imaging_focus,   // Has imaging focus
   has_inactive_ingredient,   // Has Inactive Ingredient
   has_indirect_device,   // Has indirect device
   has_indirect_morphology,   // Has indirect morphology
   has_indirect_procedure_site,   // Has indirect procedure site
   has_ingredients,   // Has ingredients
   has_ingredient,   // Has ingredient
   has_inherent_3d_shape,   // Has inherent 3-D shape
   has_inherent_attribute,   // Has inherent attribute
   has_inherent_location,   // Has inherent location
   has_inheritance_type,   // Has inheritance type
   has_insertion,   // has insertion
   has_instrumentation,   // Has instrumentation
   has_intent,   // Has intent
   has_interpretation,   // Has interpretation
   has_lab_number,   // Has lab number
   has_lateral_anatomic_location,   // Has lateral anatomic location
   has_lateral_location_presence,   // Has lateral location presence
   has_laterality,   // Has laterality
   has_life_circumstance,   // Has life circumstance
   has_locale,   // Has locale
   has_location,   // Has location
   has_lymphatic_drainage,   // Has lymphatic drainage
   has_maneuver_type,   // has maneuver type
   has_manifestation,   // Has manifestation
   has_mapping_qualifier,   // Has mapping qualifier
   has_measured_component,   // has_measured_component
   has_measurement_method,   // Has measurement method
   has_mechanism_of_action,   // Has mechanism of action
   has_member,   // Has member
   has_method,   // Has method
   has_modality_subtype,   // Has modality subtype
   has_modality_type,   // has modality type
   has_modification,   // Has modification
   has_multi_level_category,   // Has multi-level category
   has_multipart,   // Has multipart
   has_nerve_supply,   // Has nerve supply
   has_nichd_parent,   // has nichd parent
   has_object_guidance,   // Has object guidance
   has_observed_anatomical_entity,   // has observed anatomical entity
   has_occurrence,   // Has occurrence
   has_onset,   // Has onset
   has_origin,   // Has origin
   has_owning_affiliate,   // Has owning affiliate
   has_owning_section,   // Has owning section
   has_owning_subsection,   // Has owning subsection
   has_panel_element,   // CPT laboratory panel code has laboratory panel test member
   has_parent,   // Has parent
   has_part_anatomy_structure,   // Has part anatomy structure
   has_part,   // Has part
   has_pathological_process,   // Has pathological process
   has_pathology,   // Has pathology
   has_patient_type,   // Has patient type
   has_permuted_term,   // Has permuted term
   has_pharmaceutical_route,   // Has_pharmaceutical_route
   has_pharmacokinetics,   // Has pharmacokinetics
   has_phenotype,   // Has phenotype
   has_physical_part_of_anatomic_structure,   // has physical part of anatomic structure
   has_physiologic_effect,   // Has physiologic effect
   has_physiologic_state,   // Has physiologic state
   has_plain_text_form,   // Has plain text form
   has_possibly_included_approach,   // Has possibly included approach
   has_possibly_included_associated_finding,   // Has possibly included associated finding
   has_possibly_included_associated_procedure,   // Has possibly included associated procedure
   has_possibly_included_component,   // Has possibly included component
   has_possibly_included_method,   // Has possibly included method
   has_possibly_included_panel_element,   // CPT laboratory panel code has possibly included laboratory panel test member
   has_possibly_included_pathology,   // Has possibly included pathology
   has_possibly_included_patient_type,   // Has possibly included patient type
   has_possibly_included_procedure_device,   // Has possibly included procedure device
   has_possibly_included_procedure_site,   // Has possibly included procedure site
   has_possibly_included_route_of_administration,   // Has possibly included route of administration
   has_possibly_included_surgical_extent,   // Has possibly included surgical extent
   has_precise_active_ingredient,   // Has precise active ingredient
   has_precise_ingredient,   // Has precise ingredient
   has_precondition,   // Has precondition
   has_presence_guidance,   // Has presence guidance
   has_presentation_strength_denominator_unit,   // Has presentation strength denominator unit
   has_presentation_strength_denominator_value,   // Has presentation strength denominator value
   has_presentation_strength_numerator_unit,   // Has presentation strength numerator unit
   has_presentation_strength_numerator_value,   // Has presentation strength numerator value
   has_primary_segmental_supply,   // Has primary segmental supply
   has_print_name,   // Has print name
   has_priority,   // Has priority
   has_procedure_context,   // Has procedure context
   has_procedure_device,   // Has procedure device
   has_procedure_morphology,   // Has procedure morphology
   has_procedure_site,   // Has procedure site
   has_process_output,   // Has process output
   has_product_component,   // Has product component
   has_product_monograph_title,   // has product monograph title
   has_projection,   // has projection
   has_property_type,   // Has property type
   has_property,   // Has property
   has_quantified_form,   // Has quantified form
   has_quotient,   // Has quotient
   has_recipient_category,   // Has recipient category
   has_regional_part,   // Has regional part
   has_related_developmental_entity,   // has related developmental entity
   has_related_factor,   // Has related factor
   has_result,   // Has result
   has_revision_status,   // Has revision status
   has_risk_factor,   // Has risk factor
   has_route_of_administration,   // Has route of administration
   has_salt_form,   // has salt form
   has_scale_type,   // Has scale type
   has_scale,   // Has scale
   has_secondary_segmental_supply,   // Has secondary segmental supply
   has_segmental_composition,   // Has segmental composition
   has_segmental_supply,   // Has segmental supply
   has_severity,   // Has severity
   has_sign_or_symptom,   // Has sign or symptom
   has_single_level_category,   // Has single level category
   has_sort_version,   // Has sort version
   has_specialty,   // Has specialty
   has_specimen_procedure,   // Has specimen procedure
   has_specimen_source_identity,   // Has specimen source identity
   has_specimen_source_morphology,   // Has specimen source morphology
   has_specimen_source_topography,   // Has specimen source topography
   has_specimen_substance,   // Has specimen substance
   has_specimen,   // Has specimen
   has_stage,   // Has stage
   has_state_of_matter,   // Has state of matter
   has_structural_class,   // Has structural class
   has_subject_of_information,   // Has subject of information
   has_subject_relationship_context,   // Has subject relationship context
   has_subject,   // Has subject
   has_suffix,   // Has suffix
   has_supersystem,   // Has supersystem
   has_supported_concept_property,   // Has supported concept property
   has_supported_concept_relationship,   // Has supported concept relationship
   has_surgical_approach,   // has surgical approach
   has_surgical_extent,   // Has surgical extent
   has_system,   // Has system
   has_target,   // has target
   has_technique,   // Has technique
   has_temporal_context,   // Has temporal context
   has_therapeutic_class,   // Has therapeutic class
   has_time_aspect,   // Has time aspect
   has_time_modifier,   // Has time modifier
   has_timing_of,   // Has timing of
   has_tradename,   // Has tradename
   has_translation,   // Has translation
   has_transliterated_form,   // Has transliterated form
   has_tributary,   // Has tributary
   has_unit_of_presentation,   // Has unit of presentation
   has_venous_drainage,   // Has venous drainage
   has_version,   // Has version
   has_view_type,   // Has view type
   homonym_for,   // Homonym for
   homonym_of,   // Homonym of
   human_disease_maps_to_eo_disease,   // human disease maps to eo disease
   icd_asterisk,   // ICD asterisk
   icd_dagger,   // ICD dagger
   imaged_anatomy_has_procedure,   // imaged anatomy has procedure
   inactive_ingredient_of,   // Inactive Ingredient Of
   included_in,   // included_in
   includes_sub_specimen,   // Includes sub specimen
   includes,   // includes
   indirect_device_of,   // Indirect device of
   indirect_morphology_of,   // Indirect morphology of
   indirect_procedure_site_of,   // Indirect procedure site of
   induced_by,   // Induced by
   induces,   // Induces
   inferior_to,   // inferior to
   inferolateral_to,   // inferolateral to
   inferomedial_to,   // inferomedial to
   ingredient_of,   // Ingredient of
   ingredients_of,   // Ingredients of
   inherent_3d_shape_of,   // Inherent 3-D shape of
   inherent_location_of,   // Inherent location of
   inheres_in,   // Inheres in
   inheritance_type_of,   // Inheritance type of
   insertion_of,   // insertion of
   instrumentation_of,   // Instrumentation of
   intent_of,   // Intent of
   internal_to,   // internal to
   interpretation_of,   // Interpretation of
   interprets,   // Interprets
   inverse_during,   // Inverse during
   inverse_ends_during,   // Inverse ends during
   inverse_happens_during,   // Inverse happens during
   inverse_isa,   // Inverse is a
   inverse_was_a,   // Inverse was a
   is_abnormal_cell_of_disease,   // is abnormal cell of disease
   is_abnormality_of_gene_product,   // is abnormality of gene product
   is_abnormality_of_gene,   // is abnormality of gene
   is_action_guidance_for,   // Is action guidance for
   is_aggregation_view_of,   // Is aggregation view of
   is_approach_guidance_for,   // Is approach guidance for
   is_associated_anatomic_site_of,   // is associated anatomic site of
   is_associated_anatomy_of_gene_product,   // is associated anatomy of gene product
   is_associated_disease_of,   // is associated disease of
   is_biochemical_function_of_gene_product,   // is biochemical function of gene product
   is_chemical_classification_of_gene_product,   // is chemical classification of gene product
   is_chromosomal_location_of_gene,   // is chromosomal location of gene
   is_component_of_chemotherapy_regimen,   // is component of chemotherapy regimen
   is_cytogenetic_abnormality_of_disease,   // is cytogenetic abnormality of disease
   is_exam_for,   // Is exam for
   is_finding_of_disease,   // is finding of disease
   is_given_pharmaceutical_substance_for,   // Is given pharmaceutical substance for
   is_grade_of_disease,   // is grade of disease
   is_imaged_location_for,   // Is imaged location for
   is_imaging_focus_of,   // Is imaging focus of
   is_interpreted_by,   // Is interpreted by
   is_lateral_anatomic_location_of,   // Is lateral anatomic location of
   is_location_of_anatomic_structure,   // is location of anatomic structure
   is_location_of_biological_process,   // is location of biological process
   is_maneuver_type_for,   // Is maneuver type for
   is_marked_by_gene_product,   // is marked by gene product
   is_mechanism_of_action_of_chemical_or_drug,   // is mechanism of action of chemical or drug
   is_metastatic_anatomic_site_of_disease,   // is metastatic anatomic site of disease
   is_modality_subtype_for,   // Is modality subtype for
   is_modality_type_for,   // Is modality type for
   is_modification_of,   // Is modification of
   is_molecular_abnormality_of_disease,   // is molecular abnormality of disease
   is_normal_cell_origin_of_disease,   // is normal cell origin of disease
   is_normal_tissue_origin_of_disease,   // is normal tissue origin of disease
   is_not_abnormal_cell_of_disease,   // is not abnormal cell of disease
   is_not_cytogenetic_abnormality_of_disease,   // is not cytogenetic abnormality of disease
   is_not_finding_of_disease,   // is not finding of disease
   is_not_molecular_abnormality_of_disease,   // is not molecular abnormality of disease
   is_not_normal_cell_origin_of_disease,   // is not normal cell origin of disease
   is_not_normal_tissue_origin_of_disease,   // is not normal tissue origin of disease
   is_not_primary_anatomic_site_of_disease,   // is not primary anatomic site of disease
   is_object_guidance_for,   // Is object guidance for
   is_organism_source_of_gene_product,   // is organism source of gene product
   is_pharmaceutical_route_for,   // Is pharmaceutical route for
   is_physical_location_of_gene,   // is physical location of gene
   is_physiologic_effect_of_chemical_or_drug,   // is physiologic effect of chemical or drug
   is_presence_guidance_for,   // Is presence guidance for
   is_presence_of_lateral_location,   // Is presence of lateral location
   is_primary_anatomic_site_of_disease,   // is primary anatomic site of disease
   is_property_or_attribute_of_eo_disease,   // is property or attribute of eo disease
   is_qualified_by,   // is qualified by
   is_related_to_endogenous_product,   // Is Related To Endogenous Product
   is_stage_of_disease,   // is stage of disease
   is_structural_domain_or_motif_of_gene_product,   // is structural domain or motif of gene product
   is_subject_of,   // Is subject of
   is_target,   // is target
   is_timing_for,   // Is timing for
   is_view_type_for,   // Is view type for
   isa,   // Is a
   kind_is_domain_of,   // kind is domain of
   kind_is_range_of,   // kind is range of
   lab_number_of,   // Lab number
   larger_than,   // Larger Than
   lateral_to,   // lateral to
   laterality_of,   // Laterality of
   left_lateral_to,   // left lateral to
   left_medial_to,   // left medial to
   life_circumstance_of,   // Life circumstance of
   locale_of_excluded,   // Locale of excluded
   locale_of,   // Locale of
   location_of,   // Location of
   lymphatic_drainage_of,   // Lymphatic drainage of
   manifestation_of,   // Manifestation of
   manufactured_by,   // manufactured by
   manufactures,   // manufactures
   mapped_from,   // Mapped from
   mapped_to,   // Mapped to
   mapping_qualifier_of,   // Mapping qualifier of
   matures_from,   // matures from
   matures_into,   // matures into
   may_be_abnormal_cell_of_disease,   // may be abnormal cell of disease
   may_be_associated_disease_of_disease,   // may be associated disease of disease
   may_be_cytogenetic_abnormality_of_disease,   // may be cytogenetic abnormality of disease
   may_be_diagnosed_by,   // May be diagnosed by
   may_be_finding_of_disease,   // may be finding of disease
   may_be_molecular_abnormality_of_disease,   // may be molecular abnormality of disease
   may_be_normal_cell_origin_of_disease,   // may be normal cell origin of disease
   may_be_prevented_by,   // May be prevented by
   may_be_qualified_by,   // May be qualified by
   may_be_treated_by,   // May be treated by
   may_diagnose,   // May diagnose
   may_inhibit_effect_of,   // May inhibit effect of
   may_prevent,   // May prevent
   may_qualify,   // May qualify
   may_treat,   // May treat
   measured_by,   // Measured by
   measured_component_of,   // measured_component_of
   measurement_method_of,   // Measurement method of
   measures,   // Measures
   mechanism_of_action_of,   // Mechanism of action of
   medial_to,   // medial to
   member_of,   // Member of
   merges_with,   // merges with
   metabolic_site_of,   // Metabolic site of
   method_of_excluded,   // Method of excluded
   method_of_possibly_included,   // Method of possibly included
   method_of,   // Method of
   modified_by,   // Modified by
   modifies,   // Modifies
   molecular_abnormality_involves_gene,   // molecular abnormality involves gene
   moved_from,   // Moved from
   moved_to,   // Moved to
   mth_british_form_of,   // MTH British form of
   mth_expanded_form_of,   // MTH expanded form of
   mth_has_british_form,   // MTH has British form
   mth_has_expanded_form,   // MTH has expanded form
   mth_has_plain_text_form,   // Has plain text form, Metathesaurus-asserted
   mth_has_xml_form,   // Has XML form, Metathesaurus-asserted
   mth_plain_text_form_of,   // Plain text form of, Metathesaurus-asserted
   mth_xml_form_of,   // XML form of, Metathesaurus-asserted
   multipart_of,   // Multipart of
   multiply_mapped_from,   // Multiply mapped from
   multiply_mapped_to,   // Multiply mapped to
   negatively_regulated_by,   // Negatively regulated by
   negatively_regulates,   // Negatively regulates
   neoplasm_has_special_category,   // neoplasm has special category
   nerve_supply_of,   // Nerve supply of
   nichd_parent_of,   // nichd parent of
   noun_form_of,   // Noun form of
   occurs_after,   // Occurs after
   occurs_before,   // Occurs before
   occurs_in,   // Occurs in
   onset_of,   // Onset of
   organism_has_gene,   // organism has gene
   origin_of,   // Origin of
   other_mapped_from,   // Other mapped from
   other_mapped_to,   // Other mapped to
   owning_affiliate_of,   // Owning affiliate of
   owning_section_of,   // Owning section of
   owning_subsection_of,   // Owning subsection of
   panel_element_of_possibly_included,   // CPT laboratory panel test member is possibly included element of laboratory code
   panel_element_of,   // CPT laboratory panel test member is element of laboratory code
   parent_of,   // Parent of
   part_anatomy_structure_of,   // Part anatomy structure of
   part_of,   // Part of
   part_referred_to_by,   // Part referred to by
   partially_excised_anatomy_has_procedure,   // partially excised anatomy has procedure
   partially_excised_anatomy_may_have_procedure,   // partially excised anatomy may have procedure
   pathogenesis_of_disease_involves_gene,   // pathogenesis of disease involves gene
   pathological_process_of,   // Pathological process of
   pathology_of_excluded,   // Pathology of excluded
   pathology_of_possibly_included,   // Pathology of possibly included
   pathology_of,   // Pathology of
   pathway_has_gene_element,   // pathway has gene element
   patient_type_of_excluded,   // Patient type of excluded
   patient_type_of_possibly_included,   // Patient type of possibly included
   patient_type_of,   // Patient type of
   permuted_term_of,   // Permuted term of
   pharmacokinetics_of,   // Pharmacokinetics of
   phenotype_of,   // Phenotype of
   physiologic_effect_of,   // Physiologic effect of
   physiologic_state_of,   // Physiologic state of
   plain_text_form_of,   // Plain text form of
   population_at_risk_for,   // Population at risk for
   positively_regulated_by,   // Positively regulated by
   positively_regulates,   // Positively regulates
   possibly_equivalent_to,   // Possibly equivalent to
   posterior_to,   // posterior to
   posteroinferior_to,   // posteroinferior to
   posterolateral_to,   // posterolateral to
   posteromedial_to,   // posteromedial to
   posterosuperior_to,   // posterosuperior to
   precise_active_ingredient_of,   // Precise active ingredient of
   precise_ingredient_of,   // Precise ingredient of
   precondition_of,   // Precondition of
   presentation_strength_denominator_unit_of,   // Presentation strength denominator unit of
   presentation_strength_denominator_value_of,   // Presentation strength denominator value of
   presentation_strength_numerator_unit_of,   // Presentation strength numerator unit of
   presentation_strength_numerator_value_of,   // Presentation strength numerator value of
   primary_mapped_from,   // Primary mapped from
   primary_mapped_to,   // Primary mapped to
   primary_segmental_supply_of,   // Primary segmental supply of
   print_name_of,   // Print name of
   priority_of,   // Priority of
   procedure_context_of,   // Procedure context of
   procedure_device_of_excluded,   // Procedure device of excluded
   procedure_device_of_possibly_included,   // Procedure device of possibly included
   procedure_device_of,   // Procedure device of
   procedure_has_completely_excised_anatomy,   // procedure has completely excised anatomy
   procedure_has_excised_anatomy,   // procedure has excised anatomy
   procedure_has_imaged_anatomy,   // procedure has imaged anatomy
   procedure_has_partially_excised_anatomy,   // procedure has partially excised anatomy
   procedure_has_target_anatomy,   // procedure has target anatomy
   procedure_may_have_completely_excised_anatomy,   // procedure may have completely excised anatomy
   procedure_may_have_excised_anatomy,   // procedure may have excised anatomy
   procedure_may_have_partially_excised_anatomy,   // procedure may have partially excised anatomy
   procedure_morphology_of,   // Procedure morphology of
   procedure_site_of_excluded,   // Procedure site of excluded
   procedure_site_of_possibly_included,   // Procedure site of possibly included
   procedure_site_of,   // Procedure site of
   process_altered_by_allele,   // process altered by allele
   process_includes_biological_process,   // process includes biological process
   process_initiates_biological_process,   // process initiates biological process
   process_involves_gene,   // process involves gene
   process_output_of,   // Process output of
   product_component_of,   // Product component of
   product_monograph_title_of,   // product monograph title of
   projects_from,   // projects from
   projects_to,   // projects to
   property_of,   // Property of
   property_type_of,   // Property type of
   proximal_to,   // proximal to
   qualifier_applies_to,   // qualifier applies to
   quantified_form_of,   // Quantified form of
   quotient_of,   // Quotient of
   receives_attachment_from,   // receives attachment from
   receives_drainage_from,   // receives drainage from
   receives_input_from,   // Receives input from
   receives_projection,   // receives projection
   recipient_category_of,   // Recipient category of
   referred_to_by,   // referred to by
   refers_to,   // refers to
   reformulated_to,   // Reformulated to
   reformulation_of,   // Reformulation of
   regimen_has_accepted_use_for_disease,   // Regimen Has Accepted Use For Disease
   regional_part_of,   // Regional part of
   regulated_by,   // Regulated by
   regulates,   // Regulates
   related_developmental_entity_of,   // related developmental entity of
   related_factor_of,   // Related factor of
   related_object,   // related object
   related_part,   // related part
   related_to_genetic_biomarker,   // related to genetic biomarker
   related_to,   // Is Related to
   relative_to_part_of,   // Relative to part of
   replaced_by,   // Replaced by
   replaces,   // Replaces
   result_of,   // Result of
   revision_status_of,   // Revision status of
   right_lateral_to,   // right lateral to
   right_medial_to,   // right medial to
   risk_factor_of,   // Risk factor of
   role_has_domain,   // role has domain
   role_has_parent,   // role has parent
   role_has_range,   // role has range
   role_is_parent_of,   // role is parent of
   route_of_administration_of_excluded,   // Route of administration of excluded
   route_of_administration_of_possibly_included,   // Route of administration of possibly included
   route_of_administration_of,   // Route of administration of
   same_as,   // Same as
   scale_of,   // Scale of
   scale_type_of,   // Scale type of
   secondary_segmental_supply_of,   // Secondary segmental supply of
   see_from,   // See from
   see,   // See
   segmental_composition_of,   // Segmental composition of
   segmental_supply_of,   // Segmental supply of
   sends_output_to,   // Sends output to
   severity_of,   // Severity of
   sib_in_branch_of,   // Sibling in branch of
   sib_in_isa,   // Sibling in is a
   sib_in_part_of,   // Sibling in part of
   sib_in_tributary_of,   // Sibling in tributary of
   sign_or_symptom_of,   // Sign or symptom of
   site_of_metabolism,   // Site of metabolism
   smaller_than,   // Smaller Than
   sort_version_of,   // Sort version of
   special_category_includes_neoplasm,   // special category includes neoplasm
   specialty_of,   // Specialty of
   specimen_of_excluded,   // Specimen of excluded
   specimen_of,   // Specimen of
   specimen_procedure_of,   // Specimen procedure of
   specimen_source_identity_of,   // Specimen source identity of
   specimen_source_morphology_of,   // Specimen source morphology of
   specimen_source_topography_of,   // specimen source topography of
   specimen_substance_of,   // Specimen substance of
   ssc,   // scc
   stage_of,   // Stage of
   state_of_matter_of,   // State of matter of
   structural_class_of,   // Has structural class
   sub_specimen_included_by,   // Sub specimen included by
   subject_of_information_of,   // Subject of information of
   subject_relationship_context_of,   // Subject relationship context of
   subset_includes_concept,   // subset includes concept
   substance_used_by_excluded,   // Substance used by excluded
   substance_used_by_possibly_included,   // Substance used by possibly included
   substance_used_by,   // Substance used by
   suffix_of,   // Suffix of
   superior_to,   // superior to
   superolateral_to,   // superolateral to
   superomedial_to,   // superomedial to
   supersystem_of,   // Supersystem of
   supported_concept_property_in,   // Supported concept property in
   supported_concept_relationship_in,   // Supported concept relationship in
   surgical_approach_of,   // surgical approach of
   surgical_extent_of_excluded,   // Surgical extent of excluded
   surgical_extent_of_possibly_included,   // Surgical extent of possibly included
   surgical_extent_of,   // Surgical extent of
   surrounded_by,   // Surrounded by
   surrounds,   // Surrounds
   system_of,   // System of
   target_anatomy_has_procedure,   // target anatomy has procedure
   technique_of,   // Technique of
   temporal_context_of,   // Temporal context of
   temporally_followed_by,   // Temporally followed by
   temporally_follows,   // Temporally follows
   temporally_related_to,   // Temporally related to
   therapeutic_class_of,   // Therapeutic class of
   time_aspect_of,   // Time aspect of
   time_modifier_of,   // Time modifier of
   tissue_is_expression_site_of_gene_product,   // tissue is expression site of gene product
   tradename_of,   // Tradename of
   transforms_from,   // transforms from
   transforms_into,   // transforms into
   translation_of,   // Translation of
   transliterated_form_of,   // transliterated_form_of
   treated_by,   // Treated by
   treats,   // Treats
   tributary_of,   // Tributary of
   uniquely_mapped_from,   // Uniquely mapped from
   uniquely_mapped_to,   // Uniquely mapped to
   unit_of_presentation_of,   // Unit of presentation of
   used_by,   // Used by
   used_for,   // Used for
   uses_access_device,   // Uses access device
   uses_device,   // Uses device
   uses_energy,   // Uses energy
   uses_excluded_substance,   // Uses excluded substance
   uses_possibly_included_substance,   // Uses possibly included substance
   uses_substance,   // Uses substance
   uses,   // Uses
   use,   // Use
   venous_drainage_of,   // Venous drainage of
   version_of,   // Version of
   was_a,   // Was a
   wound_has_communication_with,   // Wound has communication with
   UNKNOWN;

   private final String _name;

   Rela() {
      this( "" );
   }

   Rela( String name ) {
      _name = name;
   }

   public String getName() {
      if ( _name.isEmpty() ) {
         return this.name();
      }
      return _name;
   }

   static public Rela getRela( final String name ) {
      return Arrays.stream( values() )
                   .filter( s -> name.equalsIgnoreCase( s.getName() ) )
                   .findFirst()
                   .orElse( UNKNOWN );
   }

}
