/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning;

import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.numbers.core.Precision;

public abstract class AbstractHyperplane<P extends Point<P>>
implements Hyperplane<P> {
    private final Precision.DoubleEquivalence precision;

    protected AbstractHyperplane(Precision.DoubleEquivalence precision) {
        this.precision = precision;
    }

    @Override
    public HyperplaneLocation classify(P point) {
        double offsetValue = this.offset(point);
        double cmp = this.precision.signum(offsetValue);
        if (cmp > 0.0) {
            return HyperplaneLocation.PLUS;
        }
        if (cmp < 0.0) {
            return HyperplaneLocation.MINUS;
        }
        return HyperplaneLocation.ON;
    }

    @Override
    public boolean contains(P point) {
        HyperplaneLocation loc = this.classify(point);
        return loc == HyperplaneLocation.ON;
    }

    public Precision.DoubleEquivalence getPrecision() {
        return this.precision;
    }
}

