/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.util.function.UnaryOperator;
import org.apache.commons.geometry.core.internal.DoubleFunction3N;
import org.apache.commons.geometry.euclidean.AbstractAffineTransformMatrix;
import org.apache.commons.geometry.euclidean.internal.Matrices;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.rotation.QuaternionRotation;

public final class AffineTransformMatrix3D
extends AbstractAffineTransformMatrix<Vector3D, AffineTransformMatrix3D> {
    private static final int NUM_ELEMENTS = 12;
    private static final String MATRIX_START = "[ ";
    private static final String MATRIX_END = " ]";
    private static final String ELEMENT_SEPARATOR = ", ";
    private static final String ROW_SEPARATOR = "; ";
    private static final AffineTransformMatrix3D IDENTITY_INSTANCE = new AffineTransformMatrix3D(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    private final double m00;
    private final double m01;
    private final double m02;
    private final double m03;
    private final double m10;
    private final double m11;
    private final double m12;
    private final double m13;
    private final double m20;
    private final double m21;
    private final double m22;
    private final double m23;

    private AffineTransformMatrix3D(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
    }

    public double[] toArray() {
        return new double[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23};
    }

    public Vector3D apply(Vector3D pt) {
        double x = pt.getX();
        double y = pt.getY();
        double z = pt.getZ();
        return Vector3D.of(this.applyX(x, y, z), this.applyY(x, y, z), this.applyZ(x, y, z));
    }

    public double applyX(double x, double y, double z) {
        return this.applyVectorX(x, y, z) + this.m03;
    }

    public double applyY(double x, double y, double z) {
        return this.applyVectorY(x, y, z) + this.m13;
    }

    public double applyZ(double x, double y, double z) {
        return this.applyVectorZ(x, y, z) + this.m23;
    }

    @Override
    public Vector3D applyVector(Vector3D vec) {
        return (Vector3D)this.applyVector(vec, Vector3D::of);
    }

    public double applyVectorX(double x, double y, double z) {
        return Vectors.linearCombination(this.m00, x, this.m01, y, this.m02, z);
    }

    public double applyVectorY(double x, double y, double z) {
        return Vectors.linearCombination(this.m10, x, this.m11, y, this.m12, z);
    }

    public double applyVectorZ(double x, double y, double z) {
        return Vectors.linearCombination(this.m20, x, this.m21, y, this.m22, z);
    }

    @Override
    public Vector3D.Unit applyDirection(Vector3D vec) {
        return (Vector3D.Unit)this.applyVector(vec, Vector3D.Unit::from);
    }

    @Override
    public double determinant() {
        return Matrices.determinant(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    @Override
    public AffineTransformMatrix3D linear() {
        return new AffineTransformMatrix3D(this.m00, this.m01, this.m02, 0.0, this.m10, this.m11, this.m12, 0.0, this.m20, this.m21, this.m22, 0.0);
    }

    @Override
    public AffineTransformMatrix3D linearTranspose() {
        return new AffineTransformMatrix3D(this.m00, this.m10, this.m20, 0.0, this.m01, this.m11, this.m21, 0.0, this.m02, this.m12, this.m22, 0.0);
    }

    public AffineTransformMatrix3D translate(Vector3D translation) {
        return this.translate(translation.getX(), translation.getY(), translation.getZ());
    }

    public AffineTransformMatrix3D translate(double x, double y, double z) {
        return new AffineTransformMatrix3D(this.m00, this.m01, this.m02, this.m03 + x, this.m10, this.m11, this.m12, this.m13 + y, this.m20, this.m21, this.m22, this.m23 + z);
    }

    public AffineTransformMatrix3D scale(double factor) {
        return this.scale(factor, factor, factor);
    }

    public AffineTransformMatrix3D scale(Vector3D scaleFactors) {
        return this.scale(scaleFactors.getX(), scaleFactors.getY(), scaleFactors.getZ());
    }

    public AffineTransformMatrix3D scale(double x, double y, double z) {
        return new AffineTransformMatrix3D(this.m00 * x, this.m01 * x, this.m02 * x, this.m03 * x, this.m10 * y, this.m11 * y, this.m12 * y, this.m13 * y, this.m20 * z, this.m21 * z, this.m22 * z, this.m23 * z);
    }

    public AffineTransformMatrix3D rotate(QuaternionRotation rotation) {
        return AffineTransformMatrix3D.multiply(rotation.toMatrix(), this);
    }

    public AffineTransformMatrix3D rotate(Vector3D center, QuaternionRotation rotation) {
        return AffineTransformMatrix3D.multiply(AffineTransformMatrix3D.createRotation(center, rotation), this);
    }

    public AffineTransformMatrix3D multiply(AffineTransformMatrix3D m) {
        return AffineTransformMatrix3D.multiply(this, m);
    }

    public AffineTransformMatrix3D premultiply(AffineTransformMatrix3D m) {
        return AffineTransformMatrix3D.multiply(m, this);
    }

    @Override
    public AffineTransformMatrix3D inverse() {
        double det = Matrices.checkDeterminantForInverse(this.determinant());
        Matrices.checkElementForInverse(this.m03);
        Matrices.checkElementForInverse(this.m13);
        Matrices.checkElementForInverse(this.m23);
        double invDet = 1.0 / det;
        double c00 = invDet * Matrices.determinant(this.m11, this.m12, this.m21, this.m22);
        double c01 = -invDet * Matrices.determinant(this.m10, this.m12, this.m20, this.m22);
        double c02 = invDet * Matrices.determinant(this.m10, this.m11, this.m20, this.m21);
        double c10 = -invDet * Matrices.determinant(this.m01, this.m02, this.m21, this.m22);
        double c11 = invDet * Matrices.determinant(this.m00, this.m02, this.m20, this.m22);
        double c12 = -invDet * Matrices.determinant(this.m00, this.m01, this.m20, this.m21);
        double c20 = invDet * Matrices.determinant(this.m01, this.m02, this.m11, this.m12);
        double c21 = -invDet * Matrices.determinant(this.m00, this.m02, this.m10, this.m12);
        double c22 = invDet * Matrices.determinant(this.m00, this.m01, this.m10, this.m11);
        double c30 = -invDet * Matrices.determinant(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m21, this.m22, this.m23);
        double c31 = invDet * Matrices.determinant(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m20, this.m22, this.m23);
        double c32 = -invDet * Matrices.determinant(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m20, this.m21, this.m23);
        return new AffineTransformMatrix3D(c00, c10, c20, c30, c01, c11, c21, c31, c02, c12, c22, c32);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = result * 31 + (Double.hashCode(this.m00) - Double.hashCode(this.m01) + Double.hashCode(this.m02) - Double.hashCode(this.m03));
        result = result * 31 + (Double.hashCode(this.m10) - Double.hashCode(this.m11) + Double.hashCode(this.m12) - Double.hashCode(this.m13));
        result = result * 31 + (Double.hashCode(this.m20) - Double.hashCode(this.m21) + Double.hashCode(this.m22) - Double.hashCode(this.m23));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AffineTransformMatrix3D)) {
            return false;
        }
        AffineTransformMatrix3D other = (AffineTransformMatrix3D)obj;
        return Double.compare(this.m00, other.m00) == 0 && Double.compare(this.m01, other.m01) == 0 && Double.compare(this.m02, other.m02) == 0 && Double.compare(this.m03, other.m03) == 0 && Double.compare(this.m10, other.m10) == 0 && Double.compare(this.m11, other.m11) == 0 && Double.compare(this.m12, other.m12) == 0 && Double.compare(this.m13, other.m13) == 0 && Double.compare(this.m20, other.m20) == 0 && Double.compare(this.m21, other.m21) == 0 && Double.compare(this.m22, other.m22) == 0 && Double.compare(this.m23, other.m23) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MATRIX_START).append(this.m00).append(ELEMENT_SEPARATOR).append(this.m01).append(ELEMENT_SEPARATOR).append(this.m02).append(ELEMENT_SEPARATOR).append(this.m03).append(ROW_SEPARATOR).append(this.m10).append(ELEMENT_SEPARATOR).append(this.m11).append(ELEMENT_SEPARATOR).append(this.m12).append(ELEMENT_SEPARATOR).append(this.m13).append(ROW_SEPARATOR).append(this.m20).append(ELEMENT_SEPARATOR).append(this.m21).append(ELEMENT_SEPARATOR).append(this.m22).append(ELEMENT_SEPARATOR).append(this.m23).append(MATRIX_END);
        return sb.toString();
    }

    private <T> T applyVector(Vector3D vec, DoubleFunction3N<T> factory) {
        double x = vec.getX();
        double y = vec.getY();
        double z = vec.getZ();
        return (T)factory.apply(this.applyVectorX(x, y, z), this.applyVectorY(x, y, z), this.applyVectorZ(x, y, z));
    }

    public static AffineTransformMatrix3D of(double ... arr) {
        if (arr.length != 12) {
            throw new IllegalArgumentException("Dimension mismatch: " + arr.length + " != " + 12);
        }
        return new AffineTransformMatrix3D(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7], arr[8], arr[9], arr[10], arr[11]);
    }

    public static AffineTransformMatrix3D from(UnaryOperator<Vector3D> fn) {
        Vector3D w;
        Vector3D v;
        Vector3D tPlusX = (Vector3D)fn.apply(Vector3D.Unit.PLUS_X);
        Vector3D tPlusY = (Vector3D)fn.apply(Vector3D.Unit.PLUS_Y);
        Vector3D tPlusZ = (Vector3D)fn.apply(Vector3D.Unit.PLUS_Z);
        Vector3D tZero = (Vector3D)fn.apply(Vector3D.ZERO);
        Vector3D u = tPlusX.subtract(tZero);
        AffineTransformMatrix3D mat = AffineTransformMatrix3D.fromColumnVectors(u, v = tPlusY.subtract(tZero), w = tPlusZ.subtract(tZero), tZero);
        double det = mat.determinant();
        if (!Vectors.isRealNonZero(det)) {
            throw new IllegalArgumentException("Transform function is invalid: matrix determinant is " + det);
        }
        return mat;
    }

    public static AffineTransformMatrix3D fromColumnVectors(Vector3D u, Vector3D v, Vector3D w) {
        return AffineTransformMatrix3D.fromColumnVectors(u, v, w, Vector3D.ZERO);
    }

    public static AffineTransformMatrix3D fromColumnVectors(Vector3D u, Vector3D v, Vector3D w, Vector3D t) {
        return new AffineTransformMatrix3D(u.getX(), v.getX(), w.getX(), t.getX(), u.getY(), v.getY(), w.getY(), t.getY(), u.getZ(), v.getZ(), w.getZ(), t.getZ());
    }

    public static AffineTransformMatrix3D identity() {
        return IDENTITY_INSTANCE;
    }

    public static AffineTransformMatrix3D createTranslation(Vector3D translation) {
        return AffineTransformMatrix3D.createTranslation(translation.getX(), translation.getY(), translation.getZ());
    }

    public static AffineTransformMatrix3D createTranslation(double x, double y, double z) {
        return new AffineTransformMatrix3D(1.0, 0.0, 0.0, x, 0.0, 1.0, 0.0, y, 0.0, 0.0, 1.0, z);
    }

    public static AffineTransformMatrix3D createScale(double factor) {
        return AffineTransformMatrix3D.createScale(factor, factor, factor);
    }

    public static AffineTransformMatrix3D createScale(Vector3D factors) {
        return AffineTransformMatrix3D.createScale(factors.getX(), factors.getY(), factors.getZ());
    }

    public static AffineTransformMatrix3D createScale(double x, double y, double z) {
        return new AffineTransformMatrix3D(x, 0.0, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 0.0, z, 0.0);
    }

    public static AffineTransformMatrix3D createRotation(Vector3D center, QuaternionRotation rotation) {
        return AffineTransformMatrix3D.createTranslation(center.negate()).rotate(rotation).translate(center);
    }

    private static AffineTransformMatrix3D multiply(AffineTransformMatrix3D a, AffineTransformMatrix3D b) {
        double c00 = Vectors.linearCombination(a.m00, b.m00, a.m01, b.m10, a.m02, b.m20);
        double c01 = Vectors.linearCombination(a.m00, b.m01, a.m01, b.m11, a.m02, b.m21);
        double c02 = Vectors.linearCombination(a.m00, b.m02, a.m01, b.m12, a.m02, b.m22);
        double c03 = Vectors.linearCombination(a.m00, b.m03, a.m01, b.m13, a.m02, b.m23) + a.m03;
        double c10 = Vectors.linearCombination(a.m10, b.m00, a.m11, b.m10, a.m12, b.m20);
        double c11 = Vectors.linearCombination(a.m10, b.m01, a.m11, b.m11, a.m12, b.m21);
        double c12 = Vectors.linearCombination(a.m10, b.m02, a.m11, b.m12, a.m12, b.m22);
        double c13 = Vectors.linearCombination(a.m10, b.m03, a.m11, b.m13, a.m12, b.m23) + a.m13;
        double c20 = Vectors.linearCombination(a.m20, b.m00, a.m21, b.m10, a.m22, b.m20);
        double c21 = Vectors.linearCombination(a.m20, b.m01, a.m21, b.m11, a.m22, b.m21);
        double c22 = Vectors.linearCombination(a.m20, b.m02, a.m21, b.m12, a.m22, b.m22);
        double c23 = Vectors.linearCombination(a.m20, b.m03, a.m21, b.m13, a.m22, b.m23) + a.m23;
        return new AffineTransformMatrix3D(c00, c01, c02, c03, c10, c11, c12, c13, c20, c21, c22, c23);
    }
}

