/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import org.apache.commons.codec.digest.Blake3;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Blake3Test {
    Blake3Test() {
    }

    private static void assertThrowsProperExceptionWithKeySize(int keySize) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Blake3.initKeyedHash((byte[])new byte[keySize]), (String)"Blake3 keys must be 32 bytes");
    }

    @Test
    void testShouldThrowIllegalArgumentExceptionWhenIncorrectKeySize() {
        for (int i = 0; i < 32; ++i) {
            Blake3Test.assertThrowsProperExceptionWithKeySize(i);
        }
        Blake3Test.assertThrowsProperExceptionWithKeySize(33);
    }
}

