/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.beanutils2.BeanIntrospector;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.SuppressPropertiesBeanIntrospector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Jira157Test {
    private static final Log LOG = LogFactory.getLog(Jira157Test.class);

    @BeforeEach
    protected void setUp() throws Exception {
        BeanUtilsBean custom = new BeanUtilsBean();
        custom.getPropertyUtils().removeBeanIntrospector((BeanIntrospector)SuppressPropertiesBeanIntrospector.SUPPRESS_CLASS);
        BeanUtilsBean.setInstance((BeanUtilsBean)custom);
    }

    @AfterEach
    protected void tearDown() throws Exception {
    }

    @Test
    public void testIssue_BEANUTILS_157_BeanUtils_Describe_Bean() throws Exception {
        FooBar bean = new FooBar();
        Map result = null;
        result = BeanUtils.describe((Object)bean);
        Assertions.assertEquals((int)2, (int)result.size(), (String)"Check Size");
        Assertions.assertTrue((boolean)result.containsKey("class"), (String)"Class");
        Assertions.assertTrue((boolean)result.containsKey("publicFoo"), (String)"publicFoo Key");
        Assertions.assertEquals((Object)"PublicFoo Value", result.get("publicFoo"), (String)"publicFoo Value");
    }

    @Test
    public void testIssue_BEANUTILS_157_BeanUtils_Describe_Interface() throws Exception {
        XY bean = new XY(){

            @Override
            public String getX() {
                return "x-value";
            }

            @Override
            public String getY() {
                return "y-value";
            }
        };
        Map result = BeanUtils.describe((Object)bean);
        Assertions.assertEquals((int)3, (int)result.size(), (String)"Check Size");
        Assertions.assertTrue((boolean)result.containsKey("class"), (String)"Class");
        Assertions.assertTrue((boolean)result.containsKey("x"), (String)"X Key");
        Assertions.assertTrue((boolean)result.containsKey("y"), (String)"Y Key");
        Assertions.assertEquals((Object)"x-value", result.get("x"), (String)"X Value");
        Assertions.assertEquals((Object)"y-value", result.get("y"), (String)"Y Value");
    }

    @Test
    public void testIssue_BEANUTILS_157_BeanUtils_Describe_Serializable() throws Exception {
        Serializable bean = new Serializable(){
            private static final long serialVersionUID = 1L;

            public String getX() {
                return "x-value";
            }

            public String getY() {
                return "y-value";
            }
        };
        Map result = BeanUtils.describe((Object)bean);
        Assertions.assertEquals((int)1, (int)result.size(), (String)"Check Size");
        Assertions.assertTrue((boolean)result.containsKey("class"), (String)"Class");
    }

    public static class FooBar {
        String getPackageFoo() {
            return "Package Value";
        }

        private String getPrivateFoo() {
            return "PrivateFoo Value";
        }

        protected String getProtectedFoo() {
            return "ProtectedFoo Value";
        }

        public String getPublicFoo() {
            return "PublicFoo Value";
        }
    }

    public static interface XY {
        public String getX();

        public String getY();
    }
}

