/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.ArrayStack;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.DigraphIteration;

public class DepthFirstSearch
extends Algorithm {
    protected DigraphIteration factory;
    protected Object firstVertex;
    protected ArrayStack stack = new ArrayStack();
    protected Set seen = new HashSet();

    public DepthFirstSearch(DigraphIteration factory, Object firstVertex) {
        this.factory = factory;
        this.firstVertex = firstVertex;
        this.stack.push((Object)factory.outgoingIterator(firstVertex));
        this.seen.add(firstVertex);
    }

    public void reset(Object newFirstVertex) {
        this.stack.clear();
        this.seen.clear();
        this.firstVertex = newFirstVertex;
        this.stack.push((Object)this.factory.outgoingIterator(this.firstVertex));
        this.seen.add(this.firstVertex);
    }

    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    public Object next() {
        ArcIterator i = (ArcIterator)this.stack.pop();
        Object origin = i.getOrigin();
        while (i.hasNext()) {
            i.next();
            Object dst = i.getDestination();
            if (!this.seen.add(dst)) continue;
            this.stack.push((Object)this.factory.outgoingIterator(dst));
        }
        return origin;
    }
}

