/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.access.jdbc.EJBQLJoinAppender;
import org.apache.cayenne.access.jdbc.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.jdbc.EJBQLTableId;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.CayenneMapEntry;

public abstract class EJBQLPathTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    protected ObjEntity currentEntity;
    protected String lastPathComponent;
    protected String lastAlias;
    protected String idPath;
    protected String joinMarker;
    protected String fullPath;
    private boolean usingAliases;

    public EJBQLPathTranslator(EJBQLTranslationContext context) {
        super(true);
        this.context = context;
        this.usingAliases = true;
    }

    protected abstract void appendMultiColumnPath(EJBQLMultiColumnOperand var1);

    public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex > 0) {
            if (finishedChildIndex + 1 < expression.getChildrenCount()) {
                this.processIntermediatePathComponent();
            } else {
                this.processLastPathComponent();
            }
        }
        return true;
    }

    public boolean visitIdentifier(EJBQLExpression expression) {
        ClassDescriptor descriptor = this.context.getEntityDescriptor(expression.getText());
        if (descriptor == null) {
            throw new EJBQLException("Invalid identification variable: " + expression.getText());
        }
        this.currentEntity = descriptor.getEntity();
        this.idPath = expression.getText();
        this.joinMarker = EJBQLJoinAppender.makeJoinTailMarker(this.idPath);
        this.fullPath = this.idPath;
        return true;
    }

    public boolean visitIdentificationVariable(EJBQLExpression expression) {
        if (this.lastPathComponent != null) {
            this.resolveJoin(true);
        }
        this.lastPathComponent = expression.getText();
        return true;
    }

    protected void resolveJoin(boolean inner) {
        EJBQLJoinAppender joinAppender = this.context.getTranslatorFactory().getJoinAppender(this.context);
        String newPath = this.idPath + '.' + this.lastPathComponent;
        String oldPath = joinAppender.registerReusableJoin(this.idPath, this.lastPathComponent, newPath);
        this.fullPath = this.fullPath + '.' + this.lastPathComponent;
        if (oldPath != null) {
            this.idPath = oldPath;
            Relationship lastRelationship = this.currentEntity.getRelationship(this.lastPathComponent);
            if (lastRelationship != null) {
                ObjEntity targetEntity = (ObjEntity)lastRelationship.getTargetEntity();
                this.lastAlias = this.context.getTableAlias(this.fullPath, targetEntity.getDbEntity().getFullyQualifiedName());
            } else {
                this.lastAlias = this.context.getTableAlias(oldPath, this.currentEntity.getDbEntity().getFullyQualifiedName());
            }
        } else {
            Relationship lastRelationship = this.currentEntity.getRelationship(this.lastPathComponent);
            ObjEntity targetEntity = null;
            targetEntity = lastRelationship != null ? (ObjEntity)lastRelationship.getTargetEntity() : this.currentEntity;
            if (inner) {
                joinAppender.appendInnerJoin(this.joinMarker, new EJBQLTableId(this.idPath), new EJBQLTableId(this.fullPath));
            } else {
                joinAppender.appendOuterJoin(this.joinMarker, new EJBQLTableId(this.idPath), new EJBQLTableId(this.fullPath));
            }
            this.lastAlias = this.context.getTableAlias(this.fullPath, targetEntity.getDbEntity().getFullyQualifiedName());
            this.idPath = newPath;
        }
    }

    protected void processIntermediatePathComponent() {
        ObjRelationship relationship = (ObjRelationship)this.currentEntity.getRelationship(this.lastPathComponent);
        if (relationship == null) {
            throw new EJBQLException("Unknown relationship '" + this.lastPathComponent + "' for entity '" + this.currentEntity.getName() + "'");
        }
        this.currentEntity = (ObjEntity)relationship.getTargetEntity();
    }

    protected void processLastPathComponent() {
        ObjAttribute attribute = (ObjAttribute)this.currentEntity.getAttribute(this.lastPathComponent);
        if (attribute != null) {
            this.processTerminatingAttribute(attribute);
            return;
        }
        ObjRelationship relationship = (ObjRelationship)this.currentEntity.getRelationship(this.lastPathComponent);
        if (relationship != null) {
            this.processTerminatingRelationship(relationship);
            return;
        }
        throw new IllegalStateException("Invalid path component: " + this.lastPathComponent);
    }

    protected void processTerminatingAttribute(ObjAttribute attribute) {
        DbEntity table = null;
        Iterator<CayenneMapEntry> it = attribute.getDbPathIterator();
        while (it.hasNext()) {
            CayenneMapEntry pathComponent = it.next();
            if (!(pathComponent instanceof DbAttribute)) continue;
            table = (DbEntity)((DbAttribute)pathComponent).getEntity();
        }
        if (this.isUsingAliases()) {
            String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, table.getFullyQualifiedName());
            this.context.append(' ').append(alias).append('.').append(attribute.getDbAttributeName());
        } else {
            this.context.append(' ').append(attribute.getDbAttributeName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processTerminatingRelationship(ObjRelationship relationship) {
        if (relationship.isSourceIndependentFromTargetChange()) {
            this.resolveJoin(false);
            DbRelationship dbRelationship = this.chooseDbRelationship(relationship);
            DbEntity table = (DbEntity)dbRelationship.getTargetEntity();
            String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, table.getFullyQualifiedName());
            Collection<DbAttribute> pks = table.getPrimaryKeys();
            if (pks.size() != 1) throw new EJBQLException("Multi-column PK to-many matches are not yet supported.");
            DbAttribute pk = pks.iterator().next();
            this.context.append(' ');
            if (this.isUsingAliases()) {
                this.context.append(alias).append('.');
            }
            this.context.append(pk.getName());
            return;
        } else {
            DbRelationship dbRelationship = this.chooseDbRelationship(relationship);
            DbEntity table = (DbEntity)dbRelationship.getSourceEntity();
            String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, table.getFullyQualifiedName());
            List<DbJoin> joins = dbRelationship.getJoins();
            if (joins.size() == 1) {
                DbJoin join = joins.get(0);
                this.context.append(' ');
                if (this.isUsingAliases()) {
                    this.context.append(alias).append('.');
                }
                this.context.append(join.getSourceName());
                return;
            } else {
                HashMap<String, String> multiColumnMatch = new HashMap<String, String>(joins.size() + 2);
                for (DbJoin join : joins) {
                    String column = this.isUsingAliases() ? alias + "." + join.getSourceName() : join.getSourceName();
                    multiColumnMatch.put(join.getTargetName(), column);
                }
                this.appendMultiColumnPath(EJBQLMultiColumnOperand.getPathOperand(this.context, multiColumnMatch));
            }
        }
    }

    protected DbRelationship chooseDbRelationship(ObjRelationship relationship) {
        List<DbRelationship> dbRelationships = relationship.getDbRelationships();
        String dbRelationshipPath = relationship.getDbRelationshipPath();
        if (dbRelationshipPath.contains(".")) {
            String dbRelName = dbRelationshipPath.substring(dbRelationshipPath.lastIndexOf(".") + 1);
            for (DbRelationship dbR : dbRelationships) {
                if (!dbR.getName().equals(dbRelName)) continue;
                return dbR;
            }
        }
        return relationship.getDbRelationships().get(0);
    }

    public boolean isUsingAliases() {
        return this.usingAliases;
    }

    public void setUsingAliases(boolean usingAliases) {
        this.usingAliases = usingAliases;
    }
}

