/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.ownership;

import com.google.common.collect.ImmutableMap;
import com.twitter.finagle.stats.StatsReceiver;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.distributedlog.client.ClientConfig;
import org.apache.distributedlog.client.stats.OwnershipStatsLogger;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwnershipCache
implements TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(OwnershipCache.class);
    private final ConcurrentHashMap<String, SocketAddress> stream2Addresses = new ConcurrentHashMap();
    private final ConcurrentHashMap<SocketAddress, Set<String>> address2Streams = new ConcurrentHashMap();
    private final ClientConfig clientConfig;
    private final HashedWheelTimer timer;
    private final OwnershipStatsLogger ownershipStatsLogger;

    public OwnershipCache(ClientConfig clientConfig, HashedWheelTimer timer, StatsReceiver statsReceiver, StatsReceiver streamStatsReceiver) {
        this.clientConfig = clientConfig;
        this.timer = timer;
        this.ownershipStatsLogger = new OwnershipStatsLogger(statsReceiver, streamStatsReceiver);
        this.scheduleDumpOwnershipCache();
    }

    private void scheduleDumpOwnershipCache() {
        if (this.clientConfig.isPeriodicDumpOwnershipCacheEnabled() && this.clientConfig.getPeriodicDumpOwnershipCacheIntervalMs() > 0L) {
            this.timer.newTimeout((TimerTask)this, this.clientConfig.getPeriodicDumpOwnershipCacheIntervalMs(), TimeUnit.MILLISECONDS);
        }
    }

    public void run(Timeout timeout) throws Exception {
        if (timeout.isCancelled()) {
            return;
        }
        logger.info("Ownership cache : {} streams cached, {} hosts cached", (Object)this.stream2Addresses.size(), (Object)this.address2Streams.size());
        logger.info("Cached streams : {}", this.stream2Addresses);
        this.scheduleDumpOwnershipCache();
    }

    public OwnershipStatsLogger getOwnershipStatsLogger() {
        return this.ownershipStatsLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateOwner(String stream, SocketAddress addr) {
        HashSet<String> newStreamsForHost;
        SocketAddress oldAddr = this.stream2Addresses.putIfAbsent(stream, addr);
        if (null != oldAddr && oldAddr.equals(addr)) {
            return true;
        }
        if (null != oldAddr) {
            if (!this.stream2Addresses.replace(stream, oldAddr, addr)) {
                logger.warn("Ownership of stream : {} has been changed from {} to {} when storing host : {}.", new Object[]{stream, oldAddr, this.stream2Addresses.get(stream), addr});
                return false;
            }
            logger.info("Storing ownership for stream : {}, old host : {}, new host : {}.", new Object[]{stream, oldAddr, addr});
            StringBuilder sb = new StringBuilder();
            sb.append("Ownership changed '").append(oldAddr).append("' -> '").append(addr).append("'");
            this.removeOwnerFromStream(stream, oldAddr, sb.toString());
            this.ownershipStatsLogger.onRemove(stream);
            this.ownershipStatsLogger.onAdd(stream);
        } else {
            logger.info("Storing ownership for stream : {}, host : {}.", (Object)stream, (Object)addr);
            this.ownershipStatsLogger.onAdd(stream);
        }
        HashSet<String> streamsForHost = this.address2Streams.get(addr);
        if (null == streamsForHost && null == (streamsForHost = (HashSet<String>)this.address2Streams.putIfAbsent(addr, newStreamsForHost = new HashSet<String>()))) {
            streamsForHost = newStreamsForHost;
        }
        HashSet<String> hashSet = streamsForHost;
        synchronized (hashSet) {
            if (!addr.equals(this.stream2Addresses.get(stream))) return true;
            streamsForHost.add(stream);
            return true;
        }
    }

    public SocketAddress getOwner(String stream) {
        SocketAddress address = this.stream2Addresses.get(stream);
        if (null == address) {
            this.ownershipStatsLogger.onMiss(stream);
        } else {
            this.ownershipStatsLogger.onHit(stream);
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOwnerFromStream(String stream, SocketAddress addr, String reason) {
        Set<String> streamsForHost;
        if (this.stream2Addresses.remove(stream, addr)) {
            logger.info("Removed stream to host mapping for (stream: {} -> host: {}) : reason = '{}'.", new Object[]{stream, addr, reason});
        }
        if (null != (streamsForHost = this.address2Streams.get(addr))) {
            Set<String> set = streamsForHost;
            synchronized (set) {
                if (streamsForHost.remove(stream)) {
                    logger.info("Removed stream ({}) from host {} : reason = '{}'.", new Object[]{stream, addr, reason});
                    if (streamsForHost.isEmpty()) {
                        this.address2Streams.remove(addr, streamsForHost);
                    }
                    this.ownershipStatsLogger.onRemove(stream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllStreamsFromOwner(SocketAddress addr) {
        logger.info("Remove streams mapping for host {}", (Object)addr);
        Set<String> streamsForHost = this.address2Streams.get(addr);
        if (null != streamsForHost) {
            Set<String> set = streamsForHost;
            synchronized (set) {
                for (String s : streamsForHost) {
                    if (!this.stream2Addresses.remove(s, addr)) continue;
                    logger.info("Removing mapping for stream : {} from host : {}", (Object)s, (Object)addr);
                    this.ownershipStatsLogger.onRemove(s);
                }
                this.address2Streams.remove(addr, streamsForHost);
            }
        }
    }

    public int getNumCachedStreams() {
        return this.stream2Addresses.size();
    }

    public Map<SocketAddress, Set<String>> getStreamOwnershipDistribution() {
        return ImmutableMap.copyOf(this.address2Streams);
    }

    public Map<String, SocketAddress> getStreamOwnerMapping() {
        return this.stream2Addresses;
    }
}

