/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.base.Preconditions;

public interface Random {
    public double nextDouble();

    public int nextInt(int var1);

    public static class Util {
        private Util() {
        }

        public static Random newDefaultRandom() {
            return new SystemRandom(new java.util.Random());
        }

        public static Random fromSystemRandom(java.util.Random rand) {
            return new SystemRandom(rand);
        }
    }

    public static class SystemRandom
    implements Random {
        private final java.util.Random rand;

        public SystemRandom(java.util.Random rand) {
            this.rand = (java.util.Random)Preconditions.checkNotNull((Object)rand);
        }

        @Override
        public double nextDouble() {
            return this.rand.nextDouble();
        }

        @Override
        public int nextInt(int n) {
            return this.rand.nextInt(n);
        }
    }
}

