/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args.parsers;

import com.google.common.base.Preconditions;
import com.twitter.common.args.Parser;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.TypeUtil;
import java.lang.reflect.Type;
import java.util.List;

public abstract class TypeParameterizedParser<T>
implements Parser<T> {
    private final int typeParamCount;

    TypeParameterizedParser(int typeParamCount) {
        this.typeParamCount = typeParamCount;
    }

    abstract T doParse(ParserOracle var1, String var2, List<Type> var3) throws IllegalArgumentException;

    public T parse(ParserOracle parserOracle, Type type, String raw) {
        List<Type> typeParams = TypeUtil.getTypeParams(type);
        Preconditions.checkArgument((typeParams.size() == this.typeParamCount ? 1 : 0) != 0, (Object)String.format("Expected %d type parameters for %s but got %d", this.typeParamCount, type, typeParams.size()));
        return this.doParse(parserOracle, raw, typeParams);
    }
}

