/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import bk-shade.com.google.common.annotations.VisibleForTesting;
import bk-shade.com.google.common.base.Optional;
import bk-shade.com.google.common.base.Preconditions;
import bk-shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.BookieWatcher;
import org.apache.bookkeeper.client.DefaultSpeculativeRequestExecutionPolicy;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.LedgerCreateOp;
import org.apache.bookkeeper.client.LedgerDeleteOp;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.LedgerOpenOp;
import org.apache.bookkeeper.client.SpeculativeRequestExecutionPolicy;
import org.apache.bookkeeper.client.SynchCallbackUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.feature.SettableFeatureProvider;
import org.apache.bookkeeper.meta.CleanupLedgerManager;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.bookkeeper.util.SafeRunnable;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.SystemUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeper
implements AutoCloseable {
    static final Logger LOG = LoggerFactory.getLogger(BookKeeper.class);
    final ZooKeeper zk;
    final EventLoopGroup eventLoopGroup;
    private final StatsLogger statsLogger;
    private OpStatsLogger createOpLogger;
    private OpStatsLogger openOpLogger;
    private OpStatsLogger deleteOpLogger;
    private OpStatsLogger recoverOpLogger;
    private OpStatsLogger readOpLogger;
    private OpStatsLogger readLacAndEntryOpLogger;
    private OpStatsLogger readLacAndEntryRespLogger;
    private OpStatsLogger addOpLogger;
    private OpStatsLogger writeLacOpLogger;
    private OpStatsLogger readLacOpLogger;
    private OpStatsLogger recoverAddEntriesStats;
    private OpStatsLogger recoverReadEntriesStats;
    boolean ownEventLoopGroup = false;
    boolean ownZKHandle = false;
    final BookieClient bookieClient;
    final BookieWatcher bookieWatcher;
    final OrderedSafeExecutor mainWorkerPool;
    final ScheduledExecutorService scheduler;
    final HashedWheelTimer requestTimer;
    final boolean ownTimer;
    final FeatureProvider featureProvider;
    final ScheduledExecutorService bookieInfoScheduler;
    final Feature disableEnsembleChangeFeature;
    final LedgerManagerFactory ledgerManagerFactory;
    final LedgerManager ledgerManager;
    final LedgerIdGenerator ledgerIdGenerator;
    final EnsemblePlacementPolicy placementPolicy;
    BookieInfoReader bookieInfoReader;
    final ClientConfiguration conf;
    final int explicitLacInterval;
    final boolean delayEnsembleChange;
    final boolean reorderReadSequence;
    final Optional<SpeculativeRequestExecutionPolicy> readSpeculativeRequestPolicy;
    final Optional<SpeculativeRequestExecutionPolicy> readLACSpeculativeRequestPolicy;
    boolean closed = false;
    final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();

    public static Builder forConfig(ClientConfiguration conf) {
        return new Builder(conf);
    }

    public BookKeeper(String servers) throws IOException, InterruptedException, KeeperException {
        this(new ClientConfiguration().setZkServers(servers));
    }

    public BookKeeper(ClientConfiguration conf) throws IOException, InterruptedException, KeeperException {
        this(conf, null, null, (StatsLogger)NullStatsLogger.INSTANCE, null, null, null);
    }

    private static ZooKeeper validateZooKeeper(ZooKeeper zk) throws NullPointerException {
        Preconditions.checkNotNull(zk, "No zookeeper instance provided");
        return zk;
    }

    private static EventLoopGroup validateEventLoopGroup(EventLoopGroup eventLoopGroup) throws NullPointerException {
        Preconditions.checkNotNull(eventLoopGroup, "No Event Loop Group provided");
        return eventLoopGroup;
    }

    public BookKeeper(ClientConfiguration conf, ZooKeeper zk) throws IOException, InterruptedException, KeeperException {
        this(conf, BookKeeper.validateZooKeeper(zk), null, (StatsLogger)NullStatsLogger.INSTANCE, null, null, null);
    }

    public BookKeeper(ClientConfiguration conf, ZooKeeper zk, EventLoopGroup eventLoopGroup) throws IOException, InterruptedException, KeeperException {
        this(conf, BookKeeper.validateZooKeeper(zk), BookKeeper.validateEventLoopGroup(eventLoopGroup), (StatsLogger)NullStatsLogger.INSTANCE, null, null, null);
    }

    private BookKeeper(ClientConfiguration conf, ZooKeeper zkc, EventLoopGroup eventLoopGroup, StatsLogger statsLogger, DNSToSwitchMapping dnsResolver, HashedWheelTimer requestTimer, FeatureProvider featureProvider) throws IOException, InterruptedException, KeeperException {
        this.conf = conf;
        this.delayEnsembleChange = conf.getDelayEnsembleChange();
        this.reorderReadSequence = conf.isReorderReadSequenceEnabled();
        if (zkc == null) {
            this.zk = ZooKeeperClient.newBuilder().connectString(conf.getZkServers()).sessionTimeoutMs(conf.getZkTimeout()).operationRetryPolicy(new BoundExponentialBackoffRetryPolicy(conf.getZkTimeout(), conf.getZkTimeout(), 0)).statsLogger(statsLogger).build();
            this.ownZKHandle = true;
        } else {
            if (!zkc.getState().isConnected()) {
                LOG.error("Unconnected zookeeper handle passed to bookkeeper");
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS);
            }
            this.zk = zkc;
            this.ownZKHandle = false;
        }
        if (null == eventLoopGroup) {
            this.eventLoopGroup = BookKeeper.getDefaultEventLoopGroup();
            this.ownEventLoopGroup = true;
        } else {
            this.eventLoopGroup = eventLoopGroup;
            this.ownEventLoopGroup = false;
        }
        if (null == requestTimer) {
            this.requestTimer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("BookieClientTimer-%d").build(), conf.getTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, conf.getTimeoutTimerNumTicks());
            this.ownTimer = true;
        } else {
            this.requestTimer = requestTimer;
            this.ownTimer = false;
        }
        this.featureProvider = null == featureProvider ? SettableFeatureProvider.DISABLE_ALL : featureProvider;
        this.disableEnsembleChangeFeature = this.featureProvider.getFeature(conf.getDisableEnsembleChangeFeatureName());
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setNameFormat("BookKeeperClientScheduler-%d");
        this.scheduler = Executors.newSingleThreadScheduledExecutor(tfb.build());
        this.statsLogger = statsLogger.scope("bookkeeper_client");
        this.initOpLoggers(this.statsLogger);
        this.placementPolicy = this.initializeEnsemblePlacementPolicy(conf, dnsResolver, this.requestTimer, this.featureProvider, this.statsLogger);
        this.readSpeculativeRequestPolicy = conf.getFirstSpeculativeReadTimeout() > 0 ? Optional.of(new DefaultSpeculativeRequestExecutionPolicy(conf.getFirstSpeculativeReadTimeout(), conf.getMaxSpeculativeReadTimeout(), conf.getSpeculativeReadTimeoutBackoffMultiplier())) : Optional.absent();
        this.readLACSpeculativeRequestPolicy = conf.getFirstSpeculativeReadLACTimeout() > 0 ? Optional.of(new DefaultSpeculativeRequestExecutionPolicy(conf.getFirstSpeculativeReadLACTimeout(), conf.getMaxSpeculativeReadLACTimeout(), conf.getSpeculativeReadLACTimeoutBackoffMultiplier())) : Optional.absent();
        this.mainWorkerPool = OrderedSafeExecutor.newBuilder().name("BookKeeperClientWorker").numThreads(conf.getNumWorkerThreads()).statsLogger(statsLogger).traceTaskExecution(conf.getEnableTaskExecutionStats()).traceTaskWarnTimeMicroSec(conf.getTaskExecutionWarnTimeMicros()).build();
        this.bookieClient = new BookieClient(conf, this.eventLoopGroup, this.mainWorkerPool, statsLogger);
        this.bookieWatcher = new BookieWatcher(conf, this.scheduler, this.placementPolicy, this);
        if (conf.getDiskWeightBasedPlacementEnabled()) {
            LOG.info("Weighted ledger placement enabled");
            ThreadFactoryBuilder tFBuilder = new ThreadFactoryBuilder().setNameFormat("BKClientMetaDataPollScheduler-%d");
            this.bookieInfoScheduler = Executors.newSingleThreadScheduledExecutor(tFBuilder.build());
            this.bookieInfoReader = new BookieInfoReader(this, conf, this.bookieInfoScheduler);
            this.bookieWatcher.readBookiesBlocking();
            this.bookieInfoReader.start();
        } else {
            LOG.info("Weighted ledger placement is not enabled");
            this.bookieInfoScheduler = null;
            this.bookieInfoReader = new BookieInfoReader(this, conf, null);
            this.bookieWatcher.readBookiesBlocking();
        }
        this.ledgerManagerFactory = LedgerManagerFactory.newLedgerManagerFactory(conf, this.zk);
        this.ledgerManager = new CleanupLedgerManager(this.ledgerManagerFactory.newLedgerManager());
        this.ledgerIdGenerator = this.ledgerManagerFactory.newLedgerIdGenerator();
        this.explicitLacInterval = conf.getExplictLacInterval();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Explicit LAC Interval : {}", (Object)this.explicitLacInterval);
        }
        this.scheduleBookieHealthCheckIfEnabled();
    }

    public int getExplicitLacInterval() {
        return this.explicitLacInterval;
    }

    private EnsemblePlacementPolicy initializeEnsemblePlacementPolicy(ClientConfiguration conf, DNSToSwitchMapping dnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger) throws IOException {
        try {
            Class<? extends EnsemblePlacementPolicy> policyCls = conf.getEnsemblePlacementPolicy();
            return ReflectionUtils.newInstance(policyCls).initialize(conf, java.util.Optional.ofNullable(dnsResolver), timer, featureProvider, statsLogger);
        }
        catch (ConfigurationException e) {
            throw new IOException("Failed to initialize ensemble placement policy : ", e);
        }
    }

    int getReturnRc(int rc) {
        if (0 == rc) {
            return rc;
        }
        if (this.bookieClient.isClosed()) {
            return -19;
        }
        return rc;
    }

    void scheduleBookieHealthCheckIfEnabled() {
        if (this.conf.isBookieHealthCheckEnabled()) {
            this.scheduler.scheduleAtFixedRate(new SafeRunnable(){

                @Override
                public void safeRun() {
                    BookKeeper.this.checkForFaultyBookies();
                }
            }, this.conf.getBookieHealthCheckIntervalSeconds(), this.conf.getBookieHealthCheckIntervalSeconds(), TimeUnit.SECONDS);
        }
    }

    void checkForFaultyBookies() {
        List<BookieSocketAddress> faultyBookies = this.bookieClient.getFaultyBookies();
        for (BookieSocketAddress faultyBookie : faultyBookies) {
            this.bookieWatcher.quarantineBookie(faultyBookie);
        }
    }

    LedgerManager getLedgerManager() {
        return this.ledgerManager;
    }

    @VisibleForTesting
    LedgerManager getUnderlyingLedgerManager() {
        return ((CleanupLedgerManager)this.ledgerManager).getUnderlying();
    }

    LedgerIdGenerator getLedgerIdGenerator() {
        return this.ledgerIdGenerator;
    }

    ZooKeeper getZkHandle() {
        return this.zk;
    }

    protected ClientConfiguration getConf() {
        return this.conf;
    }

    StatsLogger getStatsLogger() {
        return this.statsLogger;
    }

    public Optional<SpeculativeRequestExecutionPolicy> getReadSpeculativeRequestPolicy() {
        return this.readSpeculativeRequestPolicy;
    }

    public Optional<SpeculativeRequestExecutionPolicy> getReadLACSpeculativeRequestPolicy() {
        return this.readLACSpeculativeRequestPolicy;
    }

    BookieClient getBookieClient() {
        return this.bookieClient;
    }

    public Map<BookieSocketAddress, BookieInfoReader.BookieInfo> getBookieInfo() throws BKException, InterruptedException {
        return this.bookieInfoReader.getBookieInfo();
    }

    public void asyncCreateLedger(int ensSize, int writeQuorumSize, DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx) {
        this.asyncCreateLedger(ensSize, writeQuorumSize, writeQuorumSize, digestType, passwd, cb, ctx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncCreateLedger(int ensSize, int writeQuorumSize, int ackQuorumSize, DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx, Map<String, byte[]> customMetadata) {
        if (writeQuorumSize < ackQuorumSize) {
            throw new IllegalArgumentException("Write quorum must be larger than ack quorum");
        }
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                cb.createComplete(-19, null, ctx);
                return;
            }
            new LedgerCreateOp(this, ensSize, writeQuorumSize, ackQuorumSize, digestType, passwd, cb, ctx, customMetadata).initiate();
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    public LedgerHandle createLedger(DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        return this.createLedger(3, 2, digestType, passwd);
    }

    public LedgerHandle createLedger(int ensSize, int qSize, DigestType digestType, byte[] passwd) throws InterruptedException, BKException {
        return this.createLedger(ensSize, qSize, qSize, digestType, passwd, null);
    }

    public LedgerHandle createLedger(int ensSize, int writeQuorumSize, int ackQuorumSize, DigestType digestType, byte[] passwd) throws InterruptedException, BKException {
        return this.createLedger(ensSize, writeQuorumSize, ackQuorumSize, digestType, passwd, null);
    }

    public LedgerHandle createLedger(int ensSize, int writeQuorumSize, int ackQuorumSize, DigestType digestType, byte[] passwd, Map<String, byte[]> customMetadata) throws InterruptedException, BKException {
        CompletableFuture counter = new CompletableFuture();
        this.asyncCreateLedger(ensSize, writeQuorumSize, ackQuorumSize, digestType, passwd, new SyncCreateCallback(), counter, customMetadata);
        LedgerHandle lh = (LedgerHandle)SynchCallbackUtils.waitForResult(counter);
        if (lh == null) {
            LOG.error("Unexpected condition : no ledger handle returned for a success ledger creation");
            throw BKException.create(-999);
        }
        return lh;
    }

    public LedgerHandle createLedgerAdv(int ensSize, int writeQuorumSize, int ackQuorumSize, DigestType digestType, byte[] passwd) throws InterruptedException, BKException {
        return this.createLedgerAdv(ensSize, writeQuorumSize, ackQuorumSize, digestType, passwd, null);
    }

    public LedgerHandle createLedgerAdv(int ensSize, int writeQuorumSize, int ackQuorumSize, DigestType digestType, byte[] passwd, Map<String, byte[]> customMetadata) throws InterruptedException, BKException {
        CompletableFuture counter = new CompletableFuture();
        this.asyncCreateLedgerAdv(ensSize, writeQuorumSize, ackQuorumSize, digestType, passwd, new SyncCreateCallback(), counter, customMetadata);
        LedgerHandle lh = (LedgerHandle)SynchCallbackUtils.waitForResult(counter);
        if (lh == null) {
            LOG.error("Unexpected condition : no ledger handle returned for a success ledger creation");
            throw BKException.create(-999);
        }
        return lh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncCreateLedgerAdv(int ensSize, int writeQuorumSize, int ackQuorumSize, DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx, Map<String, byte[]> customMetadata) {
        if (writeQuorumSize < ackQuorumSize) {
            throw new IllegalArgumentException("Write quorum must be larger than ack quorum");
        }
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                cb.createComplete(-19, null, ctx);
                return;
            }
            new LedgerCreateOp(this, ensSize, writeQuorumSize, ackQuorumSize, digestType, passwd, cb, ctx, customMetadata).initiateAdv(-1L);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    public LedgerHandle createLedgerAdv(long ledgerId, int ensSize, int writeQuorumSize, int ackQuorumSize, DigestType digestType, byte[] passwd, Map<String, byte[]> customMetadata) throws InterruptedException, BKException {
        CompletableFuture counter = new CompletableFuture();
        this.asyncCreateLedgerAdv(ledgerId, ensSize, writeQuorumSize, ackQuorumSize, digestType, passwd, new SyncCreateCallback(), counter, customMetadata);
        LedgerHandle lh = (LedgerHandle)SynchCallbackUtils.waitForResult(counter);
        if (lh == null) {
            LOG.error("Unexpected condition : no ledger handle returned for a success ledger creation");
            throw BKException.create(-999);
        }
        if (ledgerId != lh.getId()) {
            LOG.error("Unexpected condition : Expected ledgerId: {} but got: {}", (Object)ledgerId, (Object)lh.getId());
            throw BKException.create(-999);
        }
        LOG.info("Ensemble: {} for ledger: {}", lh.getLedgerMetadata().getEnsemble(0L), (Object)lh.getId());
        return lh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncCreateLedgerAdv(long ledgerId, int ensSize, int writeQuorumSize, int ackQuorumSize, DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx, Map<String, byte[]> customMetadata) {
        if (writeQuorumSize < ackQuorumSize) {
            throw new IllegalArgumentException("Write quorum must be larger than ack quorum");
        }
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                cb.createComplete(-19, null, ctx);
                return;
            }
            new LedgerCreateOp(this, ensSize, writeQuorumSize, ackQuorumSize, digestType, passwd, cb, ctx, customMetadata).initiateAdv(ledgerId);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOpenLedger(long lId, DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                cb.openComplete(-19, null, ctx);
                return;
            }
            new LedgerOpenOp(this, lId, digestType, passwd, cb, ctx).initiate();
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOpenLedgerNoRecovery(long lId, DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                cb.openComplete(-19, null, ctx);
                return;
            }
            new LedgerOpenOp(this, lId, digestType, passwd, cb, ctx).initiateWithoutRecovery();
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    public LedgerHandle openLedger(long lId, DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        CompletableFuture counter = new CompletableFuture();
        this.asyncOpenLedger(lId, digestType, passwd, new SyncOpenCallback(), counter);
        return (LedgerHandle)SynchCallbackUtils.waitForResult(counter);
    }

    public LedgerHandle openLedgerNoRecovery(long lId, DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        CompletableFuture counter = new CompletableFuture();
        this.asyncOpenLedgerNoRecovery(lId, digestType, passwd, new SyncOpenCallback(), counter);
        return (LedgerHandle)SynchCallbackUtils.waitForResult(counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDeleteLedger(long lId, AsyncCallback.DeleteCallback cb, Object ctx) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                cb.deleteComplete(-19, ctx);
                return;
            }
            new LedgerDeleteOp(this, lId, cb, ctx).initiate();
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    public void deleteLedger(long lId) throws InterruptedException, BKException {
        CompletableFuture counter = new CompletableFuture();
        this.asyncDeleteLedger(lId, new SyncDeleteCallback(), counter);
        SynchCallbackUtils.waitForResult(counter);
    }

    public void asyncIsClosed(long lId, final AsyncCallback.IsClosedCallback cb, final Object ctx) {
        this.ledgerManager.readLedgerMetadata(lId, new BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata>(){

            @Override
            public void operationComplete(int rc, LedgerMetadata lm) {
                if (rc == 0) {
                    cb.isClosedComplete(rc, lm.isClosed(), ctx);
                } else {
                    cb.isClosedComplete(rc, false, ctx);
                }
            }
        });
    }

    public boolean isClosed(long lId) throws BKException, InterruptedException {
        final class Result {
            int rc;
            boolean isClosed;
            final CountDownLatch notifier = new CountDownLatch(1);

            Result() {
            }
        }
        final Result result = new Result();
        AsyncCallback.IsClosedCallback cb = new AsyncCallback.IsClosedCallback(){
            {
            }

            @Override
            public void isClosedComplete(int rc, boolean isClosed, Object ctx) {
                result.isClosed = isClosed;
                result.rc = rc;
                result.notifier.countDown();
            }
        };
        this.asyncIsClosed(lId, cb, null);
        result.notifier.await();
        if (result.rc != 0) {
            throw BKException.create(result.rc);
        }
        return result.isClosed;
    }

    @Override
    public void close() throws InterruptedException, BKException {
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.bookieClient.close();
        try {
            this.ledgerManager.close();
            this.ledgerIdGenerator.close();
            this.ledgerManagerFactory.uninitialize();
        }
        catch (IOException ie) {
            LOG.error("Failed to close ledger manager : ", (Throwable)ie);
        }
        this.scheduler.shutdown();
        if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
            LOG.warn("The scheduler did not shutdown cleanly");
        }
        this.mainWorkerPool.shutdown();
        if (!this.mainWorkerPool.awaitTermination(10L, TimeUnit.SECONDS)) {
            LOG.warn("The mainWorkerPool did not shutdown cleanly");
        }
        if (this.bookieInfoScheduler != null) {
            this.bookieInfoScheduler.shutdown();
            if (!this.bookieInfoScheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOG.warn("The bookieInfoScheduler did not shutdown cleanly");
            }
        }
        if (this.ownTimer) {
            this.requestTimer.stop();
        }
        if (this.ownEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully();
        }
        if (this.ownZKHandle) {
            this.zk.close();
        }
    }

    private final void initOpLoggers(StatsLogger stats) {
        this.createOpLogger = stats.getOpStatsLogger("LEDGER_CREATE");
        this.deleteOpLogger = stats.getOpStatsLogger("LEDGER_DELETE");
        this.openOpLogger = stats.getOpStatsLogger("LEDGER_OPEN");
        this.recoverOpLogger = stats.getOpStatsLogger("LEDGER_RECOVER");
        this.readOpLogger = stats.getOpStatsLogger("READ_ENTRY");
        this.readLacAndEntryOpLogger = stats.getOpStatsLogger("READ_LAST_CONFIRMED_AND_ENTRY");
        this.readLacAndEntryRespLogger = stats.getOpStatsLogger("READ_LAST_CONFIRMED_AND_ENTRY_RESPONSE");
        this.addOpLogger = stats.getOpStatsLogger("ADD_ENTRY");
        this.writeLacOpLogger = stats.getOpStatsLogger("WRITE_LAC");
        this.readLacOpLogger = stats.getOpStatsLogger("READ_LAC");
        this.recoverAddEntriesStats = stats.getOpStatsLogger("LEDGER_RECOVER_ADD_ENTRIES");
        this.recoverReadEntriesStats = stats.getOpStatsLogger("LEDGER_RECOVER_READ_ENTRIES");
    }

    OpStatsLogger getCreateOpLogger() {
        return this.createOpLogger;
    }

    OpStatsLogger getOpenOpLogger() {
        return this.openOpLogger;
    }

    OpStatsLogger getDeleteOpLogger() {
        return this.deleteOpLogger;
    }

    OpStatsLogger getRecoverOpLogger() {
        return this.recoverOpLogger;
    }

    OpStatsLogger getReadOpLogger() {
        return this.readOpLogger;
    }

    OpStatsLogger getReadLacAndEntryOpLogger() {
        return this.readLacAndEntryOpLogger;
    }

    OpStatsLogger getReadLacAndEntryRespLogger() {
        return this.readLacAndEntryRespLogger;
    }

    OpStatsLogger getAddOpLogger() {
        return this.addOpLogger;
    }

    OpStatsLogger getWriteLacOpLogger() {
        return this.writeLacOpLogger;
    }

    OpStatsLogger getReadLacOpLogger() {
        return this.readLacOpLogger;
    }

    OpStatsLogger getRecoverAddCountLogger() {
        return this.recoverAddEntriesStats;
    }

    OpStatsLogger getRecoverReadCountLogger() {
        return this.recoverReadEntriesStats;
    }

    static EventLoopGroup getDefaultEventLoopGroup() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("bookkeeper-io-%s").build();
        int numThreads = Runtime.getRuntime().availableProcessors() * 2;
        if (SystemUtils.IS_OS_LINUX) {
            try {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
            catch (Throwable t) {
                LOG.warn("Could not use Netty Epoll event loop for bookie server: {}", (Object)t.getMessage());
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
        }
        return new NioEventLoopGroup(numThreads, threadFactory);
    }

    private static class SyncDeleteCallback
    implements AsyncCallback.DeleteCallback {
        private SyncDeleteCallback() {
        }

        @Override
        public void deleteComplete(int rc, Object ctx) {
            SynchCallbackUtils.finish(rc, null, (CompletableFuture)ctx);
        }
    }

    static class SyncOpenCallback
    implements AsyncCallback.OpenCallback {
        SyncOpenCallback() {
        }

        @Override
        public void openComplete(int rc, LedgerHandle lh, Object ctx) {
            SynchCallbackUtils.finish(rc, lh, (CompletableFuture)ctx);
        }
    }

    private static class SyncCreateCallback
    implements AsyncCallback.CreateCallback {
        private SyncCreateCallback() {
        }

        @Override
        public void createComplete(int rc, LedgerHandle lh, Object ctx) {
            SynchCallbackUtils.finish(rc, lh, (CompletableFuture)ctx);
        }
    }

    public static enum DigestType {
        MAC,
        CRC32;

    }

    public static class Builder {
        final ClientConfiguration conf;
        ZooKeeper zk = null;
        EventLoopGroup eventLoopGroup = null;
        StatsLogger statsLogger = NullStatsLogger.INSTANCE;
        DNSToSwitchMapping dnsResolver = null;
        HashedWheelTimer requestTimer = null;
        FeatureProvider featureProvider = null;

        Builder(ClientConfiguration conf) {
            this.conf = conf;
        }

        @Deprecated
        public Builder setEventLoopGroup(EventLoopGroup f) {
            this.eventLoopGroup = f;
            return this;
        }

        @Deprecated
        public Builder setZookeeper(ZooKeeper zk) {
            this.zk = zk;
            return this;
        }

        @Deprecated
        public Builder setStatsLogger(StatsLogger statsLogger) {
            this.statsLogger = statsLogger;
            return this;
        }

        public Builder eventLoopGroup(EventLoopGroup f) {
            this.eventLoopGroup = f;
            return this;
        }

        public Builder zk(ZooKeeper zk) {
            this.zk = zk;
            return this;
        }

        public Builder statsLogger(StatsLogger statsLogger) {
            this.statsLogger = statsLogger;
            return this;
        }

        public Builder dnsResolver(DNSToSwitchMapping dnsResolver) {
            this.dnsResolver = dnsResolver;
            return this;
        }

        public Builder requestTimer(HashedWheelTimer requestTimer) {
            this.requestTimer = requestTimer;
            return this;
        }

        public Builder featureProvider(FeatureProvider featureProvider) {
            this.featureProvider = featureProvider;
            return this;
        }

        public BookKeeper build() throws IOException, InterruptedException, KeeperException {
            Preconditions.checkNotNull(this.statsLogger, "No stats logger provided");
            return new BookKeeper(this.conf, this.zk, this.eventLoopGroup, this.statsLogger, this.dnsResolver, this.requestTimer, this.featureProvider);
        }
    }
}

